/*
 * Decompiled with CFR 0.152.
 */
package com.amarula.gen2wave.sdk.usbaccessory;

import android.content.Context;
import android.content.Intent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;

public class AccessoryPower {
    public static final String TAG = "AccessoryPower";
    private static final String Gen2Wave_USB_ACCESSARY_POWER_ACTION = "com.android.gen2wave.USB_POWER";
    private static final String RP_USB_ACC_POWER = "rp_usb_acc_power";
    private static final String RP_USB_ACC_POWER_PATH = "rp_usb_acc_power_path";

    public static void setPower(Context context, AccessoryType type, boolean en) {
        Intent it = new Intent();
        it.setAction(Gen2Wave_USB_ACCESSARY_POWER_ACTION);
        it.putExtra(RP_USB_ACC_POWER_PATH, type.getPath());
        it.putExtra(RP_USB_ACC_POWER, en);
        context.sendBroadcast(it);
    }

    private static boolean isSwitchValueOn(String path) {
        File input = new File(path);
        byte[] dataBytes = new byte[5];
        Arrays.fill(dataBytes, (byte)0);
        try {
            FileInputStream fis = new FileInputStream(input);
            fis.read(dataBytes);
            fis.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return dataBytes[0] == 49;
    }

    public static boolean powerEnabled(AccessoryType type) {
        return AccessoryPower.isSwitchValueOn(type.getPath());
    }

    public static enum AccessoryType {
        FINGERPRINTER("/sys/devices/platform/rp-pm/bio_fp_en/value"),
        MRZ("/sys/devices/platform/rp-pm/bio_mrz_en/value"),
        SAM("/sys/devices/platform/rp-pm/bio_sam_en/value"),
        SMARTCARD("/sys/devices/platform/rp-pm/bio_smart_en/value");

        protected String path;

        private AccessoryType(String path) {
            this.path = path;
        }

        public String getPath() {
            return this.path;
        }
    }
}

