/*
 * Decompiled with CFR 0.152.
 */
package com.amarula.gen2wave.sdk.rfid;

import android.util.Log;
import com.amarula.gen2wave.sdk.util.SerialPort;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

public class RfidPort
extends SerialPort {
    private static final String TAG = "RfidPort";
    private static final String RFID_EN_PATH = "/sys/devices/gen2wave-pm/rfid_en/value";
    private static final String RFID_TTY_PATH = "/dev/ttySC2";

    public RfidPort() throws IOException {
        this.setRfidEnabled(true);
        this.mFd = this.open(RFID_TTY_PATH, 9600, false);
        if (this.mFd < 0) {
            throw new IOException("Error " + this.mFd + " opening " + RFID_TTY_PATH);
        }
    }

    public RfidPort(int baudrate, int poflag) throws IOException {
        if (poflag == 1) {
            this.setRfidEnabled(true);
        }
        this.mFd = this.open(RFID_TTY_PATH, baudrate, false);
        if (this.mFd < 0) {
            throw new IOException("Error " + this.mFd + " opening " + RFID_TTY_PATH);
        }
    }

    public int RfidChangeBaudrate(int baudrate) throws IOException {
        super.close();
        this.mFd = this.open(RFID_TTY_PATH, baudrate, false);
        if (this.mFd < 0) {
            throw new IOException("Error " + this.mFd + " opening " + RFID_TTY_PATH);
        }
        return 1;
    }

    @Override
    public int close() {
        this.setRfidEnabled(false);
        return super.close();
    }

    public int close(int poflag) {
        if (poflag == 1) {
            this.setRfidEnabled(false);
        }
        return super.close();
    }

    private boolean setRfidEnabled(boolean enabled) {
        File f = new File(RFID_EN_PATH);
        if (!f.exists() || !f.canWrite()) {
            throw new SecurityException("This application does not hold permission:com.amarula.permission.RFID");
        }
        String s = enabled ? "1" : "0";
        s = s + "\n";
        try {
            FileWriter fw = new FileWriter(f);
            fw.write(s);
            fw.flush();
            fw.close();
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)"Cannot modify RFID state");
            e.printStackTrace();
            return false;
        }
        return true;
    }
}

