/*
 * Decompiled with CFR 0.152.
 */
package com.amarula.barcodescanner.sdk;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;
import com.amarula.barcodescanner.sdk.BarcodeScanner;
import com.amarula.barcodescanner.sdk.BarcodeScannerConnectionInterface;
import com.amarula.barcodescanner.sdk.IBarcodeScannerService;
import com.amarula.barcodescanner.sdk.IBarcodeServiceCallback;

public class BarcodeScannerConnection {
    private static String TAG = "BarcodeScannerConnection";
    private IBarcodeScannerService mService = null;
    private boolean mIsBound;
    private Context mContext;
    private Object mLock = new Object();
    private BarcodeScannerConnectionInterface mCallback = null;
    private ServiceConnection mConnection = new ServiceConnection(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onServiceConnected(ComponentName className, IBinder service) {
            Object object = BarcodeScannerConnection.this.mLock;
            synchronized (object) {
                BarcodeScannerConnection.this.mService = IBarcodeScannerService.Stub.asInterface(service);
                Log.d((String)TAG, (String)"Connected to the BarcodeScanner service");
            }
            try {
                BarcodeScannerConnection.this.mCallback.onServiceConnected(BarcodeScannerConnection.this.mService.getStatus());
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onServiceDisconnected(ComponentName className) {
            Object object = BarcodeScannerConnection.this.mLock;
            synchronized (object) {
                BarcodeScannerConnection.this.mService = null;
                BarcodeScannerConnection.this.mIsBound = false;
            }
            BarcodeScannerConnection.this.mCallback.onServiceDisconnected();
        }
    };

    public BarcodeScannerConnection(Context ctx, BarcodeScannerConnectionInterface cb) {
        this.mContext = ctx;
        this.mCallback = cb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bindToBarcodeScannerService() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mIsBound && this.mService != null) {
                return;
            }
            Log.d((String)TAG, (String)"Binding to the service..");
            Intent i = new Intent("com.amarula.barcodescanner.BARCODESCANNER_SERVICE");
            i.setComponent(BarcodeScanner.BARCODESCANNER_COMPONENT);
            this.mContext.bindService(i, this.mConnection, 1);
            this.mIsBound = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startCachedBarcodeScannerService() {
        Object object = this.mLock;
        synchronized (object) {
            Intent cachedBarcodeScannerServiceIntent = new Intent("com.amarula.barcodescanner.BARCODESCANNER_SERVICE");
            cachedBarcodeScannerServiceIntent.addCategory("com.amarula.barcodescanner.CACHE_STATE_CATEGORY");
            cachedBarcodeScannerServiceIntent.setComponent(BarcodeScanner.BARCODESCANNER_COMPONENT);
            this.mContext.startService(cachedBarcodeScannerServiceIntent);
        }
        this.bindToBarcodeScannerService();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbindFromBarcodeScannerService() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mIsBound) {
                Log.d((String)TAG, (String)"Unbinding from the service..");
                this.mContext.unbindService(this.mConnection);
                this.mIsBound = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopScanning() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mService != null) {
                try {
                    this.mService.stopReading();
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                }
                Log.d((String)TAG, (String)"Stop scanning");
            } else {
                Log.w((String)TAG, (String)"stopScanning(): Service still not connected");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int scanMultipleBarcodes() {
        int ret = -1;
        Object object = this.mLock;
        synchronized (object) {
            if (this.mService != null) {
                try {
                    ret = this.mService.readBarcodeMulti();
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                }
                Log.d((String)TAG, (String)"Read multiple barcodes");
            } else {
                Log.w((String)TAG, (String)"scanMultipleBarcodes(): Service still not connected");
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int scanOneBarcode() {
        int ret = -1;
        Object object = this.mLock;
        synchronized (object) {
            if (this.mService != null) {
                try {
                    ret = this.mService.readBarcodeSingle();
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                }
                Log.d((String)TAG, (String)"Read a single barcode");
            } else {
                Log.w((String)TAG, (String)"scanOneBarcode(): Service still not connected");
            }
        }
        return ret;
    }

    public boolean registerServerCallback(IBarcodeServiceCallback cb) {
        boolean ret = false;
        if (this.mService != null) {
            try {
                ret = this.mService.registerCallback(cb);
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
            Log.d((String)TAG, (String)"Registering Callback");
        } else {
            Log.w((String)TAG, (String)"registerServerCallback(): Service still not connected");
        }
        return ret;
    }

    public boolean unregisterServerCallback(IBarcodeServiceCallback cb) {
        boolean ret = false;
        if (this.mService != null) {
            try {
                ret = this.mService.unregisterCallback(cb);
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
            Log.d((String)TAG, (String)"Unregistering Callback");
        } else {
            Log.w((String)TAG, (String)"unregisterServerCallback(): Service still not connected");
        }
        return ret;
    }
}

