/*
 * Decompiled with CFR 0.152.
 */
package com.amarula.gen2wave.sdk.util;

import java.io.IOException;

public class SerialPort {
    protected int mFd = -1;

    protected native int open(String var1, int var2, boolean var3);

    private native int close(int var1);

    private native int write(int var1, byte[] var2, int var3);

    private native int read(int var1, byte[] var2, int var3, int var4);

    private native int readFrom(int var1, byte[] var2, int var3, int var4, int var5);

    private native int readln(int var1, byte[] var2, int var3, int var4);

    private native int setRTS(int var1, boolean var2);

    public SerialPort(String serialPath, int baudrate) throws IOException {
        this.mFd = this.open(serialPath, baudrate, false);
        if (this.mFd < 0) {
            throw new IOException("Error " + this.mFd + " opening " + serialPath);
        }
    }

    public SerialPort(String serialPath, int baudrate, boolean flowcontrol) throws IOException {
        this.mFd = this.open(serialPath, baudrate, flowcontrol);
        if (this.mFd < 0) {
            throw new IOException("Error " + this.mFd + " opening " + serialPath);
        }
    }

    protected SerialPort() {
    }

    public int close() {
        if (this.mFd < 0) {
            return this.mFd;
        }
        this.close(this.mFd);
        this.mFd = -1;
        return 0;
    }

    public int write(byte[] buff, int count) {
        if (this.mFd < 0) {
            return this.mFd;
        }
        if (buff == null) {
            throw new IllegalArgumentException("Write Buffer cannot be null");
        }
        if (count < 0) {
            throw new IllegalArgumentException("Write count cannot be negative");
        }
        return this.write(this.mFd, buff, count);
    }

    public int read(byte[] buff, int count, int timeout) {
        if (this.mFd < 0) {
            return this.mFd;
        }
        if (buff == null) {
            throw new IllegalArgumentException("Read Buffer cannot be null");
        }
        if (count < 0) {
            throw new IllegalArgumentException("Read count cannot be negative");
        }
        return this.read(this.mFd, buff, count, timeout);
    }

    public int read(byte[] buff, int from, int count, int timeout) {
        if (this.mFd < 0) {
            return this.mFd;
        }
        if (buff == null) {
            throw new IllegalArgumentException("Read Buffer cannot be null");
        }
        if (count < 0) {
            throw new IllegalArgumentException("Read count cannot be negative");
        }
        if (from < 0) {
            throw new IllegalArgumentException("from arg cannot be negative");
        }
        return this.readFrom(this.mFd, buff, from, count, timeout);
    }

    public int readln(byte[] buff, int count, int timeout) {
        if (this.mFd < 0) {
            return this.mFd;
        }
        if (buff == null) {
            throw new IllegalArgumentException("Read Buffer cannot be null");
        }
        if (count < 0) {
            throw new IllegalArgumentException("Read count cannot be negative");
        }
        return this.readln(this.mFd, buff, count, timeout);
    }

    public int setRTS(boolean value) {
        if (this.mFd < 0) {
            return this.mFd;
        }
        return this.setRTS(this.mFd, value);
    }

    public native String version();

    static {
        System.load("/system/lib64/libgen2wave_sdk_native.so");
    }
}

