/*
 * Decompiled with CFR 0.152.
 */
package org.jnbis.internal;

import org.jnbis.api.model.Nist;
import org.jnbis.api.model.record.FacialAndSmtImage;
import org.jnbis.api.model.record.HighResolutionBinaryFingerprint;
import org.jnbis.api.model.record.HighResolutionGrayscaleFingerprint;
import org.jnbis.api.model.record.IrisImage;
import org.jnbis.api.model.record.LowResolutionBinaryFingerprint;
import org.jnbis.api.model.record.LowResolutionGrayscaleFingerprint;
import org.jnbis.api.model.record.MinutiaeData;
import org.jnbis.api.model.record.SignatureImage;
import org.jnbis.api.model.record.TransactionInformation;
import org.jnbis.api.model.record.UserDefinedDescriptiveText;
import org.jnbis.api.model.record.UserDefinedImage;
import org.jnbis.api.model.record.VariableResolutionFingerprint;
import org.jnbis.api.model.record.VariableResolutionLatentImage;
import org.jnbis.api.model.record.VariableResolutionPalmprint;
import org.jnbis.internal.InternalNist;
import org.jnbis.internal.NistHelper;
import org.jnbis.internal.record.BaseRecord;
import org.jnbis.internal.record.reader.RecordReaderFactory;

public class NistDecoder {
    private RecordReaderFactory readerFactory = new RecordReaderFactory();

    public Nist decode(byte[] nist) {
        if (nist == null || nist.length == 0) {
            throw new IllegalArgumentException("data is null or zero length");
        }
        NistHelper.Token token = new NistHelper.Token(nist);
        InternalNist decoded = new InternalNist();
        BaseRecord record = this.readerFactory.read(token);
        decoded.setTransactionInfo((TransactionInformation)record);
        while (this.nextRecord(token)) {
            if (token.crt < 2) continue;
            record = this.readerFactory.read(token);
            if (record instanceof UserDefinedDescriptiveText) {
                decoded.addUserDefinedText((UserDefinedDescriptiveText)record);
                continue;
            }
            if (record instanceof LowResolutionGrayscaleFingerprint) {
                decoded.addLowResGrayscaleFingerPrint((LowResolutionGrayscaleFingerprint)record);
                continue;
            }
            if (record instanceof HighResolutionGrayscaleFingerprint) {
                decoded.addHiResGrayscaleFingerPrint((HighResolutionGrayscaleFingerprint)record);
                continue;
            }
            if (record instanceof LowResolutionBinaryFingerprint) {
                decoded.addLowResBinaryFingerPrint((LowResolutionBinaryFingerprint)record);
                continue;
            }
            if (record instanceof HighResolutionBinaryFingerprint) {
                decoded.addHiResBinaryFingerPrint((HighResolutionBinaryFingerprint)record);
                continue;
            }
            if (record instanceof UserDefinedImage) {
                decoded.addUserDefinedImage((UserDefinedImage)record);
                continue;
            }
            if (record instanceof SignatureImage) {
                decoded.addSignature((SignatureImage)record);
                continue;
            }
            if (record instanceof MinutiaeData) {
                decoded.addMinutiaeData((MinutiaeData)record);
                continue;
            }
            if (record instanceof FacialAndSmtImage) {
                decoded.addFacialSmtImage((FacialAndSmtImage)record);
                continue;
            }
            if (record instanceof VariableResolutionLatentImage) {
                decoded.addVariableResLatentImage((VariableResolutionLatentImage)record);
                continue;
            }
            if (record instanceof VariableResolutionFingerprint) {
                decoded.addVariableResFingerprint((VariableResolutionFingerprint)record);
                continue;
            }
            if (record instanceof VariableResolutionPalmprint) {
                decoded.addVariableResPalmprint((VariableResolutionPalmprint)record);
                continue;
            }
            if (!(record instanceof IrisImage)) continue;
            decoded.addIrisImage((IrisImage)record);
        }
        return decoded;
    }

    private boolean nextRecord(NistHelper.Token token) {
        if (token.header.length() == 0) {
            return false;
        }
        int rsPos = token.header.indexOf(30);
        if (rsPos == -1) {
            rsPos = token.header.length() - 1;
        }
        int usPos = token.header.indexOf(31);
        token.crt = Integer.parseInt(token.header.substring(0, usPos));
        token.header = token.header.substring(rsPos + 1);
        return true;
    }
}

