/*
 * Decompiled with CFR 0.152.
 */
package org.jnbis.internal;

import java.util.Arrays;
import org.jnbis.api.model.Bitmap;
import org.jnbis.internal.WsqHelper;

public class WsqDecoder {
    public Bitmap decode(byte[] data) {
        WsqHelper.Token token = new WsqHelper.Token(data);
        token.initialize();
        this.getCMarkerWSQ(token, 65440);
        int marker = this.getCMarkerWSQ(token, 2);
        while (marker != 65442) {
            this.getCTableWSQ(token, marker);
            marker = this.getCMarkerWSQ(token, 2);
        }
        WsqHelper.HeaderFrm frmHeaderWSQ = this.getCFrameHeaderWSQ(token);
        int width = frmHeaderWSQ.width;
        int height = frmHeaderWSQ.height;
        int ppi = this.getCPpiWSQ();
        this.buildWSQTrees(token, width, height);
        int[] qdata = this.huffmanDecodeDataMem(token, width * height);
        float[] fdata = this.unquantize(token, qdata, width, height);
        qdata = null;
        this.wsqReconstruct(token, fdata, width, height);
        byte[] cdata = this.convertImage2Byte(fdata, width, height, frmHeaderWSQ.mShift, frmHeaderWSQ.rScale);
        fdata = null;
        token = null;
        return new Bitmap(cdata, width, height, ppi, 8, 1);
    }

    private int intSign(int power) {
        int num = -1;
        if (power == 0) {
            return 1;
        }
        for (int cnt = 1; cnt < power; ++cnt) {
            num *= -1;
        }
        return num;
    }

    private int getCMarkerWSQ(WsqHelper.Token token, int type) {
        if (token.pointer >= token.buffer.length) {
            throw new RuntimeException("Error, Invalid pointer : " + token.pointer);
        }
        int marker = token.readShort();
        switch (type) {
            case 65440: {
                if (marker != 65440) {
                    throw new RuntimeException("ERROR : getCMarkerWSQ : No SOI marker : " + marker);
                }
                return marker;
            }
            case 2: {
                if (marker != 65444 && marker != 65445 && marker != 65446 && marker != 65442 && marker != 65448) {
                    throw new RuntimeException("ERROR : getc_marker_wsq : No SOF, Table, or comment markers : " + marker);
                }
                return marker;
            }
            case 4: {
                if (marker != 65444 && marker != 65445 && marker != 65446 && marker != 65443 && marker != 65448) {
                    throw new RuntimeException("ERROR : getc_marker_wsq : No SOB, Table, or comment markers : " + marker);
                }
                return marker;
            }
            case 65535: {
                if ((marker & 0xFF00) != 65280) {
                    throw new RuntimeException("ERROR : getc_marker_wsq : no marker found : " + marker);
                }
                if (marker < 65440 || marker > 65448) {
                    throw new RuntimeException("ERROR : getc_marker_wsq : not a valid marker : " + marker);
                }
                return marker;
            }
        }
        throw new RuntimeException("ERROR : getc_marker_wsq : Invalid marker : " + marker);
    }

    private void getCTableWSQ(WsqHelper.Token token, int marker) {
        switch (marker) {
            case 65444: {
                this.getCTransformTable(token);
                return;
            }
            case 65445: {
                this.getCQuantizationTable(token);
                return;
            }
            case 65446: {
                this.getCHuffmanTableWSQ(token);
                return;
            }
            case 65448: {
                this.getCComment(token);
                return;
            }
        }
        throw new RuntimeException("ERROR: getCTableWSQ : Invalid table defined : " + marker);
    }

    private String getCComment(WsqHelper.Token token) {
        int size = token.readShort() - 2;
        return Arrays.toString(token.readBytes(size));
    }

    private void getCTransformTable(WsqHelper.Token token) {
        token.readShort();
        token.tableDTT.hisz = token.readByte();
        token.tableDTT.losz = token.readByte();
        token.tableDTT.hifilt = new float[token.tableDTT.hisz];
        token.tableDTT.lofilt = new float[token.tableDTT.losz];
        int aSize = token.tableDTT.hisz % 2 != 0 ? (token.tableDTT.hisz + 1) / 2 : token.tableDTT.hisz / 2;
        float[] aLofilt = new float[aSize];
        --aSize;
        for (int cnt = 0; cnt <= aSize; ++cnt) {
            int sign = token.readByte();
            long shrtDat = token.readInt();
            aLofilt[cnt] = shrtDat;
            for (int scale = token.readByte(); scale > 0; --scale) {
                int n = cnt;
                aLofilt[n] = (float)((double)aLofilt[n] / 10.0);
            }
            if (sign != 0) {
                int n = cnt;
                aLofilt[n] = (float)((double)aLofilt[n] * -1.0);
            }
            if (token.tableDTT.hisz % 2 != 0) {
                token.tableDTT.hifilt[cnt + aSize] = (float)this.intSign(cnt) * aLofilt[cnt];
                if (cnt <= 0) continue;
                token.tableDTT.hifilt[aSize - cnt] = token.tableDTT.hifilt[cnt + aSize];
                continue;
            }
            token.tableDTT.hifilt[cnt + aSize + 1] = (float)this.intSign(cnt) * aLofilt[cnt];
            token.tableDTT.hifilt[aSize - cnt] = -1.0f * token.tableDTT.hifilt[cnt + aSize + 1];
        }
        aSize = token.tableDTT.losz % 2 != 0 ? (token.tableDTT.losz + 1) / 2 : token.tableDTT.losz / 2;
        float[] aHifilt = new float[aSize];
        --aSize;
        for (int cnt = 0; cnt <= aSize; ++cnt) {
            int sign = token.readByte();
            long shrtDat = token.readInt();
            aHifilt[cnt] = shrtDat;
            for (int scale = token.readByte(); scale > 0; --scale) {
                int n = cnt;
                aHifilt[n] = (float)((double)aHifilt[n] / 10.0);
            }
            if (sign != 0) {
                int n = cnt;
                aHifilt[n] = (float)((double)aHifilt[n] * -1.0);
            }
            if (token.tableDTT.losz % 2 != 0) {
                token.tableDTT.lofilt[cnt + aSize] = (float)this.intSign(cnt) * aHifilt[cnt];
                if (cnt <= 0) continue;
                token.tableDTT.lofilt[aSize - cnt] = token.tableDTT.lofilt[cnt + aSize];
                continue;
            }
            token.tableDTT.lofilt[cnt + aSize + 1] = (float)this.intSign(cnt + 1) * aHifilt[cnt];
            token.tableDTT.lofilt[aSize - cnt] = token.tableDTT.lofilt[cnt + aSize + 1];
        }
        token.tableDTT.lodef = 1;
        token.tableDTT.hidef = 1;
    }

    public void getCQuantizationTable(WsqHelper.Token token) {
        int scale;
        token.readShort();
        int shrtDat = token.readShort();
        token.tableDQT.binCenter = shrtDat;
        for (scale = token.readByte(); scale > 0; --scale) {
            token.tableDQT.binCenter = (float)((double)token.tableDQT.binCenter / 10.0);
        }
        for (int cnt = 0; cnt < 64; ++cnt) {
            shrtDat = token.readShort();
            token.tableDQT.qBin[cnt] = shrtDat;
            for (scale = token.readByte(); scale > 0; --scale) {
                int n = cnt;
                token.tableDQT.qBin[n] = (float)((double)token.tableDQT.qBin[n] / 10.0);
            }
            shrtDat = token.readShort();
            token.tableDQT.zBin[cnt] = shrtDat;
            for (scale = token.readByte(); scale > 0; --scale) {
                int n = cnt;
                token.tableDQT.zBin[n] = (float)((double)token.tableDQT.zBin[n] / 10.0);
            }
        }
        token.tableDQT.dqtDef = '\u0001';
    }

    public void getCHuffmanTableWSQ(WsqHelper.Token token) {
        WsqHelper.HuffmanTable firstHuffmanTable = this.getCHuffmanTable(token, 256, 0, true);
        int tableId = firstHuffmanTable.tableId;
        token.tableDHT[tableId].huffbits = (int[])firstHuffmanTable.huffbits.clone();
        token.tableDHT[tableId].huffvalues = (int[])firstHuffmanTable.huffvalues.clone();
        token.tableDHT[tableId].tabdef = 1;
        int bytesLeft = firstHuffmanTable.bytesLeft;
        while (bytesLeft != 0) {
            WsqHelper.HuffmanTable huffmantable = this.getCHuffmanTable(token, 256, bytesLeft, false);
            tableId = huffmantable.tableId;
            if (token.tableDHT[tableId].tabdef != 0) {
                throw new RuntimeException("ERROR : getCHuffmanTableWSQ : huffman table already defined.");
            }
            token.tableDHT[tableId].huffbits = (int[])huffmantable.huffbits.clone();
            token.tableDHT[tableId].huffvalues = (int[])huffmantable.huffvalues.clone();
            token.tableDHT[tableId].tabdef = 1;
            bytesLeft = huffmantable.bytesLeft;
        }
    }

    private WsqHelper.HuffmanTable getCHuffmanTable(WsqHelper.Token token, int maxHuffcounts, int bytesLeft, boolean readTableLen) {
        int i;
        WsqHelper.HuffmanTable huffmanTable = new WsqHelper.HuffmanTable();
        if (readTableLen) {
            huffmanTable.tableLen = token.readShort();
            bytesLeft = huffmanTable.bytesLeft = huffmanTable.tableLen - 2;
        } else {
            huffmanTable.bytesLeft = bytesLeft;
        }
        if (bytesLeft <= 0) {
            throw new RuntimeException("ERROR : getCHuffmanTable : no huffman table bytes remaining");
        }
        huffmanTable.tableId = token.readByte();
        --huffmanTable.bytesLeft;
        huffmanTable.huffbits = new int[16];
        int numHufvals = 0;
        for (i = 0; i < 16; ++i) {
            huffmanTable.huffbits[i] = token.readByte();
            numHufvals += huffmanTable.huffbits[i];
        }
        huffmanTable.bytesLeft -= 16;
        if (numHufvals > maxHuffcounts + 1) {
            throw new RuntimeException("ERROR : getCHuffmanTable : numHufvals is larger than MAX_HUFFCOUNTS");
        }
        huffmanTable.huffvalues = new int[maxHuffcounts + 1];
        for (i = 0; i < numHufvals; ++i) {
            huffmanTable.huffvalues[i] = token.readByte();
        }
        huffmanTable.bytesLeft -= numHufvals;
        return huffmanTable;
    }

    private WsqHelper.HeaderFrm getCFrameHeaderWSQ(WsqHelper.Token token) {
        int scale;
        WsqHelper.HeaderFrm headerFrm = new WsqHelper.HeaderFrm();
        int hdrSize = token.readShort();
        headerFrm.black = token.readByte();
        headerFrm.white = token.readByte();
        headerFrm.height = token.readShort();
        headerFrm.width = token.readShort();
        int shrtDat = token.readShort();
        headerFrm.mShift = shrtDat;
        for (scale = token.readByte(); scale > 0; --scale) {
            headerFrm.mShift = (float)((double)headerFrm.mShift / 10.0);
        }
        shrtDat = token.readShort();
        headerFrm.rScale = shrtDat;
        for (scale = token.readByte(); scale > 0; --scale) {
            headerFrm.rScale = (float)((double)headerFrm.rScale / 10.0);
        }
        headerFrm.wsqEncoder = token.readByte();
        headerFrm.software = token.readShort();
        return headerFrm;
    }

    private int getCPpiWSQ() {
        return -1;
    }

    private void buildWSQTrees(WsqHelper.Token token, int width, int height) {
        this.buildWTree(token, 20, width, height);
        this.buildQTree(token, 64);
    }

    private void buildWTree(WsqHelper.Token token, int wtreelen, int width, int height) {
        int leny2;
        int leny;
        int lenx2;
        int lenx;
        token.wtree = new WsqHelper.WavletTree[wtreelen];
        for (int i = 0; i < wtreelen; ++i) {
            token.wtree[i] = new WsqHelper.WavletTree();
            token.wtree[i].invrw = 0;
            token.wtree[i].invcl = 0;
        }
        token.wtree[2].invrw = 1;
        token.wtree[4].invrw = 1;
        token.wtree[7].invrw = 1;
        token.wtree[9].invrw = 1;
        token.wtree[11].invrw = 1;
        token.wtree[13].invrw = 1;
        token.wtree[16].invrw = 1;
        token.wtree[18].invrw = 1;
        token.wtree[3].invcl = 1;
        token.wtree[5].invcl = 1;
        token.wtree[8].invcl = 1;
        token.wtree[9].invcl = 1;
        token.wtree[12].invcl = 1;
        token.wtree[13].invcl = 1;
        token.wtree[17].invcl = 1;
        token.wtree[18].invcl = 1;
        this.wtree4(token, 0, 1, width, height, 0, 0, 1);
        if (token.wtree[1].lenx % 2 == 0) {
            lenx2 = lenx = token.wtree[1].lenx / 2;
        } else {
            lenx = (token.wtree[1].lenx + 1) / 2;
            lenx2 = lenx - 1;
        }
        if (token.wtree[1].leny % 2 == 0) {
            leny2 = leny = token.wtree[1].leny / 2;
        } else {
            leny = (token.wtree[1].leny + 1) / 2;
            leny2 = leny - 1;
        }
        this.wtree4(token, 4, 6, lenx2, leny, lenx, 0, 0);
        this.wtree4(token, 5, 10, lenx, leny2, 0, leny, 0);
        this.wtree4(token, 14, 15, lenx, leny, 0, 0, 0);
        token.wtree[19].x = 0;
        token.wtree[19].y = 0;
        token.wtree[19].lenx = token.wtree[15].lenx % 2 == 0 ? token.wtree[15].lenx / 2 : (token.wtree[15].lenx + 1) / 2;
        token.wtree[19].leny = token.wtree[15].leny % 2 == 0 ? token.wtree[15].leny / 2 : (token.wtree[15].leny + 1) / 2;
    }

    private void wtree4(WsqHelper.Token token, int start1, int start2, int lenx, int leny, int x, int y, int stop1) {
        int p1 = start1;
        int p2 = start2;
        int evenx = lenx % 2;
        int eveny = leny % 2;
        token.wtree[p1].x = x;
        token.wtree[p1].y = y;
        token.wtree[p1].lenx = lenx;
        token.wtree[p1].leny = leny;
        token.wtree[p2].x = x;
        token.wtree[p2 + 2].x = x;
        token.wtree[p2].y = y;
        token.wtree[p2 + 1].y = y;
        if (evenx == 0) {
            token.wtree[p2 + 1].lenx = token.wtree[p2].lenx = lenx / 2;
        } else if (p1 == 4) {
            token.wtree[p2].lenx = (lenx - 1) / 2;
            token.wtree[p2 + 1].lenx = token.wtree[p2].lenx + 1;
        } else {
            token.wtree[p2].lenx = (lenx + 1) / 2;
            token.wtree[p2 + 1].lenx = token.wtree[p2].lenx - 1;
        }
        token.wtree[p2 + 1].x = token.wtree[p2].lenx + x;
        if (stop1 == 0) {
            token.wtree[p2 + 3].lenx = token.wtree[p2 + 1].lenx;
            token.wtree[p2 + 3].x = token.wtree[p2 + 1].x;
        }
        token.wtree[p2 + 2].lenx = token.wtree[p2].lenx;
        if (eveny == 0) {
            token.wtree[p2 + 2].leny = token.wtree[p2].leny = leny / 2;
        } else if (p1 == 5) {
            token.wtree[p2].leny = (leny - 1) / 2;
            token.wtree[p2 + 2].leny = token.wtree[p2].leny + 1;
        } else {
            token.wtree[p2].leny = (leny + 1) / 2;
            token.wtree[p2 + 2].leny = token.wtree[p2].leny - 1;
        }
        token.wtree[p2 + 2].y = token.wtree[p2].leny + y;
        if (stop1 == 0) {
            token.wtree[p2 + 3].leny = token.wtree[p2 + 2].leny;
            token.wtree[p2 + 3].y = token.wtree[p2 + 2].y;
        }
        token.wtree[p2 + 1].leny = token.wtree[p2].leny;
    }

    private void buildQTree(WsqHelper.Token token, int qtreelen) {
        token.qtree = new WsqHelper.QuantTree[qtreelen];
        for (int i = 0; i < token.qtree.length; ++i) {
            token.qtree[i] = new WsqHelper.QuantTree();
        }
        this.qtree16(token, 3, token.wtree[14].lenx, token.wtree[14].leny, token.wtree[14].x, token.wtree[14].y, 0, 0);
        this.qtree16(token, 19, token.wtree[4].lenx, token.wtree[4].leny, token.wtree[4].x, token.wtree[4].y, 0, 1);
        this.qtree16(token, 48, token.wtree[0].lenx, token.wtree[0].leny, token.wtree[0].x, token.wtree[0].y, 0, 0);
        this.qtree16(token, 35, token.wtree[5].lenx, token.wtree[5].leny, token.wtree[5].x, token.wtree[5].y, 1, 0);
        this.qtree4(token, 0, token.wtree[19].lenx, token.wtree[19].leny, token.wtree[19].x, token.wtree[19].y);
    }

    private void qtree16(WsqHelper.Token token, int start, int lenx, int leny, int x, int y, int rw, int cl) {
        int temp2y;
        int tempy;
        int temp2x;
        int tempx;
        int p = start;
        int evenx = lenx % 2;
        int eveny = leny % 2;
        if (evenx == 0) {
            temp2x = tempx = lenx / 2;
        } else if (cl != 0) {
            temp2x = (lenx + 1) / 2;
            tempx = temp2x - 1;
        } else {
            tempx = (lenx + 1) / 2;
            temp2x = tempx - 1;
        }
        if (eveny == 0) {
            temp2y = tempy = leny / 2;
        } else if (rw != 0) {
            temp2y = (leny + 1) / 2;
            tempy = temp2y - 1;
        } else {
            tempy = (leny + 1) / 2;
            temp2y = tempy - 1;
        }
        evenx = tempx % 2;
        eveny = tempy % 2;
        token.qtree[p].x = x;
        token.qtree[p + 2].x = x;
        token.qtree[p].y = y;
        token.qtree[p + 1].y = y;
        if (evenx == 0) {
            token.qtree[p + 1].lenx = token.qtree[p].lenx = tempx / 2;
            token.qtree[p + 2].lenx = token.qtree[p].lenx;
            token.qtree[p + 3].lenx = token.qtree[p].lenx;
        } else {
            token.qtree[p].lenx = (tempx + 1) / 2;
            token.qtree[p + 1].lenx = token.qtree[p].lenx - 1;
            token.qtree[p + 2].lenx = token.qtree[p].lenx;
            token.qtree[p + 3].lenx = token.qtree[p + 1].lenx;
        }
        token.qtree[p + 3].x = token.qtree[p + 1].x = x + token.qtree[p].lenx;
        if (eveny == 0) {
            token.qtree[p + 1].leny = token.qtree[p].leny = tempy / 2;
            token.qtree[p + 2].leny = token.qtree[p].leny;
            token.qtree[p + 3].leny = token.qtree[p].leny;
        } else {
            token.qtree[p + 1].leny = token.qtree[p].leny = (tempy + 1) / 2;
            token.qtree[p + 3].leny = token.qtree[p + 2].leny = token.qtree[p].leny - 1;
        }
        token.qtree[p + 3].y = token.qtree[p + 2].y = y + token.qtree[p].leny;
        evenx = temp2x % 2;
        token.qtree[p + 6].x = token.qtree[p + 4].x = x + tempx;
        token.qtree[p + 4].y = y;
        token.qtree[p + 5].y = y;
        token.qtree[p + 6].y = token.qtree[p + 2].y;
        token.qtree[p + 7].y = token.qtree[p + 2].y;
        token.qtree[p + 4].leny = token.qtree[p].leny;
        token.qtree[p + 5].leny = token.qtree[p].leny;
        token.qtree[p + 6].leny = token.qtree[p + 2].leny;
        token.qtree[p + 7].leny = token.qtree[p + 2].leny;
        if (evenx == 0) {
            token.qtree[p + 5].lenx = token.qtree[p + 4].lenx = temp2x / 2;
            token.qtree[p + 6].lenx = token.qtree[p + 4].lenx;
            token.qtree[p + 7].lenx = token.qtree[p + 4].lenx;
        } else {
            token.qtree[p + 5].lenx = (temp2x + 1) / 2;
            token.qtree[p + 6].lenx = token.qtree[p + 4].lenx = token.qtree[p + 5].lenx - 1;
            token.qtree[p + 7].lenx = token.qtree[p + 5].lenx;
        }
        token.qtree[p + 7].x = token.qtree[p + 5].x = token.qtree[p + 4].x + token.qtree[p + 4].lenx;
        eveny = temp2y % 2;
        token.qtree[p + 8].x = x;
        token.qtree[p + 9].x = token.qtree[p + 1].x;
        token.qtree[p + 10].x = x;
        token.qtree[p + 11].x = token.qtree[p + 1].x;
        token.qtree[p + 9].y = token.qtree[p + 8].y = y + tempy;
        token.qtree[p + 8].lenx = token.qtree[p].lenx;
        token.qtree[p + 9].lenx = token.qtree[p + 1].lenx;
        token.qtree[p + 10].lenx = token.qtree[p].lenx;
        token.qtree[p + 11].lenx = token.qtree[p + 1].lenx;
        if (eveny == 0) {
            token.qtree[p + 9].leny = token.qtree[p + 8].leny = temp2y / 2;
            token.qtree[p + 10].leny = token.qtree[p + 8].leny;
            token.qtree[p + 11].leny = token.qtree[p + 8].leny;
        } else {
            token.qtree[p + 11].leny = token.qtree[p + 10].leny = (temp2y + 1) / 2;
            token.qtree[p + 9].leny = token.qtree[p + 8].leny = token.qtree[p + 10].leny - 1;
        }
        token.qtree[p + 11].y = token.qtree[p + 10].y = token.qtree[p + 8].y + token.qtree[p + 8].leny;
        token.qtree[p + 12].x = token.qtree[p + 4].x;
        token.qtree[p + 13].x = token.qtree[p + 5].x;
        token.qtree[p + 14].x = token.qtree[p + 4].x;
        token.qtree[p + 15].x = token.qtree[p + 5].x;
        token.qtree[p + 12].y = token.qtree[p + 8].y;
        token.qtree[p + 13].y = token.qtree[p + 8].y;
        token.qtree[p + 14].y = token.qtree[p + 10].y;
        token.qtree[p + 15].y = token.qtree[p + 10].y;
        token.qtree[p + 12].lenx = token.qtree[p + 4].lenx;
        token.qtree[p + 13].lenx = token.qtree[p + 5].lenx;
        token.qtree[p + 14].lenx = token.qtree[p + 4].lenx;
        token.qtree[p + 15].lenx = token.qtree[p + 5].lenx;
        token.qtree[p + 12].leny = token.qtree[p + 8].leny;
        token.qtree[p + 13].leny = token.qtree[p + 8].leny;
        token.qtree[p + 14].leny = token.qtree[p + 10].leny;
        token.qtree[p + 15].leny = token.qtree[p + 10].leny;
    }

    private void qtree4(WsqHelper.Token token, int start, int lenx, int leny, int x, int y) {
        int p = start;
        int evenx = lenx % 2;
        int eveny = leny % 2;
        token.qtree[p].x = x;
        token.qtree[p + 2].x = x;
        token.qtree[p].y = y;
        token.qtree[p + 1].y = y;
        if (evenx == 0) {
            token.qtree[p + 1].lenx = token.qtree[p].lenx = lenx / 2;
            token.qtree[p + 2].lenx = token.qtree[p].lenx;
            token.qtree[p + 3].lenx = token.qtree[p].lenx;
        } else {
            token.qtree[p].lenx = (lenx + 1) / 2;
            token.qtree[p + 1].lenx = token.qtree[p].lenx - 1;
            token.qtree[p + 2].lenx = token.qtree[p].lenx;
            token.qtree[p + 3].lenx = token.qtree[p + 1].lenx;
        }
        token.qtree[p + 3].x = token.qtree[p + 1].x = x + token.qtree[p].lenx;
        if (eveny == 0) {
            token.qtree[p + 1].leny = token.qtree[p].leny = leny / 2;
            token.qtree[p + 2].leny = token.qtree[p].leny;
            token.qtree[p + 3].leny = token.qtree[p].leny;
        } else {
            token.qtree[p + 1].leny = token.qtree[p].leny = (leny + 1) / 2;
            token.qtree[p + 3].leny = token.qtree[p + 2].leny = token.qtree[p].leny - 1;
        }
        token.qtree[p + 3].y = token.qtree[p + 2].y = y + token.qtree[p].leny;
    }

    private int[] huffmanDecodeDataMem(WsqHelper.Token token, int size) {
        int[] qdata = new int[size];
        int[] maxcode = new int[17];
        int[] mincode = new int[17];
        int[] valptr = new int[17];
        WsqHelper.IntRef marker = new WsqHelper.IntRef(this.getCMarkerWSQ(token, 4));
        WsqHelper.IntRef bitCount = new WsqHelper.IntRef(0);
        WsqHelper.IntRef nextByte = new WsqHelper.IntRef(0);
        int hufftableId = 0;
        int ip = 0;
        while (marker.value != 65441) {
            int n;
            int nodeptr;
            if (marker.value != 0) {
                while (marker.value != 65443) {
                    this.getCTableWSQ(token, marker.value);
                    marker.value = this.getCMarkerWSQ(token, 4);
                }
                hufftableId = this.getCBlockHeader(token);
                if (token.tableDHT[hufftableId].tabdef != 1) {
                    throw new RuntimeException("ERROR : huffmanDecodeDataMem : huffman table undefined.");
                }
                WsqHelper.HuffCode[] hufftable = this.buildHuffsizes(token.tableDHT[hufftableId].huffbits, 256);
                this.buildHuffcodes(hufftable);
                this.genDecodeTable(hufftable, maxcode, mincode, valptr, token.tableDHT[hufftableId].huffbits);
                bitCount.value = 0;
                marker.value = 0;
            }
            if ((nodeptr = this.decodeDataMem(token, mincode, maxcode, valptr, token.tableDHT[hufftableId].huffvalues, bitCount, marker, nextByte)) == -1) continue;
            if (nodeptr > 0 && nodeptr <= 100) {
                for (n = 0; n < nodeptr; ++n) {
                    qdata[ip++] = 0;
                }
                continue;
            }
            if (nodeptr > 106 && nodeptr < 255) {
                qdata[ip++] = nodeptr - 180;
                continue;
            }
            if (nodeptr == 101) {
                qdata[ip++] = this.getCNextbitsWSQ(token, marker, bitCount, 8, nextByte);
                continue;
            }
            if (nodeptr == 102) {
                qdata[ip++] = -this.getCNextbitsWSQ(token, marker, bitCount, 8, nextByte);
                continue;
            }
            if (nodeptr == 103) {
                qdata[ip++] = this.getCNextbitsWSQ(token, marker, bitCount, 16, nextByte);
                continue;
            }
            if (nodeptr == 104) {
                qdata[ip++] = -this.getCNextbitsWSQ(token, marker, bitCount, 16, nextByte);
                continue;
            }
            if (nodeptr == 105) {
                n = this.getCNextbitsWSQ(token, marker, bitCount, 8, nextByte);
                while (n-- > 0) {
                    qdata[ip++] = 0;
                }
                continue;
            }
            if (nodeptr == 106) {
                n = this.getCNextbitsWSQ(token, marker, bitCount, 16, nextByte);
                while (n-- > 0) {
                    qdata[ip++] = 0;
                }
                continue;
            }
            throw new RuntimeException("ERROR: huffman_decode_data_mem : Invalid code (" + nodeptr + ")");
        }
        return qdata;
    }

    private int getCBlockHeader(WsqHelper.Token token) {
        token.readShort();
        return token.readByte();
    }

    private WsqHelper.HuffCode[] buildHuffsizes(int[] huffbits, int maxHuffcounts) {
        int numberOfCodes = 1;
        WsqHelper.HuffCode[] huffcodeTable = new WsqHelper.HuffCode[maxHuffcounts + 1];
        int tempSize = 0;
        for (int codeSize = 1; codeSize <= 16; ++codeSize) {
            while (numberOfCodes <= huffbits[codeSize - 1]) {
                huffcodeTable[tempSize] = new WsqHelper.HuffCode();
                huffcodeTable[tempSize].size = codeSize;
                ++tempSize;
                ++numberOfCodes;
            }
            numberOfCodes = 1;
        }
        huffcodeTable[tempSize] = new WsqHelper.HuffCode();
        huffcodeTable[tempSize].size = 0;
        return huffcodeTable;
    }

    private void buildHuffcodes(WsqHelper.HuffCode[] huffcodeTable) {
        int tempCode = 0;
        int pointer = 0;
        int tempSize = huffcodeTable[0].size;
        if (huffcodeTable[pointer].size == 0) {
            return;
        }
        while (true) {
            huffcodeTable[pointer].code = tempCode;
            tempCode = (short)(tempCode + 1);
            if (huffcodeTable[++pointer].size == tempSize) continue;
            if (huffcodeTable[pointer].size == 0) {
                return;
            }
            do {
                tempCode = (short)(tempCode << 1);
            } while (huffcodeTable[pointer].size != ++tempSize);
            if (huffcodeTable[pointer].size != tempSize) break;
        }
    }

    private void genDecodeTable(WsqHelper.HuffCode[] huffcodeTable, int[] maxcode, int[] mincode, int[] valptr, int[] huffbits) {
        for (int i = 0; i <= 16; ++i) {
            maxcode[i] = 0;
            mincode[i] = 0;
            valptr[i] = 0;
        }
        int i2 = 0;
        for (int i = 1; i <= 16; ++i) {
            if (huffbits[i - 1] == 0) {
                maxcode[i] = -1;
                continue;
            }
            valptr[i] = i2;
            mincode[i] = huffcodeTable[i2].code;
            i2 = i2 + huffbits[i - 1] - 1;
            maxcode[i] = huffcodeTable[i2].code;
            ++i2;
        }
    }

    private int decodeDataMem(WsqHelper.Token token, int[] mincode, int[] maxcode, int[] valptr, int[] huffvalues, WsqHelper.IntRef bitCount, WsqHelper.IntRef marker, WsqHelper.IntRef nextByte) {
        short code = (short)this.getCNextbitsWSQ(token, marker, bitCount, 1, nextByte);
        if (marker.value != 0) {
            return -1;
        }
        int inx = 1;
        while (code > maxcode[inx]) {
            int tbits = this.getCNextbitsWSQ(token, marker, bitCount, 1, nextByte);
            code = (short)((code << 1) + tbits);
            if (marker.value != 0) {
                return -1;
            }
            ++inx;
        }
        int inx2 = valptr[inx] + code - mincode[inx];
        return huffvalues[inx2];
    }

    private int getCNextbitsWSQ(WsqHelper.Token token, WsqHelper.IntRef marker, WsqHelper.IntRef bitCount, int bitsReq, WsqHelper.IntRef nextByte) {
        int bits;
        if (bitCount.value == 0) {
            nextByte.value = token.readByte();
            bitCount.value = 8;
            if (nextByte.value == 255) {
                int code2 = token.readByte();
                if (code2 != 0 && bitsReq == 1) {
                    marker.value = nextByte.value << 8 | code2;
                    return 1;
                }
                if (code2 != 0) {
                    throw new RuntimeException("ERROR: getCNextbitsWSQ : No stuffed zeros.");
                }
            }
        }
        if (bitsReq <= bitCount.value) {
            bits = nextByte.value >> bitCount.value - bitsReq & WsqHelper.BITMASK[bitsReq];
            bitCount.value -= bitsReq;
            nextByte.value &= WsqHelper.BITMASK[bitCount.value];
        } else {
            int bitsNeeded = bitsReq - bitCount.value;
            bits = nextByte.value << bitsNeeded;
            bitCount.value = 0;
            int tbits = this.getCNextbitsWSQ(token, marker, bitCount, bitsNeeded, nextByte);
            bits |= tbits;
        }
        return bits;
    }

    private float[] unquantize(WsqHelper.Token token, int[] sip, int width, int height) {
        float[] fip = new float[width * height];
        if (token.tableDQT.dqtDef != '\u0001') {
            throw new RuntimeException("ERROR: unquantize : quantization table parameters not defined!");
        }
        float binCenter = token.tableDQT.binCenter;
        int sptr = 0;
        for (int cnt = 0; cnt < 60; ++cnt) {
            if ((double)token.tableDQT.qBin[cnt] == 0.0) continue;
            int fptr = token.qtree[cnt].y * width + token.qtree[cnt].x;
            int row = 0;
            while (row < token.qtree[cnt].leny) {
                for (int col = 0; col < token.qtree[cnt].lenx; ++col) {
                    if (sip[sptr] == 0) {
                        fip[fptr] = 0.0f;
                    } else if (sip[sptr] > 0) {
                        fip[fptr] = token.tableDQT.qBin[cnt] * ((float)sip[sptr] - binCenter) + token.tableDQT.zBin[cnt] / 2.0f;
                    } else if (sip[sptr] < 0) {
                        fip[fptr] = token.tableDQT.qBin[cnt] * ((float)sip[sptr] + binCenter) - token.tableDQT.zBin[cnt] / 2.0f;
                    } else {
                        throw new RuntimeException("ERROR : unquantize : invalid quantization pixel value");
                    }
                    ++fptr;
                    ++sptr;
                }
                ++row;
                fptr += width - token.qtree[cnt].lenx;
            }
        }
        return fip;
    }

    private void wsqReconstruct(WsqHelper.Token token, float[] fdata, int width, int height) {
        if (token.tableDTT.lodef != 1) {
            throw new RuntimeException("ERROR: wsq_reconstruct : Lopass filter coefficients not defined");
        }
        if (token.tableDTT.hidef != 1) {
            throw new RuntimeException("ERROR: wsq_reconstruct : Hipass filter coefficients not defined");
        }
        int numPix = width * height;
        float[] fdataTemp = new float[numPix];
        for (int node = 19; node >= 0; --node) {
            int fdataBse = token.wtree[node].y * width + token.wtree[node].x;
            this.joinLets(fdataTemp, fdata, 0, fdataBse, token.wtree[node].lenx, token.wtree[node].leny, 1, width, token.tableDTT.hifilt, token.tableDTT.hisz, token.tableDTT.lofilt, token.tableDTT.losz, token.wtree[node].invcl);
            this.joinLets(fdata, fdataTemp, fdataBse, 0, token.wtree[node].leny, token.wtree[node].lenx, width, 1, token.tableDTT.hifilt, token.tableDTT.hisz, token.tableDTT.lofilt, token.tableDTT.losz, token.wtree[node].invrw);
        }
    }

    private void joinLets(float[] newdata, float[] olddata, int newIndex, int oldIndex, int len1, int len2, int pitch, int stride, float[] hi, int hsz, float[] lo, int lsz, int inv) {
        int i;
        boolean ohre;
        boolean ohle;
        boolean olre;
        boolean olle;
        int hotap;
        int lotap;
        int hoc;
        int loc;
        int ofhre;
        float ssfac;
        boolean asym;
        int hlen;
        int llen;
        int fhre = 0;
        int da_ev = len2 % 2;
        int fi_ev = lsz % 2;
        int pstr = stride;
        int nstr = -pstr;
        if (da_ev != 0) {
            llen = (len2 + 1) / 2;
            hlen = llen - 1;
        } else {
            hlen = llen = len2 / 2;
        }
        if (fi_ev != 0) {
            asym = false;
            ssfac = 1.0f;
            ofhre = 0;
            loc = (lsz - 1) / 4;
            hoc = (hsz + 1) / 4 - 1;
            lotap = (lsz - 1) / 2 % 2;
            hotap = (hsz + 1) / 2 % 2;
            if (da_ev != 0) {
                olle = false;
                olre = false;
                ohle = true;
                ohre = true;
            } else {
                olle = false;
                olre = true;
                ohle = true;
                ohre = false;
            }
        } else {
            asym = true;
            ssfac = -1.0f;
            ofhre = 2;
            loc = lsz / 4 - 1;
            hoc = hsz / 4 - 1;
            lotap = lsz / 2 % 2;
            hotap = hsz / 2 % 2;
            if (da_ev != 0) {
                olle = true;
                olre = false;
                ohle = true;
                ohre = true;
            } else {
                olle = true;
                olre = true;
                ohle = true;
                ohre = true;
            }
            if (loc == -1) {
                loc = 0;
                olle = false;
            }
            if (hoc == -1) {
                hoc = 0;
                ohle = false;
            }
            i = 0;
            while (i < hsz) {
                int n = i++;
                hi[n] = (float)((double)hi[n] * -1.0);
            }
        }
        for (int cl_rw = 0; cl_rw < len1; ++cl_rw) {
            float sfac;
            int hpxstr;
            int hpx;
            boolean hre;
            boolean hle;
            int lpxstr;
            int lpx;
            boolean lre;
            boolean lle;
            int tap;
            int lopass;
            int hipass;
            int limg;
            int himg = limg = newIndex + cl_rw * pitch;
            newdata[himg] = 0.0f;
            newdata[himg + stride] = 0.0f;
            if (inv != 0) {
                hipass = oldIndex + cl_rw * pitch;
                lopass = hipass + stride * hlen;
            } else {
                lopass = oldIndex + cl_rw * pitch;
                hipass = lopass + stride * llen;
            }
            int lp0 = lopass;
            int lp1 = lp0 + (llen - 1) * stride;
            int lspx = lp0 + loc * stride;
            int lspxstr = nstr;
            int lstap = lotap;
            boolean lle2 = olle;
            boolean lre2 = olre;
            int hp0 = hipass;
            int hp1 = hp0 + (hlen - 1) * stride;
            int hspx = hp0 + hoc * stride;
            int hspxstr = nstr;
            int hstap = hotap;
            boolean hle2 = ohle;
            boolean hre2 = ohre;
            float osfac = ssfac;
            for (int pix = 0; pix < hlen; ++pix) {
                for (tap = lstap; tap >= 0; --tap) {
                    lle = lle2;
                    lre = lre2;
                    lpx = lspx;
                    lpxstr = lspxstr;
                    newdata[limg] = olddata[lpx] * lo[tap];
                    for (i = tap + 2; i < lsz; i += 2) {
                        if (lpx == lp0) {
                            if (lle) {
                                lpxstr = 0;
                                lle = false;
                            } else {
                                lpxstr = pstr;
                            }
                        }
                        if (lpx == lp1) {
                            if (lre) {
                                lpxstr = 0;
                                lre = false;
                            } else {
                                lpxstr = nstr;
                            }
                        }
                        int n = limg;
                        newdata[n] = newdata[n] + olddata[lpx += lpxstr] * lo[i];
                    }
                    limg += stride;
                }
                if (lspx == lp0) {
                    if (lle2) {
                        lspxstr = 0;
                        lle2 = false;
                    } else {
                        lspxstr = pstr;
                    }
                }
                lspx += lspxstr;
                lstap = 1;
                for (tap = hstap; tap >= 0; --tap) {
                    hle = hle2;
                    hre = hre2;
                    hpx = hspx;
                    hpxstr = hspxstr;
                    fhre = ofhre;
                    sfac = osfac;
                    for (i = tap; i < hsz; i += 2) {
                        if (hpx == hp0) {
                            if (hle) {
                                hpxstr = 0;
                                hle = false;
                            } else {
                                hpxstr = pstr;
                                sfac = 1.0f;
                            }
                        }
                        if (hpx == hp1) {
                            if (hre) {
                                hpxstr = 0;
                                hre = false;
                                if (asym && da_ev != 0) {
                                    hre = true;
                                    if ((double)(sfac = (float)(--fhre)) == 0.0) {
                                        hre = false;
                                    }
                                }
                            } else {
                                hpxstr = nstr;
                                if (asym) {
                                    sfac = -1.0f;
                                }
                            }
                        }
                        int n = himg;
                        newdata[n] = newdata[n] + olddata[hpx] * hi[i] * sfac;
                        hpx += hpxstr;
                    }
                    himg += stride;
                }
                if (hspx == hp0) {
                    if (hle2) {
                        hspxstr = 0;
                        hle2 = false;
                    } else {
                        hspxstr = pstr;
                        osfac = 1.0f;
                    }
                }
                hspx += hspxstr;
                hstap = 1;
            }
            lstap = da_ev != 0 ? (lotap != 0 ? 1 : 0) : (lotap != 0 ? 2 : 1);
            for (tap = 1; tap >= lstap; --tap) {
                lle = lle2;
                lre = lre2;
                lpx = lspx;
                lpxstr = lspxstr;
                newdata[limg] = olddata[lpx] * lo[tap];
                for (i = tap + 2; i < lsz; i += 2) {
                    if (lpx == lp0) {
                        if (lle) {
                            lpxstr = 0;
                            lle = false;
                        } else {
                            lpxstr = pstr;
                        }
                    }
                    if (lpx == lp1) {
                        if (lre) {
                            lpxstr = 0;
                            lre = false;
                        } else {
                            lpxstr = nstr;
                        }
                    }
                    int n = limg;
                    newdata[n] = newdata[n] + olddata[lpx += lpxstr] * lo[i];
                }
                limg += stride;
            }
            if (da_ev != 0) {
                hstap = hotap != 0 ? 1 : 0;
                if (hsz == 2) {
                    hspx -= hspxstr;
                    fhre = 1;
                }
            } else {
                hstap = hotap != 0 ? 2 : 1;
            }
            for (tap = 1; tap >= hstap; --tap) {
                hle = hle2;
                hre = hre2;
                hpx = hspx;
                hpxstr = hspxstr;
                sfac = osfac;
                if (hsz != 2) {
                    fhre = ofhre;
                }
                for (i = tap; i < hsz; i += 2) {
                    if (hpx == hp0) {
                        if (hle) {
                            hpxstr = 0;
                            hle = false;
                        } else {
                            hpxstr = pstr;
                            sfac = 1.0f;
                        }
                    }
                    if (hpx == hp1) {
                        if (hre) {
                            hpxstr = 0;
                            hre = false;
                            if (asym && da_ev != 0) {
                                hre = true;
                                if ((double)(sfac = (float)(--fhre)) == 0.0) {
                                    hre = false;
                                }
                            }
                        } else {
                            hpxstr = nstr;
                            if (asym) {
                                sfac = -1.0f;
                            }
                        }
                    }
                    int n = himg;
                    newdata[n] = newdata[n] + olddata[hpx] * hi[i] * sfac;
                    hpx += hpxstr;
                }
                himg += stride;
            }
        }
        if (fi_ev == 0) {
            i = 0;
            while (i < hsz) {
                int n = i++;
                hi[n] = (float)((double)hi[n] * -1.0);
            }
        }
    }

    private byte[] convertImage2Byte(float[] img, int width, int height, float mShift, float rScale) {
        byte[] data = new byte[width * height];
        int idx = 0;
        for (int r = 0; r < height; ++r) {
            for (int c = 0; c < width; ++c) {
                float pixel = img[idx] * rScale + mShift;
                data[idx] = (double)(pixel = (float)((double)pixel + 0.5)) < 0.0 ? 0 : ((double)pixel > 255.0 ? -1 : (byte)pixel);
                ++idx;
            }
        }
        return data;
    }
}

