/*
 * Decompiled with CFR 0.152.
 */
package com.identive.libs;

import com.identive.libs.CCIDHandler;
import com.identive.libs.SCard;
import com.identive.libs.SmcLib;
import java.nio.ByteBuffer;

class IFDLayer {
    int gnSlotNum = 0;
    static final int CCID_MAX_PKT_SIZE = SCard.nMaxCCIDLen;

    IFDLayer() {
    }

    CCIDHandler.CCID_RESPONSE IFD_Process(IFD_COMMAND ifdCommand, IFD_PARAMS ifdParam, SmcLib.SMARTCARD_EXTENSION Smartcard, READER_EXTENSION Reader, ByteBuffer sendBuffer, long sendLength, long maxReceiveLength) {
        CCIDHandler ccidHandler;
        byte[] Request;
        SCard usb;
        ByteBuffer ccidResponse;
        long status = 0L;
        char ccidCommand = '\u00ff';
        char rfu0 = '\u0000';
        char rfu1 = '\u0000';
        char rfu2 = '\u0000';
        CCIDHandler.CCID_RESPONSE validResponse = null;
        ByteBuffer tlBuffer = ByteBuffer.allocate(65536);
        switch (ifdCommand) {
            case IFD_POWER: {
                if (ifdParam.power.ResetType == 0L) {
                    ccidCommand = 'c';
                    break;
                }
                ccidCommand = 'b';
                break;
            }
            case IFD_TRANSMIT: {
                ccidCommand = 'o';
                rfu0 = ifdParam.transmit.BWI;
                rfu1 = ifdParam.transmit.TransferLevel;
                break;
            }
            case IFD_SETPROTOCOL: {
                ccidCommand = 'a';
                sendBuffer = tlBuffer;
                sendBuffer.put(0, (byte)(ifdParam.protocol.fVal << 4 | ifdParam.protocol.dVal));
                if (ifdParam.protocol.NewProtocol == 1L) {
                    rfu0 = (char)IFD_PROTOCOL.IFD_PROTOCOL_T0.getCode();
                    sendLength = 5L;
                    maxReceiveLength = 5L;
                    break;
                }
                rfu0 = (char)IFD_PROTOCOL.IFD_PROTOCOL_T1.getCode();
                sendLength = 7L;
                maxReceiveLength = 7L;
                break;
            }
            case IFD_ESCAPE: {
                ccidCommand = 'k';
                break;
            }
            case IFD_SLOT_STATUS: {
                ccidCommand = 'e';
                break;
            }
            case IFD_ABORT: {
                ccidCommand = 'r';
                break;
            }
            default: {
                status = -995L;
            }
        }
        if (status >= 0L && (ccidResponse = (usb = new SCard()).UsbTransfer(Request = (ccidHandler = new CCIDHandler()).Ccid_BuildRequest(ccidCommand, '\u0000', rfu0, rfu1, rfu2, sendBuffer, sendLength))) != null) {
            validResponse = ccidHandler.Ccid_VerifyResponse(ccidResponse.array(), ccidResponse.capacity(), ccidCommand, (char)this.gnSlotNum, maxReceiveLength);
            if (validResponse.ntStatus == 0L) {
                switch (validResponse.slotStatus) {
                    case 0: {
                        if (Smartcard.ReaderCapabilities.CurrentState >= 4L) break;
                        Smartcard.ReaderCapabilities.CurrentState = 4L;
                        break;
                    }
                    case 1: {
                        Smartcard.ReaderCapabilities.CurrentState = 2L;
                        break;
                    }
                    default: {
                        Smartcard.ReaderCapabilities.CurrentState = 1L;
                    }
                }
                validResponse.ntStatus = ccidHandler.Ccid_ToNtStatus(validResponse.ccidStatus);
            }
        }
        return validResponse;
    }

    class CCID_CHAIN_PARAM {
        static final int CCID_NO_CHAIN = 0;
        static final int CCID_CHAIN_BEGINS_AND_CONTINUES = 1;
        static final int CCID_CHAIN_ENDS = 2;
        static final int CCID_CHAIN_CONTINUES = 3;
        static final int CCID_CHAIN_ACK_BLOCK = 16;
        static final int CCID_CHAIN_EXPECTED = 4;

        CCID_CHAIN_PARAM() {
        }
    }

    static enum IFD_COMMAND {
        IFD_POWER,
        IFD_TRANSMIT,
        IFD_SETPROTOCOL,
        IFD_ESCAPE,
        IFD_SLOT_STATUS,
        IFD_VERIFY,
        IFD_MODIFY,
        IFD_ABORT;

    }

    static class IFD_PARAMS {
        Power power = new Power();
        Protocol protocol = new Protocol();
        Transmit transmit = new Transmit();

        IFD_PARAMS() {
        }

        class Power {
            long ResetType;

            Power() {
            }
        }

        class Protocol {
            long NewProtocol;
            long fVal;
            long dVal;

            Protocol() {
            }
        }

        class Transmit {
            char TransferLevel;
            char BWI;

            Transmit() {
            }
        }
    }

    static enum IFD_PROTOCOL {
        IFD_PROTOCOL_T0(0),
        IFD_PROTOCOL_T1(1);

        private int code;

        private IFD_PROTOCOL(int code) {
            this.code = code;
        }

        int getCode() {
            return this.code;
        }
    }

    static class IFD_TRANSFER_LEVEL {
        static final int IFD_TRANSFER_TPDU = 1;
        static final int IFD_TRANSFER_APDU = 2;
        static final int IFD_TRANSFER_XAPDU = 4;

        IFD_TRANSFER_LEVEL() {
        }
    }

    static enum IFD_VENDOR_ESCAPE_CODES {
        VENDOR_READER_GETINFO(0),
        VENDOR_SLOT_SETMODE(1),
        VENDOR_SLOT_GETMODE(2),
        VENDOR_READER_UNDEFINED1(3),
        VENDOR_READER_SET_DBG_INFO(4),
        VENDOR_SCARD_EMV_LOOPBACK(5),
        VENDOR_SCARD_EMV_SINGLEMODE(6),
        VENDOR_SCARD_EMV_TIMEDMODE(7),
        VENDOR_SCARD_APDU_TRANSFER(8),
        VENDOR_READER_DFU_DETACH(9),
        VENDOR_READER_SWITCH_SPEED(10),
        VENDOR_READER_GETINFOEX(11),
        VENDOR_READER_SWITCH_PROTOCOL(12),
        VENDOR_READER_PRODUCTION_DFU_DETACH(13),
        VENDOR_RESERVED(14),
        VENDOR_READER_DISABLE_PPS(15),
        VENDOR_READER_EXCHANGE_RAW(16),
        VENDOR_RESERVED2(17),
        VENDOR_READER_GETIFDTYPE(18),
        VENDOR_READER_GETCHIPREV(19),
        VENDOR_READER_SETTRANSPORT(20),
        VENDOR_READER_SET_PINPARAM(128),
        VENDOR_BUZZER_DISABLE(81),
        VENDOR_BUZZER_ENABLE(82),
        VENDOR_BUZZER_TEST(83),
        VENDOR_LED_ENABLE(84),
        VENDOR_LED_DISABLE(85),
        VENDOR_BACKLITE_TEST(86),
        VENDOR_LCD_TEST(87),
        VENDOR_KEYPAD_TEST(88);

        private int code;

        private IFD_VENDOR_ESCAPE_CODES(int code) {
            this.code = code;
        }

        int getCode() {
            return this.code;
        }
    }

    class READER_EXTENSION {
        long handle;
        short fVal;
        short dVal;

        READER_EXTENSION() {
        }
    }
}

