/*
 * Decompiled with CFR 0.152.
 */
package com.identive.libs;

import android.util.Log;
import com.identive.libs.Defs;
import com.identive.libs.IFDLayer;
import com.identive.libs.IFDLayerInterface;
import com.identive.libs.SCard;
import com.identive.libs.SmcLib;
import com.identive.libs.WinDefs;
import java.nio.ByteBuffer;

class ResourceManager {
    private static final String TAG = "SCard Library";
    private static SmcLib.SMARTCARD_EXTENSION smartcard;
    private static IFDLayer.READER_EXTENSION readerExt;
    private static String Reader;
    private static int Mode;
    private static byte[] atr;
    private static int atrlen;
    private boolean bIsStateChanged = false;

    ResourceManager() {
    }

    long RM_SCardConnect(String RdrName, int nMode, int nPreferredProtocols) {
        Log.i((String)TAG, (String)"----- RM_SCardConnect -----");
        boolean bIsInitPass = false;
        boolean bIsPoweredON = false;
        long lRetval = -2146435052L;
        IFDLayerInterface layerInterface = new IFDLayerInterface();
        if (RdrName == null) {
            lRetval = -2146435063L;
            Log.e((String)TAG, (String)"SCARD_E_UNKNOWN_READER");
        } else if (1 != nMode && 3 != nMode) {
            lRetval = -2146435055L;
            Log.e((String)TAG, (String)"SCARD_E_INVALID_VALUE - 1");
        } else if (((long)nPreferredProtocols & 3L) != (long)nPreferredProtocols) {
            lRetval = -2146435068L;
            Log.e((String)TAG, (String)"SCARD_E_INVALID_PARAMETER");
        } else if (65536L == (long)nPreferredProtocols) {
            lRetval = -2146435055L;
            Log.e((String)TAG, (String)"SCARD_E_INVALID_VALUE - 2");
        } else if (3 != nMode && (nPreferredProtocols & 3) == 0) {
            lRetval = -2146435055L;
            Log.e((String)TAG, (String)"SCARD_E_INVALID_VALUE - 3");
        } else {
            Reader = RdrName;
            Mode = nMode;
            lRetval = layerInterface.IFD_Init(smartcard, readerExt);
            if (0L != lRetval) {
                lRetval = this.RM_ReturnStatus(lRetval);
            } else {
                bIsInitPass = true;
                lRetval = layerInterface.IFD_SlotStatus(smartcard, readerExt);
                if (ResourceManager.smartcard.ReaderCapabilities.CurrentState <= 1L) {
                    lRetval = -2146434967L;
                    Log.e((String)TAG, (String)"SCARD_W_REMOVED_CARD");
                    if (3 == nMode) {
                        lRetval = 0L;
                    }
                } else {
                    ResourceManager.smartcard.MinorIoControlCode = 2L;
                    lRetval = layerInterface.IFD_PowerControl(smartcard, readerExt);
                    if (0L != lRetval) {
                        lRetval = 3 == nMode ? 0L : this.RM_ReturnStatus(lRetval);
                    } else {
                        bIsPoweredON = true;
                        atrlen = ResourceManager.smartcard.CardCapabilities.atr.Length;
                        if (atrlen != 0) {
                            atr = new byte[atrlen];
                        }
                        System.arraycopy(ResourceManager.smartcard.CardCapabilities.atr.Buffer, 0, atr, 0, atrlen);
                        if (3 == nMode) {
                            lRetval = 0L;
                        } else {
                            ResourceManager.smartcard.MinorIoControlCode = nPreferredProtocols;
                            lRetval = layerInterface.IFD_SetProtocol(smartcard, readerExt);
                            if (0L != lRetval) {
                                lRetval = this.RM_ReturnStatus(lRetval);
                            }
                        }
                    }
                }
            }
        }
        if (bIsPoweredON && 3 == nMode) {
            ResourceManager.smartcard.MinorIoControlCode = 0L;
            layerInterface.IFD_PowerControl(smartcard, readerExt);
        }
        if (0L != lRetval && bIsInitPass) {
            if (bIsPoweredON) {
                ResourceManager.smartcard.MinorIoControlCode = 0L;
                layerInterface.IFD_PowerControl(smartcard, readerExt);
            }
            this.RM_CloseHandle(smartcard, readerExt);
        }
        return lRetval;
    }

    long RM_GetSlotStatus(SmcLib.SMARTCARD_EXTENSION pSmartcard, IFDLayer.READER_EXTENSION pReaderExtn) {
        Log.i((String)TAG, (String)"----- RM_GetSlotStatus -----");
        long lRetVal = -2146435052L;
        IFDLayerInterface layerInterface = new IFDLayerInterface();
        lRetVal = layerInterface.IFD_SlotStatus(pSmartcard, pReaderExtn);
        if (0L != lRetVal) {
            lRetVal = this.RM_ReturnStatus(lRetVal);
        }
        return lRetVal;
    }

    long RM_SCardPowerControl(int nDisposition, boolean bIsDisConnect) {
        Log.i((String)TAG, (String)"----- RM_SCardPowerControl -----");
        int nCardState = 2;
        long lRetval = 0L;
        long lStatus = 0L;
        switch (nDisposition) {
            case 1: {
                nCardState = 2;
                break;
            }
            default: {
                nCardState = 1;
            }
        }
        if (bIsDisConnect) {
            nCardState = 0;
        }
        ResourceManager.smartcard.MinorIoControlCode = nCardState;
        IFDLayerInterface layerInterface = new IFDLayerInterface();
        lStatus = layerInterface.IFD_PowerControl(smartcard, readerExt);
        if (0L != lStatus) {
            lRetval = this.RM_ReturnStatus(lStatus);
        }
        if (bIsDisConnect) {
            lRetval = 0L;
        }
        return lRetval;
    }

    long RM_ReturnStatus(long lStatus) {
        Log.i((String)TAG, (String)"----- RM_ReturnStatus -----");
        long lRetval = -2146435052L;
        switch ((int)lStatus) {
            case 0: {
                lRetval = 0L;
                break;
            }
            case -1000: {
                lRetval = -2146435064L;
                Log.e((String)TAG, (String)"SCARD_E_INSUFFICIENT_BUFFER");
                break;
            }
            case -999: {
                lRetval = -2146434969L;
                Log.e((String)TAG, (String)"SCARD_W_UNPOWERED_CARD");
                break;
            }
            case -997: {
                lRetval = -2146435055L;
                Log.e((String)TAG, (String)"SCARD_E_INVALID_VALUE");
                break;
            }
            case -996: {
                lRetval = -2146435071L;
                Log.e((String)TAG, (String)"SCARD_F_INTERNAL_ERROR");
                break;
            }
            case -995: {
                lRetval = -2146435068L;
                Log.e((String)TAG, (String)"SCARD_E_INVALID_PARAMETER");
                break;
            }
            case -993: {
                lRetval = -2146434970L;
                Log.e((String)TAG, (String)"SCARD_W_UNRESPONSIVE_CARD");
                break;
            }
            case -992: {
                lRetval = -2146435064L;
                Log.e((String)TAG, (String)"SCARD_E_INSUFFICIENT_BUFFER");
                break;
            }
            case -991: {
                lRetval = -2146434971L;
                Log.e((String)TAG, (String)"SCARD_W_UNSUPPORTED_CARD");
                break;
            }
            case -998: 
            case -990: {
                lRetval = -2146434967L;
                Log.e((String)TAG, (String)"SCARD_W_REMOVED_CARD");
                break;
            }
            case -989: {
                lRetval = -2146435057L;
                Log.e((String)TAG, (String)"SCARD_E_PROTO_MISMATCH");
                break;
            }
            case -988: {
                lRetval = 1235L;
                Log.e((String)TAG, (String)"ERROR_REQUEST_ABORTED");
                break;
            }
            case -987: {
                lRetval = -2146435056L;
                Log.e((String)TAG, (String)"SCARD_E_NOT_READY");
                break;
            }
            case -986: {
                lRetval = -2146435052L;
                Log.e((String)TAG, (String)"SCARD_F_UNKNOWN_ERROR");
                break;
            }
            case -985: {
                lRetval = 22L;
                Log.e((String)TAG, (String)"ERROR_BAD_COMMAND");
                break;
            }
            case -982: {
                lRetval = -2146435049L;
                Log.e((String)TAG, (String)"SCARD_E_READER_UNAVAILABLE");
                break;
            }
            case -984: {
                lRetval = -2146435060L;
                Log.e((String)TAG, (String)"SCARD_E_NO_SMARTCARD");
                break;
            }
            case -983: {
                lRetval = -2146435057L;
                Log.e((String)TAG, (String)"SCARD_E_PROTO_MISMATCH");
            }
        }
        return lRetval;
    }

    int RM_FinalizeCardStatus(int uSlotStatus, long lRetValue) {
        Log.i((String)TAG, (String)"----- RM_FinalizeCardStatus -----");
        int pdwCardStatus = uSlotStatus <= 1 ? 16 : (uSlotStatus < 6 && uSlotStatus >= 2 ? 1056 : 32);
        if (0L != lRetValue) {
            if ((uSlotStatus >= 2 || uSlotStatus >= 4) && -990L == lRetValue) {
                pdwCardStatus |= 0x200;
            }
            switch ((int)lRetValue) {
                case -987: {
                    pdwCardStatus = 288;
                    break;
                }
                case -982: {
                    pdwCardStatus = 4;
                    break;
                }
                case -983: {
                    pdwCardStatus = 160;
                    break;
                }
                case -984: {
                    pdwCardStatus = 16;
                    break;
                }
                default: {
                    pdwCardStatus = 8;
                }
            }
        }
        return pdwCardStatus;
    }

    boolean RM_ProcessCurrentState(int dwInputCurrentState, int dwCardState) {
        Log.i((String)TAG, (String)"----- RM_ProcessCurrentState -----");
        boolean bIsStateChanged = false;
        if (dwInputCurrentState >= 4095) {
            dwInputCurrentState = 0;
        }
        if (dwInputCurrentState == 0) {
            bIsStateChanged = true;
        } else if ((dwInputCurrentState & 0x10) != 0) {
            bIsStateChanged = (dwCardState & 0x10) == 0;
        } else if ((dwInputCurrentState & 0x20) != 0) {
            bIsStateChanged = (dwCardState & 0x20) == 0;
        } else if ((dwInputCurrentState & 0xC) != 0) {
            bIsStateChanged = true;
        }
        return bIsStateChanged;
    }

    long RM_CloseHandle(SmcLib.SMARTCARD_EXTENSION Smartcard, IFDLayer.READER_EXTENSION ReaderExtn) {
        long lRetval;
        Log.i((String)TAG, (String)"----- RM_CloseHandle -----");
        IFDLayerInterface layerInterface = new IFDLayerInterface();
        layerInterface.IFD_SlotStatus(Smartcard, ReaderExtn);
        if (Smartcard.ReaderCapabilities.CurrentState >= 4L) {
            Smartcard.MinorIoControlCode = 0L;
            layerInterface.IFD_PowerControl(Smartcard, ReaderExtn);
        }
        if (0L != (lRetval = layerInterface.IFD_Cleanup(Smartcard, ReaderExtn))) {
            lRetval = this.RM_ReturnStatus(lRetval);
        }
        atrlen = 0;
        atr = null;
        Mode = 0;
        return lRetval;
    }

    long RM_CloseCardHandle(int nDisposition) {
        Log.i((String)TAG, (String)"----- RM_CloseCardHandle -----");
        long lRetval = -2146435052L;
        if (3 != Mode && 0L != (lRetval = this.RM_SCardPowerControl(nDisposition, true)) || 0L != (lRetval = this.RM_CloseHandle(smartcard, readerExt))) {
            // empty if block
        }
        return lRetval;
    }

    long RM_Transmit(SCard.SCardIOBuffer transmit) {
        Log.i((String)TAG, (String)"----- RM_Transmit -----");
        long lRetval = -2146435052L;
        IFDLayerInterface layerInterface = new IFDLayerInterface();
        if (Mode == 3) {
            lRetval = -2146435056L;
        } else if (transmit.abyInBuffer == null || -1 == transmit.nInBufferSize) {
            lRetval = -2146435068L;
        } else if (transmit.nInBufferSize == 0) {
            lRetval = -2146435068L;
        } else if (transmit.abyInBuffer.length < transmit.nInBufferSize) {
            lRetval = -2146435068L;
        } else {
            ResourceManager.smartcard.iorequest.RequestBufferLength = 4 == transmit.nInBufferSize ? 5L : (long)transmit.nInBufferSize;
            ResourceManager.smartcard.iorequest.RequestBuffer = ByteBuffer.allocate((int)ResourceManager.smartcard.iorequest.RequestBufferLength);
            System.arraycopy(transmit.abyInBuffer, 0, ResourceManager.smartcard.iorequest.RequestBuffer.array(), 0, transmit.nInBufferSize);
            ResourceManager.smartcard.iorequest.ReplyBuffer = ByteBuffer.allocate(transmit.nOutBufferSize);
            ResourceManager.smartcard.iorequest.ReplyBufferLength = transmit.nOutBufferSize;
            if (ResourceManager.smartcard.ReaderCapabilities.CurrentState < 6L) {
                lRetval = -2146434967L;
            } else {
                lRetval = layerInterface.IFD_Transmit(smartcard, readerExt);
                if (0L != lRetval) {
                    lRetval = this.RM_ReturnStatus(lRetval);
                    if (ResourceManager.smartcard.ReaderCapabilities.CurrentState < 2L) {
                        lRetval = -2146434967L;
                    } else if (6L != ResourceManager.smartcard.ReaderCapabilities.CurrentState) {
                        lRetval = -2146435025L;
                    }
                } else {
                    transmit.nBytesReturned = (int)ResourceManager.smartcard.iorequest.Information;
                    System.arraycopy(ResourceManager.smartcard.iorequest.ReplyBuffer.array(), 0, transmit.abyOutBuffer, 0, (int)ResourceManager.smartcard.iorequest.Information);
                }
            }
        }
        return lRetval;
    }

    /*
     * Enabled aggressive block sorting
     */
    long RM_SCardReconnect(int nMode, int nPreferredProtocols, int nInitialization) {
        Log.i((String)TAG, (String)"----- RM_SCardReconnect -----");
        long lRetval = -2146435052L;
        IFDLayerInterface layerInterface = new IFDLayerInterface();
        if (1 != nMode && 3 != nMode) {
            lRetval = -2146435055L;
            Log.e((String)TAG, (String)"SCARD_E_INVALID_VALUE - 1");
            return lRetval;
        }
        if (((long)nPreferredProtocols & 3L) != (long)nPreferredProtocols) {
            lRetval = -2146435055L;
            Log.e((String)TAG, (String)"SCARD_E_INVALID_VALUE - 2");
            return lRetval;
        }
        if (nInitialization >= 3) {
            lRetval = -2146435068L;
            Log.e((String)TAG, (String)"SCARD_E_INVALID_PARAMETER");
            return lRetval;
        }
        lRetval = this.RM_GetSlotStatus(smartcard, readerExt);
        if (0L != lRetval) {
            return lRetval;
        }
        if (ResourceManager.smartcard.ReaderCapabilities.CurrentState <= 1L) {
            if (3 == Mode && nMode != 3) {
                lRetval = -2146435060L;
                Log.e((String)TAG, (String)"SCARD_E_NO_SMARTCARD");
                return lRetval;
            }
            lRetval = -2146434967L;
            Log.e((String)TAG, (String)"SCARD_W_REMOVED_CARD");
            return lRetval;
        }
        if (nInitialization != 0 || ResourceManager.smartcard.ReaderCapabilities.CurrentState < 4L) {
            if (ResourceManager.smartcard.ReaderCapabilities.CurrentState < 4L) {
                nInitialization = 1;
            }
            if (nInitialization == 2 && 0L != (lRetval = this.RM_SCardPowerControl(nInitialization, true))) {
                return lRetval;
            }
            lRetval = this.RM_SCardPowerControl(nInitialization, false);
            if (0L != lRetval) {
                return lRetval;
            }
            ResourceManager.smartcard.MinorIoControlCode = nPreferredProtocols;
            lRetval = layerInterface.IFD_SetProtocol(smartcard, readerExt);
            if (0L != lRetval) {
                return this.RM_ReturnStatus(lRetval);
            }
            if (1L != ResourceManager.smartcard.CardCapabilities.protocol.Selected && 2L != ResourceManager.smartcard.CardCapabilities.protocol.Selected) {
                lRetval = -2146435044L;
                Log.e((String)TAG, (String)"SCARD_E_CARD_UNSUPPORTED");
                return lRetval;
            }
        } else if (((long)nPreferredProtocols & ResourceManager.smartcard.CardCapabilities.protocol.Selected) == 0L) {
            lRetval = -2146435057L;
            Log.e((String)TAG, (String)"SCARD_E_PROTO_MISMATCH");
            return lRetval;
        }
        Mode = nMode;
        atrlen = ResourceManager.smartcard.CardCapabilities.atr.Length;
        if (atrlen != 0) {
            atr = new byte[atrlen];
        }
        System.arraycopy(ResourceManager.smartcard.CardCapabilities.atr.Buffer, 0, atr, 0, atrlen);
        return lRetval;
    }

    long RM_SCardControl(int nControlCode, SCard.SCardIOBuffer transmit) {
        Log.i((String)TAG, (String)"----- RM_SCardControl -----");
        long lRetval = -2146435052L;
        IFDLayerInterface layerInterface = new IFDLayerInterface();
        if (-1L == (long)transmit.nInBufferSize && transmit.abyInBuffer != null) {
            lRetval = -2146435068L;
        } else if (-1L == (long)transmit.nOutBufferSize) {
            lRetval = 14L;
        } else if (transmit.nInBufferSize == 0) {
            lRetval = -2146435068L;
        } else if (transmit.abyInBuffer.length < transmit.nInBufferSize) {
            lRetval = -2146435068L;
        } else if (transmit.nOutBufferSize < transmit.nBytesReturned && transmit.abyOutBuffer != null) {
            lRetval = -2146435068L;
        } else {
            layerInterface.IFD_SlotStatus(smartcard, readerExt);
            if (3 != Mode && ResourceManager.smartcard.ReaderCapabilities.CurrentState < 4L) {
                lRetval = -2146434967L;
            } else {
                ResourceManager.smartcard.MajorIoControlCode = nControlCode;
                ResourceManager.smartcard.MinorIoControlCode = 0L;
                ResourceManager.smartcard.iorequest.RequestBuffer = ByteBuffer.wrap(transmit.abyInBuffer);
                ResourceManager.smartcard.iorequest.RequestBufferLength = transmit.nInBufferSize;
                ResourceManager.smartcard.iorequest.ReplyBuffer = ByteBuffer.wrap(transmit.abyOutBuffer);
                ResourceManager.smartcard.iorequest.ReplyBufferLength = transmit.nOutBufferSize;
                ResourceManager.smartcard.iorequest.Information = transmit.nBytesReturned;
                lRetval = layerInterface.IFD_VendorCommand(smartcard, readerExt);
                if (0L != lRetval) {
                    lRetval = -983L == lRetval && (nControlCode & 0x310000) != 0 ? -2146435068L : (-983L == lRetval ? -2146435068L : this.RM_ReturnStatus(lRetval));
                } else {
                    transmit.nBytesReturned = (int)ResourceManager.smartcard.iorequest.Information;
                    if (transmit.nBytesReturned > 0) {
                        System.arraycopy(ResourceManager.smartcard.iorequest.ReplyBuffer.array(), 0, transmit.abyOutBuffer, 0, (int)ResourceManager.smartcard.iorequest.Information);
                    }
                }
            }
        }
        return lRetval;
    }

    long RM_SCardStatus(SCard.SCardState cState) {
        long lRetval;
        block6: {
            block7: {
                block5: {
                    Log.i((String)TAG, (String)"----- RM_SCardStatus -----");
                    lRetval = -2146435052L;
                    cState.szReader = Reader;
                    lRetval = this.RM_GetSlotStatus(smartcard, readerExt);
                    if (3 != Mode) break block5;
                    if (-2146435049L == lRetval) break block6;
                    lRetval = 0L;
                    break block7;
                }
                if (0L != lRetval) break block6;
            }
            cState.nState = (int)ResourceManager.smartcard.ReaderCapabilities.CurrentState;
            cState.nProtocol = (int)ResourceManager.smartcard.CardCapabilities.protocol.Selected;
            if (atrlen != 0) {
                cState.nATRlen = atrlen;
                System.arraycopy(atr, 0, cState.abyATR, 0, cState.nATRlen);
            } else {
                cState.nATRlen = 0;
            }
        }
        return lRetval;
    }

    long RM_SCardGetAttrib(SCard.SCardAttribute attr) {
        Log.i((String)TAG, (String)"----- RM_SCardGetAttrib -----");
        long lRetval = 0L;
        Long lValOut = -1L;
        byte[] szTemp = null;
        int dwRetLength = 0;
        if (3 == Mode && (attr.nAttrId == WinDefs.SCARD_ATTR_ATR_STRING || attr.nAttrId == WinDefs.SCARD_ATTR_CURRENT_BWT || attr.nAttrId == WinDefs.SCARD_ATTR_CURRENT_CLK || attr.nAttrId == WinDefs.SCARD_ATTR_CURRENT_CWT || attr.nAttrId == WinDefs.SCARD_ATTR_CURRENT_D || attr.nAttrId == WinDefs.SCARD_ATTR_CURRENT_EBC_ENCODING || attr.nAttrId == WinDefs.SCARD_ATTR_CURRENT_F || attr.nAttrId == WinDefs.SCARD_ATTR_CURRENT_IFSC || attr.nAttrId == WinDefs.SCARD_ATTR_CURRENT_IFSD || attr.nAttrId == WinDefs.SCARD_ATTR_CURRENT_N || attr.nAttrId == WinDefs.SCARD_ATTR_CURRENT_PROTOCOL_TYPE || attr.nAttrId == WinDefs.SCARD_ATTR_CURRENT_W || attr.nAttrId == WinDefs.SCARD_ATTR_ICC_TYPE_PER_ATR)) {
            lRetval = 22L;
        } else {
            if (attr.nAttrId == Defs.SCARD_ATTR_VENDOR_NAME) {
                dwRetLength = ResourceManager.smartcard.VendorAttr.vendorName.Length;
                szTemp = new byte[dwRetLength];
                System.arraycopy(ResourceManager.smartcard.VendorAttr.vendorName.Buffer, 0, szTemp, 0, ResourceManager.smartcard.VendorAttr.vendorName.Length);
            } else if (attr.nAttrId == Defs.SCARD_ATTR_VENDOR_IFD_TYPE) {
                dwRetLength = ResourceManager.smartcard.VendorAttr.ifdType.Length;
                szTemp = new byte[dwRetLength];
                System.arraycopy(ResourceManager.smartcard.VendorAttr.ifdType.Buffer, 0, szTemp, 0, ResourceManager.smartcard.VendorAttr.ifdType.Length);
            } else if (attr.nAttrId == Defs.SCARD_ATTR_VENDOR_IFD_VERSION) {
                dwRetLength = 4;
                szTemp = new byte[dwRetLength];
                szTemp[3] = (byte)ResourceManager.smartcard.VendorAttr.ifdVersion.VersionMajor;
                szTemp[2] = (byte)ResourceManager.smartcard.VendorAttr.ifdVersion.VersionMinor;
                szTemp[1] = (byte)Defs.HIBYTE(ResourceManager.smartcard.VendorAttr.ifdVersion.BuildNumber);
                szTemp[0] = (byte)Defs.LOBYTE(ResourceManager.smartcard.VendorAttr.ifdVersion.BuildNumber);
            } else if (attr.nAttrId == Defs.SCARD_ATTR_CHANNEL_ID) {
                lValOut = 0x200000L;
            } else if (attr.nAttrId == Defs.SCARD_ATTR_PROTOCOL_TYPES) {
                lValOut = ResourceManager.smartcard.ReaderCapabilities.SupportedProtocols;
            } else if (attr.nAttrId == Defs.SCARD_ATTR_DEFAULT_CLK) {
                lValOut = ResourceManager.smartcard.ReaderCapabilities.frequency.Default;
            } else if (attr.nAttrId == Defs.SCARD_ATTR_MAX_CLK) {
                lValOut = ResourceManager.smartcard.ReaderCapabilities.frequency.Max;
            } else if (attr.nAttrId == Defs.SCARD_ATTR_DEFAULT_DATA_RATE) {
                lValOut = ResourceManager.smartcard.ReaderCapabilities.dataRate.Default;
            } else if (attr.nAttrId == Defs.SCARD_ATTR_MAX_DATA_RATE) {
                lValOut = ResourceManager.smartcard.ReaderCapabilities.dataRate.Max;
            } else if (attr.nAttrId == Defs.SCARD_ATTR_MAX_IFSD) {
                lValOut = ResourceManager.smartcard.ReaderCapabilities.MaxIFSD;
            } else if (attr.nAttrId == Defs.SCARD_ATTR_POWER_MGMT_SUPPORT) {
                lValOut = ResourceManager.smartcard.ReaderCapabilities.PowerMgmtSupport;
            } else if (attr.nAttrId == Defs.SCARD_ATTR_CHARACTERISTICS) {
                lValOut = 0L;
            } else if (attr.nAttrId == Defs.SCARD_ATTR_CURRENT_PROTOCOL_TYPE) {
                lValOut = ResourceManager.smartcard.CardCapabilities.protocol.Selected;
            } else if (attr.nAttrId == Defs.SCARD_ATTR_CURRENT_CLK) {
                lValOut = ResourceManager.smartcard.CardCapabilities.PtsData.CLKFrequency;
            } else if (attr.nAttrId == Defs.SCARD_ATTR_CURRENT_F) {
                lValOut = Defs.sClockRateConversion[ResourceManager.smartcard.CardCapabilities.Fl][0];
            } else if (attr.nAttrId == Defs.SCARD_ATTR_CURRENT_D) {
                lValOut = Defs.sBitRateAdjustment[ResourceManager.smartcard.CardCapabilities.Dl][0];
            } else if (attr.nAttrId == Defs.SCARD_ATTR_CURRENT_N) {
                lValOut = ResourceManager.smartcard.CardCapabilities.N;
            } else if (attr.nAttrId == Defs.SCARD_ATTR_CURRENT_W) {
                lValOut = ResourceManager.smartcard.CardCapabilities.t0.WI;
            } else if (attr.nAttrId == Defs.SCARD_ATTR_CURRENT_IFSC) {
                lValOut = ResourceManager.smartcard.CardCapabilities.t1.IFSC;
            } else if (attr.nAttrId == Defs.SCARD_ATTR_CURRENT_IFSD) {
                lValOut = ResourceManager.smartcard.T1.IFSD;
            } else if (attr.nAttrId == Defs.SCARD_ATTR_CURRENT_BWT) {
                lValOut = ResourceManager.smartcard.CardCapabilities.t1.BWI;
            } else if (attr.nAttrId == Defs.SCARD_ATTR_CURRENT_CWT) {
                lValOut = ResourceManager.smartcard.CardCapabilities.t1.CWI;
            } else if (attr.nAttrId == Defs.SCARD_ATTR_CURRENT_EBC_ENCODING) {
                lValOut = ResourceManager.smartcard.CardCapabilities.t1.EDC;
            } else if (attr.nAttrId == Defs.SCARD_ATTR_ICC_PRESENCE) {
                dwRetLength = 1;
                szTemp = new byte[dwRetLength];
                szTemp[0] = 0;
                if (ResourceManager.smartcard.ReaderCapabilities.CurrentState >= 2L) {
                    szTemp[0] = 2;
                }
            } else if (attr.nAttrId == Defs.SCARD_ATTR_ICC_INTERFACE_STATUS) {
                dwRetLength = 1;
                szTemp = new byte[dwRetLength];
                szTemp[0] = 0;
                if (ResourceManager.smartcard.ReaderCapabilities.CurrentState > 3L) {
                    szTemp[0] = -1;
                }
            } else if (attr.nAttrId == Defs.SCARD_ATTR_ATR_STRING) {
                dwRetLength = ResourceManager.smartcard.CardCapabilities.atr.Length;
                szTemp = new byte[dwRetLength];
                System.arraycopy(ResourceManager.smartcard.CardCapabilities.atr.Buffer, 0, szTemp, 0, ResourceManager.smartcard.CardCapabilities.atr.Length);
            } else if (attr.nAttrId == Defs.SCARD_ATTR_ICC_TYPE_PER_ATR) {
                dwRetLength = 1;
                szTemp = new byte[dwRetLength];
                szTemp[0] = (byte)((ResourceManager.smartcard.CardCapabilities.protocol.Selected & 3L) != 0L ? 1 : 0);
            } else if (attr.nAttrId == Defs.SCARD_ATTR_DEVICE_UNIT) {
                lValOut = ResourceManager.smartcard.VendorAttr.UnitNo;
            } else if (attr.nAttrId == Defs.SCARD_ATTR_DEVICE_IN_USE) {
                lRetval = 50L;
            } else if (attr.nAttrId == Defs.SCARD_ATTR_DEVICE_FRIENDLY_NAME) {
                dwRetLength = Reader.length();
                szTemp = new byte[dwRetLength];
                szTemp = Reader.getBytes();
            } else if (attr.nAttrId == Defs.SCARD_ATTR_DEVICE_SYSTEM_NAME) {
                dwRetLength = Reader.length();
                szTemp = new byte[dwRetLength];
                szTemp = Reader.getBytes();
            } else if (attr.nAttrId == Defs.SCARD_ATTR_VENDOR_IFD_SERIAL_NO) {
                dwRetLength = ResourceManager.smartcard.VendorAttr.ifdSerialNo.Length;
                szTemp = new byte[dwRetLength];
                System.arraycopy(ResourceManager.smartcard.VendorAttr.ifdSerialNo.Buffer, 0, szTemp, 0, ResourceManager.smartcard.VendorAttr.ifdSerialNo.Length);
            } else {
                lRetval = 22L;
            }
            if (50L != lRetval && lRetval != 22L) {
                if (lValOut != -1L) {
                    dwRetLength = 4;
                }
                if (lValOut != -1L) {
                    attr.nAttrLen = dwRetLength;
                    attr.abyAttr = new byte[dwRetLength];
                    attr.abyAttr[3] = (byte)(lValOut & 0xFFL);
                    attr.abyAttr[2] = (byte)(lValOut >> 8 & 0xFFL);
                    attr.abyAttr[1] = (byte)(lValOut >> 16 & 0xFFL);
                    attr.abyAttr[0] = (byte)(lValOut >> 24 & 0xFFL);
                } else {
                    attr.nAttrLen = dwRetLength;
                    attr.abyAttr = new byte[dwRetLength];
                    System.arraycopy(szTemp, 0, attr.abyAttr, 0, dwRetLength);
                }
            }
        }
        return lRetval;
    }

    long RM_SCardSetAttrib(SCard.SCardAttribute attr) {
        Log.i((String)TAG, (String)"----- RM_SCardSetAttrib -----");
        long lRetval = -2146435052L;
        IFDLayerInterface layerInterface = new IFDLayerInterface();
        if (-1L == (long)attr.nAttrId) {
            lRetval = 50L;
        } else {
            lRetval = layerInterface.IFD_SlotStatus(smartcard, readerExt);
            if (0L == lRetval) {
                if (ResourceManager.smartcard.ReaderCapabilities.CurrentState <= 1L) {
                    lRetval = -2146434967L;
                } else if (attr.nAttrId != Defs.SCARD_ATTR_SUPRESS_T1_IFS_REQUEST) {
                    lRetval = 50L;
                }
            }
        }
        return lRetval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long RM_SCardGetStatusChange(final long dwTimeout, final SCard.SCARD_READERSTATE[] rgReaderStates, final int cReaders) {
        Log.i((String)TAG, (String)"----- RM_SCardGetStatusChange -----");
        long lStatus = -2146435062L;
        final Thread t = Thread.currentThread();
        Thread status = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                long lRetVal = 0L;
                boolean bIsNewHandle = false;
                int dwCardStatus = 16;
                IFDLayerInterface layerInterface = new IFDLayerInterface();
                int time = 0;
                int nTimeout = 0;
                do {
                    if (dwTimeout == -1L) {
                        nTimeout = 101;
                        time = -2;
                    } else {
                        nTimeout = (int)dwTimeout;
                    }
                    int i = 0;
                    while (i < cReaders) {
                        if ((rgReaderStates[i].nCurrentState & 1) == 0) {
                            bIsNewHandle = false;
                            if (rgReaderStates[i].pvUserData[0] == 1) {
                                lRetVal = layerInterface.IFD_Init(smartcard, readerExt);
                                if (0L != lRetVal || -1L == readerExt.handle) {
                                    ResourceManager.this.bIsStateChanged = true;
                                    rgReaderStates[i].nEventState = 10;
                                    break;
                                }
                                bIsNewHandle = true;
                            }
                            lRetVal = ResourceManager.this.RM_GetSlotStatus(smartcard, readerExt);
                            if (smartcard.ReaderCapabilities.CurrentState <= 1L) {
                                dwCardStatus = 528;
                            } else {
                                dwCardStatus = 3 == Mode ? 8 : ResourceManager.this.RM_FinalizeCardStatus((int)smartcard.ReaderCapabilities.CurrentState, lRetVal);
                                if (6L != smartcard.ReaderCapabilities.CurrentState && 3 != Mode) {
                                    smartcard.MinorIoControlCode = 2L;
                                    bIsNewHandle = true;
                                    lRetVal = layerInterface.IFD_PowerControl(smartcard, readerExt);
                                    if (0L != lRetVal) {
                                        dwCardStatus = 32;
                                    } else {
                                        smartcard.MinorIoControlCode = 3L;
                                        lRetVal = layerInterface.IFD_SetProtocol(smartcard, readerExt);
                                        dwCardStatus = ResourceManager.this.RM_FinalizeCardStatus((int)smartcard.ReaderCapabilities.CurrentState, lRetVal);
                                        if (0L != lRetVal) {
                                            dwCardStatus = 544;
                                        }
                                        atrlen = smartcard.CardCapabilities.atr.Length;
                                        if (atrlen != 0) {
                                            atr = new byte[atrlen];
                                        }
                                        System.arraycopy(smartcard.CardCapabilities.atr.Buffer, 0, atr, 0, atrlen);
                                    }
                                }
                                if (atrlen != 0) {
                                    rgReaderStates[i].abyAtr = new byte[atrlen];
                                    System.arraycopy(atr, 0, rgReaderStates[i].abyAtr, 0, atrlen);
                                    rgReaderStates[i].nAtr = atrlen;
                                }
                                if (bIsNewHandle) {
                                    smartcard.MinorIoControlCode = 0L;
                                    lRetVal = layerInterface.IFD_PowerControl(smartcard, readerExt);
                                    if (0L != lRetVal) {
                                        dwCardStatus = 544;
                                        ResourceManager.this.bIsStateChanged = true;
                                    }
                                }
                            }
                            ResourceManager.this.bIsStateChanged = ResourceManager.this.RM_ProcessCurrentState(rgReaderStates[i].nCurrentState, dwCardStatus);
                            if (ResourceManager.this.bIsStateChanged) {
                                rgReaderStates[i].nEventState = 2 | dwCardStatus;
                                lRetVal = 0L;
                                break;
                            }
                            rgReaderStates[i].nEventState = dwCardStatus;
                            break;
                        }
                        ++i;
                    }
                    if (ResourceManager.this.bIsStateChanged) break;
                    try {
                        if (nTimeout > 100) {
                            Thread.sleep(100L);
                            time += 100;
                            continue;
                        }
                        Thread.sleep(nTimeout);
                        time += nTimeout;
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                } while (time < nTimeout);
                Thread thread = t;
                synchronized (thread) {
                    t.notify();
                }
            }
        });
        status.start();
        try {
            Thread thread = t;
            synchronized (thread) {
                t.wait();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.bIsStateChanged) {
            lStatus = 0L;
        }
        return lStatus;
    }

    void RM_UpdateReaderNameInDB(SCard.RdrDetails det) {
        SmcLib scmlib = new SmcLib();
        IFDLayer layer = new IFDLayer();
        smartcard = scmlib.new SmcLib.SMARTCARD_EXTENSION();
        readerExt = layer.new IFDLayer.READER_EXTENSION();
        ResourceManager.smartcard.VendorAttr.vendorName.Buffer = det.MString.getBytes();
        ResourceManager.smartcard.VendorAttr.vendorName.Length = det.MString.length();
        ResourceManager.smartcard.VendorAttr.ifdType.Buffer = det.RString.getBytes();
        ResourceManager.smartcard.VendorAttr.ifdType.Length = det.RString.length();
        ResourceManager.smartcard.VendorAttr.UnitNo = det.unitno;
        ResourceManager.smartcard.VendorAttr.ifdSerialNo.Length = det.serialno.length();
        ResourceManager.smartcard.VendorAttr.ifdSerialNo.Buffer = det.serialno.getBytes();
        ResourceManager.smartcard.VendorAttr.ifdVersion.VersionMajor = det.nVerMajor;
        ResourceManager.smartcard.VendorAttr.ifdVersion.VersionMinor = det.nVerMinor;
        int i = 0;
        while (i < 4) {
            ResourceManager.smartcard.ReaderCapabilities.MaxIFSD += ((long)det.byMaxIFSD[i] & 0xFFL) << 8 * i;
            ResourceManager.smartcard.ReaderCapabilities.SupportedProtocols += ((long)det.byProtocols[i] & 0xFFL) << 8 * i;
            ResourceManager.smartcard.ReaderCapabilities.frequency.Default += ((long)det.byDefClk[i] & 0xFFL) << 8 * i;
            ResourceManager.smartcard.ReaderCapabilities.frequency.Max += ((long)det.byMaxClk[i] & 0xFFL) << 8 * i;
            ResourceManager.smartcard.ReaderCapabilities.dataRate.Default += ((long)det.byDefDataRate[i] & 0xFFL) << 8 * i;
            ResourceManager.smartcard.ReaderCapabilities.dataRate.Max += ((long)det.byMaxDataRate[i] & 0xFFL) << 8 * i;
            ++i;
        }
    }
}

