/*
 * Decompiled with CFR 0.152.
 */
package com.identive.libs;

import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbEndpoint;
import android.hardware.usb.UsbInterface;
import android.hardware.usb.UsbManager;
import android.util.Log;
import com.identive.libs.ResourceManager;
import com.identive.libs.WinDefs;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;

public class SCard {
    private static final String TAG = "SCard Library";
    private static UsbManager mManager = null;
    private static UsbDeviceConnection mConnection = null;
    private static UsbEndpoint mEndpointOut = null;
    private static UsbEndpoint mEndpointIn = null;
    private static UsbEndpoint mEndpointInterrupt = null;
    private static int nReaders;
    static boolean bAPDURdrType;
    static int nMaxCCIDLen;
    private static PendingIntent mPermissionIntent;
    private static ArrayList<RdrDetails> details;
    public static Long difference;
    private static final String ACTION_USB_PERMISSION = "com.android.scard.USB_PERMISSION";
    private static ArrayList<UsbDevice> UsbRdrList;
    private static int gnRdrPos;
    private final BroadcastReceiver mUsbReceiver = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onReceive(Context context, Intent intent) {
            Log.d((String)"usb-receiver", (String)"Broadcast Receiver. ONReceive >");
            String action = intent.getAction();
            if (SCard.ACTION_USB_PERMISSION.equals(action)) {
                1 var4_4 = this;
                synchronized (var4_4) {
                    UsbDevice device = (UsbDevice)intent.getParcelableExtra("device");
                    if (intent.getBooleanExtra("permission", false)) {
                        if (device != null) {
                            Log.d((String)"usb-receiver", (String)("permission granted for device " + device));
                        }
                    } else {
                        Log.d((String)"usb-receiver", (String)("permission denied for device " + device));
                    }
                }
                if (gnRdrPos != -1) {
                    gnRdrPos = gnRdrPos + 1;
                    if (gnRdrPos + 1 > UsbRdrList.size()) {
                        gnRdrPos = -1;
                    }
                    Log.d((String)"usb-receiver", (String)("position is : " + gnRdrPos));
                    if (gnRdrPos != -1) {
                        Log.d((String)"usb-receiver", (String)("Calling reader " + UsbRdrList.get(gnRdrPos)));
                        SCard.this.USBGetPermission(context);
                    }
                }
            }
            Log.d((String)"usb-receiver", (String)"Broadcast Receiver. ONReceive <");
        }
    };

    static {
        bAPDURdrType = false;
        nMaxCCIDLen = 0;
        difference = new Long(0L);
        gnRdrPos = 0;
    }

    private long USBGetPermission(Context context) {
        long lRetval = 0L;
        Log.d((String)"usb-get-perm", (String)"USBGetPermission >");
        if (context == null) {
            lRetval = -2146435068L;
            Log.e((String)TAG, (String)"SCARD_E_INVALID_PARAMETER");
        } else if (gnRdrPos != -1) {
            Log.d((String)"usb-get-perm", (String)("Asking for >" + UsbRdrList.get(gnRdrPos)));
            mManager = (UsbManager)context.getSystemService("usb");
            mManager.requestPermission(UsbRdrList.get(gnRdrPos), mPermissionIntent);
            try {
                Thread.sleep(100L);
                Log.d((String)"usb-get-perm", (String)"Woke up");
            }
            catch (InterruptedException e) {
                Log.d((String)"usb-get-perm", (String)"Crash");
                e.printStackTrace();
                lRetval = -2146435055L;
            }
        }
        Log.d((String)"usb-get-perm", (String)("USBGetPermission <. " + lRetval));
        return lRetval;
    }

    public long USBRequestPermission(Context context) {
        long lRetval = 0L;
        mManager = (UsbManager)context.getSystemService("usb");
        mPermissionIntent = PendingIntent.getBroadcast((Context)context, (int)0, (Intent)new Intent(ACTION_USB_PERMISSION), (int)0);
        IntentFilter filter = new IntentFilter(ACTION_USB_PERMISSION);
        filter.addAction("android.hardware.usb.action.USB_DEVICE_ATTACHED");
        filter.addAction("android.hardware.usb.action.USB_DEVICE_DETACHED");
        context.registerReceiver(this.mUsbReceiver, filter);
        UsbRdrList = new ArrayList();
        UsbRdrList.clear();
        for (UsbDevice device : mManager.getDeviceList().values()) {
            Log.i((String)"GetPermission", (String)("Found device: " + device));
            if (device.getVendorId() != 1254 && device.getVendorId() != 8186) continue;
            UsbRdrList.add(device);
            Log.i((String)"GetPermission", (String)("Adding device: " + device));
        }
        gnRdrPos = 0;
        Log.d((String)"GetPermission", (String)("Calling reader " + UsbRdrList.get(gnRdrPos)));
        lRetval = this.USBGetPermission(context);
        return lRetval;
    }

    public long SCardEstablishContext(Context context) {
        Log.i((String)TAG, (String)("<< SCardEstablishContext >>" + context));
        long lRetval = 0L;
        if (context == null) {
            lRetval = -2146435068L;
            Log.e((String)TAG, (String)"SCARD_E_INVALID_PARAMETER");
        } else {
            mManager = (UsbManager)context.getSystemService("usb");
            if (mManager == null) {
                lRetval = -2146435069L;
                Log.e((String)TAG, (String)"SCARD_E_INVALID_HANDLE");
            }
        }
        Log.d((String)TAG, (String)("Passed - " + mManager));
        return lRetval;
    }

    public long SCardListReaders(Context context, ArrayList<String> deviceList) {
        Log.i((String)TAG, (String)"<< SCardListReaders >>");
        Log.d((String)TAG, (String)("Parameters - 1. " + context + "2. " + deviceList));
        long lRetval = 0L;
        details = new ArrayList();
        if (context == null) {
            lRetval = -2146435068L;
            Log.e((String)TAG, (String)"SCARD_E_INVALID_PARAMETER");
        } else if (mManager == null) {
            lRetval = -2146435069L;
            Log.e((String)TAG, (String)"SCARD_E_INVALID_HANDLE - 1");
        } else {
            Log.d((String)TAG, (String)("" + mManager.getDeviceList().isEmpty()));
            Log.d((String)TAG, (String)("" + mManager.getDeviceList().size()));
            if (mManager.getDeviceList().isEmpty()) {
                lRetval = -2146435026L;
                Log.e((String)TAG, (String)"SCARD_E_NO_READERS_AVAILABLE-1");
            } else if (deviceList == null) {
                lRetval = -2146435064L;
                Log.e((String)TAG, (String)"SCARD_E_INSUFFICIENT_BUFFER-1");
            } else {
                deviceList.clear();
                block0: for (UsbDevice device : mManager.getDeviceList().values()) {
                    Log.d((String)TAG, (String)("Device - " + device.getDeviceName() + "Device ID - " + device.getDeviceId() + "Device VID - " + device.getVendorId()));
                    String deviceName = null;
                    UsbDeviceConnection connection = null;
                    int index = 0;
                    if (device.getVendorId() != 1254 && device.getVendorId() != 8186) continue;
                    if (!mManager.hasPermission(device)) {
                        Log.d((String)TAG, (String)(device + " does not have permission.. skipping"));
                        continue;
                    }
                    connection = mManager.openDevice(device);
                    Log.d((String)TAG, (String)("Connection - " + connection));
                    if (connection == null) {
                        lRetval = -2146435069L;
                        Log.e((String)TAG, (String)("SCARD_E_INVALID_HANDLE - " + lRetval));
                        continue;
                    }
                    byte[] rawBuf = new byte[255];
                    rawBuf = connection.getRawDescriptors();
                    int start = 27;
                    int i = 0;
                    while (i < device.getInterfaceCount()) {
                        UsbInterface intf;
                        RdrDetails rdetails = new RdrDetails();
                        rdetails.rDevice = device;
                        rdetails.rIntf = intf = device.getInterface(i);
                        if (intf.getInterfaceClass() == 11 && intf.getInterfaceSubclass() == 0) {
                            index = device.getInterfaceCount() == 1 ? 770 : 0x300 | rawBuf[start + 8];
                            byte[] ManuStringBuf = new byte[255];
                            int len = connection.controlTransfer(128, 6, 769, 1033, ManuStringBuf, 255, 5000);
                            if (len < 0) {
                                lRetval = 22L;
                                Log.e((String)TAG, (String)"ERROR_BAD_COMMAND");
                                continue block0;
                            }
                            ManuStringBuf = Arrays.copyOfRange(ManuStringBuf, 2, len);
                            deviceName = new String(ManuStringBuf);
                            rdetails.MString = new String(ManuStringBuf);
                            byte[] RdrStringBuf = new byte[255];
                            len = connection.controlTransfer(128, 6, index, 1033, RdrStringBuf, 255, 5000);
                            if (len < 0) {
                                lRetval = 22L;
                                Log.e((String)TAG, (String)"ERROR_BAD_COMMAND");
                                continue block0;
                            }
                            RdrStringBuf = Arrays.copyOfRange(RdrStringBuf, 2, len);
                            rdetails.RString = new String(RdrStringBuf);
                            int j = 0;
                            deviceName = String.valueOf(deviceName) + " " + new String(RdrStringBuf) + " " + j;
                            while (deviceList.contains(deviceName)) {
                                deviceName = String.valueOf(deviceName) + " " + new String(RdrStringBuf) + " " + ++j;
                            }
                            deviceList.add(deviceName);
                            rdetails.RdrName = new String(deviceName);
                            rdetails.unitno = (short)j;
                            Log.d((String)TAG, (String)("Device Name - " + deviceName));
                            index = 0x300 | rawBuf[16];
                            byte[] serialNo = new byte[30];
                            len = connection.controlTransfer(128, 6, index, 1033, serialNo, 30, 5000);
                            if (len < 0) {
                                lRetval = 22L;
                                Log.e((String)TAG, (String)"ERROR_BAD_COMMAND");
                                continue block0;
                            }
                            serialNo = Arrays.copyOfRange(serialNo, 2, len);
                            rdetails.serialno = new String(serialNo);
                            rdetails.nVerMajor = rawBuf[13];
                            rdetails.nVerMinor = rawBuf[12];
                            rdetails.byProtocols = new byte[]{rawBuf[42], rawBuf[43], rawBuf[44], rawBuf[45]};
                            rdetails.byDefClk = new byte[]{rawBuf[46], rawBuf[47], rawBuf[48], rawBuf[49]};
                            rdetails.byMaxClk = new byte[]{rawBuf[50], rawBuf[51], rawBuf[52], rawBuf[53]};
                            rdetails.byDefDataRate = new byte[]{rawBuf[55], rawBuf[56], rawBuf[57], rawBuf[58]};
                            rdetails.byMaxDataRate = new byte[]{rawBuf[59], rawBuf[60], rawBuf[61], rawBuf[62]};
                            rdetails.byMaxIFSD = new byte[]{rawBuf[64], rawBuf[65], rawBuf[66], rawBuf[67]};
                            if (rawBuf[start + 51] == 4) {
                                bAPDURdrType = true;
                            }
                            rdetails.rMode = bAPDURdrType;
                            int k = 0;
                            while (k < 4) {
                                nMaxCCIDLen = (int)((long)nMaxCCIDLen + (((long)rawBuf[start + 53 + k] & 0xFFL) << 8 * k));
                                ++k;
                            }
                            rdetails.nCCIDLen = nMaxCCIDLen;
                            start += 84;
                        } else {
                            start += 9 + rawBuf[9 + start] + intf.getEndpointCount() * 7;
                        }
                        details.add(rdetails);
                        ++i;
                    }
                }
                if (lRetval == 0L && !mManager.getDeviceList().isEmpty() && deviceList.isEmpty()) {
                    lRetval = -2146435026L;
                    Log.e((String)TAG, (String)"SCARD_E_NO_READERS_AVAILABLE - 2");
                }
            }
        }
        int k = 0;
        while (k < deviceList.size()) {
            Log.d((String)TAG, (String)deviceList.get(k));
            ++k;
        }
        nReaders = deviceList.size();
        return lRetval;
    }

    private void defineEndPoints(UsbInterface mIntf) {
        Log.i((String)TAG, (String)"<< defineEndPoints >>");
        UsbEndpoint epOut = null;
        UsbEndpoint epIn = null;
        UsbEndpoint epInt = null;
        int i = 0;
        while (i < mIntf.getEndpointCount()) {
            UsbEndpoint ep = mIntf.getEndpoint(i);
            if (ep.getType() == 2) {
                if (ep.getDirection() == 0) {
                    epOut = ep;
                } else {
                    epIn = ep;
                }
            } else if (ep.getType() == 3) {
                epInt = ep;
            }
            ++i;
        }
        if (epOut == null || epIn == null) {
            throw new IllegalArgumentException("not all endpoints found");
        }
        mEndpointOut = epOut;
        mEndpointIn = epIn;
        mEndpointInterrupt = epInt;
    }

    ByteBuffer UsbTransfer(byte[] inBuffer) {
        Log.i((String)TAG, (String)"<< UsbTransfer >>");
        int len = 0;
        long lStartTime = new Date().getTime();
        String str = "";
        len = mConnection.bulkTransfer(mEndpointOut, inBuffer, inBuffer.length, 5000);
        if (len < 0) {
            return null;
        }
        int i = 0;
        while (i < len) {
            str = String.valueOf(str) + inBuffer[i] + " ";
            ++i;
        }
        Log.d((String)TAG, (String)str);
        byte[] outbuffer = new byte[300];
        do {
            if ((len = mConnection.bulkTransfer(mEndpointIn, outbuffer, outbuffer.length, 5000)) >= 0) continue;
            return null;
        } while (len == 10 && (outbuffer[7] & 0xFF) == 128);
        str = "";
        int i2 = 0;
        while (i2 < len) {
            str = String.valueOf(str) + outbuffer[i2] + " ";
            ++i2;
        }
        Log.d((String)TAG, (String)str);
        long lEndTime = new Date().getTime();
        difference = difference + lEndTime - lStartTime;
        ByteBuffer buffer = ByteBuffer.allocate(len);
        buffer.put(outbuffer, 0, len);
        return buffer;
    }

    /*
     * Unable to fully structure code
     */
    public long SCardConnect(String RdrName, int nMode, int nPreferredProtocols) {
        block9: {
            block8: {
                Log.i((String)"SCard Library", (String)"<< SCardConnect >>");
                lRetval = -2146435052L;
                resManager = new ResourceManager();
                rdrIndex = 0;
                if (SCard.mManager != null) break block8;
                lRetval = -2146435069L;
                Log.e((String)"SCard Library", (String)"SCARD_E_INVALID_HANDLE - 1");
                break block9;
            }
            if (!SCard.details.isEmpty()) ** GOTO lbl17
            lRetval = -2146435063L;
            break block9;
            while (!SCard.details.get((int)rdrIndex).RdrName.equals(RdrName)) {
                ++rdrIndex;
lbl17:
                // 2 sources

                if (rdrIndex < SCard.nReaders) continue;
            }
            if (rdrIndex == SCard.nReaders) {
                lRetval = -2146435049L;
                Log.e((String)"SCard Library", (String)"SCARD_E_READER_UNAVAILABLE");
            } else {
                device = SCard.details.get((int)rdrIndex).rDevice;
                intf = SCard.details.get((int)rdrIndex).rIntf;
                connection = SCard.mManager.openDevice(device);
                if (connection != null) {
                    if (connection.claimInterface(intf, true)) {
                        SCard.mConnection = connection;
                        this.defineEndPoints(intf);
                        resManager.RM_UpdateReaderNameInDB(SCard.details.get(rdrIndex));
                        lRetval = resManager.RM_SCardConnect(RdrName, nMode, nPreferredProtocols);
                        if (lRetval != 0L) {
                            SCard.mConnection = null;
                            SCard.mEndpointIn = null;
                            SCard.mEndpointInterrupt = null;
                            SCard.mEndpointOut = null;
                        }
                    } else {
                        connection.close();
                    }
                } else {
                    lRetval = -2146435069L;
                    Log.e((String)"SCard Library", (String)"SCARD_E_INVALID_HANDLE - 2");
                }
            }
        }
        return lRetval;
    }

    public long SCardTransmit(SCardIOBuffer transmit) {
        Log.i((String)TAG, (String)"<< SCardTransmit >>");
        long lRetval = -2146435052L;
        ResourceManager resManager = new ResourceManager();
        if (mManager == null || mConnection == null || mEndpointIn == null || mEndpointOut == null || mEndpointInterrupt == null) {
            lRetval = -2146435069L;
            Log.e((String)TAG, (String)"SCARD_E_INVALID_HANDLE");
        } else if (transmit == null) {
            lRetval = -2146435068L;
            Log.e((String)TAG, (String)"SCARD_E_INVALID_PARAMETER");
        } else {
            lRetval = resManager.RM_Transmit(transmit);
        }
        return lRetval;
    }

    public long SCardReconnect(int nMode, int nPreferredProtocols, int nInitialization) {
        Log.i((String)TAG, (String)"<< SCardReconnect >>");
        long lRetval = -2146435052L;
        ResourceManager resManager = new ResourceManager();
        if (mManager == null || mConnection == null || mEndpointIn == null || mEndpointOut == null || mEndpointInterrupt == null) {
            lRetval = -2146435069L;
            Log.e((String)TAG, (String)"SCARD_E_INVALID_HANDLE");
        } else {
            lRetval = resManager.RM_SCardReconnect(nMode, nPreferredProtocols, nInitialization);
            if (lRetval != 0L) {
                mConnection = null;
                mEndpointIn = null;
                mEndpointOut = null;
                mEndpointInterrupt = null;
            }
        }
        return lRetval;
    }

    public long SCardDisconnect(int nDisposition) {
        Log.i((String)TAG, (String)"<< SCardDisconnect >>");
        long lRetval = 0L;
        ResourceManager resManager = new ResourceManager();
        if (mManager == null || mConnection == null || mEndpointIn == null || mEndpointOut == null || mEndpointInterrupt == null) {
            lRetval = -2146435069L;
            Log.e((String)TAG, (String)"SCARD_E_INVALID_HANDLE");
        } else if (nDisposition == 0 || nDisposition > 4) {
            lRetval = -2146435068L;
            Log.e((String)TAG, (String)"SCARD_E_INVALID_PARAMETER");
        } else {
            lRetval = resManager.RM_CloseCardHandle(nDisposition);
        }
        mConnection = null;
        mEndpointIn = null;
        mEndpointOut = null;
        mEndpointInterrupt = null;
        return lRetval;
    }

    public long SCardControl(int nControlCode, SCardIOBuffer transmit) {
        Log.i((String)TAG, (String)"<< SCardControl >>");
        long lRetval = -2146435052L;
        ResourceManager resManager = new ResourceManager();
        if (mManager == null || mConnection == null || mEndpointIn == null || mEndpointOut == null || mEndpointInterrupt == null) {
            lRetval = -2146435069L;
            Log.e((String)TAG, (String)"SCARD_E_INVALID_HANDLE");
        } else if (transmit == null || nControlCode != (int)WinDefs.IOCTL_CCID_ESCAPE) {
            lRetval = -2146435068L;
            Log.e((String)TAG, (String)"SCARD_E_INVALID_PARAMETER");
        } else {
            lRetval = resManager.RM_SCardControl(nControlCode, transmit);
        }
        return lRetval;
    }

    public long SCardStatus(SCardState cState) {
        Log.i((String)TAG, (String)"<< SCardStatus >>");
        long lRetval = 0L;
        ResourceManager resManager = new ResourceManager();
        if (mManager == null || mConnection == null || mEndpointIn == null || mEndpointOut == null) {
            lRetval = -2146435069L;
            Log.e((String)TAG, (String)"SCARD_E_INVALID_HANDLE");
        } else if (cState == null) {
            lRetval = -2146435068L;
            Log.e((String)TAG, (String)"SCARD_E_INVALID_PARAMETER");
        } else {
            lRetval = resManager.RM_SCardStatus(cState);
        }
        return lRetval;
    }

    public long SCardReleaseContext() {
        Log.i((String)TAG, (String)"<< SCardReleaseContext >>");
        if (mManager != null) {
            mManager = null;
        }
        return 0L;
    }

    /*
     * Unable to fully structure code
     */
    public long SCardGetStatusChange(long dwTimeout, SCARD_READERSTATE[] rgReaderStates, int cReaders) {
        block8: {
            block9: {
                block7: {
                    Log.i((String)"SCard Library", (String)"<< SCardGetStatusChange >>");
                    lRetval = -2146435062L;
                    resManager = new ResourceManager();
                    rdrIndex = 0;
                    if (SCard.mManager != null) break block7;
                    lRetval = -2146435069L;
                    Log.e((String)"SCard Library", (String)"SCARD_E_INVALID_HANDLE");
                    break block8;
                }
                if (rgReaderStates != null && cReaders == 1) break block9;
                lRetval = -2146435068L;
                Log.e((String)"SCard Library", (String)"SCARD_E_INVALID_PARAMETER");
                break block8;
            }
            if (!SCard.details.isEmpty()) ** GOTO lbl23
            lRetval = -2146435063L;
            break block8;
            while (!SCard.details.get((int)rdrIndex).RdrName.equals(rgReaderStates[0].getSzReader())) {
                ++rdrIndex;
lbl23:
                // 2 sources

                if (rdrIndex < SCard.nReaders) continue;
            }
            if (rdrIndex == SCard.nReaders) {
                lRetval = -2146435049L;
                Log.e((String)"SCard Library", (String)"SCARD_E_READER_UNAVAILABLE");
            } else {
                if (SCard.mConnection == null) {
                    SCard.mConnection = SCard.mManager.openDevice(SCard.details.get((int)rdrIndex).rDevice);
                    if (SCard.mConnection != null) {
                        intf = SCard.details.get((int)rdrIndex).rIntf;
                        if (SCard.mConnection.claimInterface(intf, true)) {
                            this.defineEndPoints(intf);
                        }
                        resManager.RM_UpdateReaderNameInDB(SCard.details.get(rdrIndex));
                    }
                    rgReaderStates[0].setPvUserData(new byte[]{1});
                } else {
                    rgReaderStates[0].setPvUserData(new byte[1]);
                }
                lRetval = resManager.RM_SCardGetStatusChange(dwTimeout, rgReaderStates, cReaders);
            }
        }
        return lRetval;
    }

    public long SCardGetAttrib(SCardAttribute attr) {
        Log.i((String)TAG, (String)"<< SCardGetAttrib >>");
        long lRetval = 0L;
        ResourceManager resManager = new ResourceManager();
        if (mManager == null || mConnection == null || mEndpointIn == null || mEndpointOut == null) {
            lRetval = -2146435069L;
            Log.e((String)TAG, (String)"SCARD_E_INVALID_HANDLE");
        } else if (attr == null) {
            lRetval = -2146435068L;
            Log.e((String)TAG, (String)"SCARD_E_INVALID_PARAMETER");
        } else {
            lRetval = resManager.RM_SCardGetAttrib(attr);
        }
        return lRetval;
    }

    long SCardSetAttrib(SCardAttribute attr) {
        Log.i((String)TAG, (String)"<< SCardSetAttrib >>");
        long lRetval = 0L;
        ResourceManager resManager = new ResourceManager();
        if (mManager == null || mConnection == null || mEndpointIn == null || mEndpointOut == null) {
            lRetval = -2146435069L;
            Log.e((String)TAG, (String)"SCARD_E_INVALID_HANDLE");
        } else if (attr == null) {
            lRetval = -2146435068L;
            Log.e((String)TAG, (String)"SCARD_E_INVALID_PARAMETER");
        } else {
            lRetval = resManager.RM_SCardSetAttrib(attr);
        }
        return lRetval;
    }

    long SCardBeginTransaction() {
        return 0L;
    }

    long SCardEndTransaction(int dwDisposition) {
        return 0L;
    }

    class RdrDetails {
        UsbDevice rDevice;
        UsbInterface rIntf;
        boolean rMode;
        int nCCIDLen;
        String RdrName;
        String MString;
        String RString;
        short unitno;
        String serialno;
        short nVerMajor;
        short nVerMinor;
        byte[] byProtocols;
        byte[] byDefClk;
        byte[] byMaxClk;
        byte[] byDefDataRate;
        byte[] byMaxDataRate;
        byte[] byMaxIFSD;

        RdrDetails() {
        }
    }

    public class SCARD_READERSTATE {
        String szReader;
        byte[] pvUserData;
        int nCurrentState;
        int nEventState;
        int nAtr;
        byte[] abyAtr = new byte[36];

        public String getSzReader() {
            return this.szReader;
        }

        public void setSzReader(String szReader) {
            this.szReader = szReader;
        }

        public byte[] getPvUserData() {
            return this.pvUserData;
        }

        public void setPvUserData(byte[] pvUserData) {
            this.pvUserData = pvUserData;
        }

        public int getnCurrentState() {
            return this.nCurrentState;
        }

        public void setnCurrentState(int nCurrentState) {
            this.nCurrentState = nCurrentState;
        }

        public int getnEventState() {
            return this.nEventState;
        }

        public void setnEventState(int nEventState) {
            this.nEventState = nEventState;
        }

        public int getnAtr() {
            return this.nAtr;
        }

        public void setnAtr(int nAtr) {
            this.nAtr = nAtr;
        }

        public byte[] getabyAtr() {
            return this.abyAtr;
        }

        public void setsbyAtr(byte[] abyAtr) {
            this.abyAtr = abyAtr;
        }
    }

    public class SCardAttribute {
        int nAttrId;
        int nAttrLen;
        byte[] abyAttr;

        public int getnAttrId() {
            return this.nAttrId;
        }

        public void setnAttrId(int nAttrId) {
            this.nAttrId = nAttrId;
        }

        public int getnAttrLen() {
            return this.nAttrLen;
        }

        public void setnAttrLen(int nAttrLen) {
            this.nAttrLen = nAttrLen;
        }

        public byte[] getAbyAttr() {
            return this.abyAttr;
        }

        public void setAbyAttr(byte[] abyAttr) {
            this.abyAttr = abyAttr;
        }
    }

    public class SCardIOBuffer {
        byte[] abyInBuffer;
        int nInBufferSize;
        byte[] abyOutBuffer;
        int nOutBufferSize;
        int nBytesReturned;

        public byte[] getAbyInBuffer() {
            return this.abyInBuffer;
        }

        public void setAbyInBuffer(byte[] abyInBuffer) {
            this.abyInBuffer = abyInBuffer;
        }

        public int getnInBufferSize() {
            return this.nInBufferSize;
        }

        public void setnInBufferSize(int nInBufferSize) {
            this.nInBufferSize = nInBufferSize;
        }

        public byte[] getAbyOutBuffer() {
            return this.abyOutBuffer;
        }

        public void setAbyOutBuffer(byte[] abyOutBuffer) {
            this.abyOutBuffer = abyOutBuffer;
        }

        public int getnOutBufferSize() {
            return this.nOutBufferSize;
        }

        public void setnOutBufferSize(int nOutBufferSize) {
            this.nOutBufferSize = nOutBufferSize;
        }

        public int getnBytesReturned() {
            return this.nBytesReturned;
        }

        public void setnBytesReturned(int nBytesReturned) {
            this.nBytesReturned = nBytesReturned;
        }
    }

    public class SCardState {
        String szReader;
        int nState;
        int nProtocol;
        byte[] abyATR = new byte[33];
        int nATRlen;

        public String getSzReader() {
            return this.szReader;
        }

        public void setSzReader(String szReader) {
            this.szReader = szReader;
        }

        public int getnState() {
            return this.nState;
        }

        public void setnState(int nState) {
            this.nState = nState;
        }

        public int getnProtocol() {
            return this.nProtocol;
        }

        public void setnProtocol(int nProtocol) {
            this.nProtocol = nProtocol;
        }

        public byte[] getAbyATR() {
            return this.abyATR;
        }

        public void setAbyATR(byte[] abyATR) {
            this.abyATR = abyATR;
        }

        public int getnATRlen() {
            return this.nATRlen;
        }

        public void setnATRlen(int nATRlen) {
            this.nATRlen = nATRlen;
        }
    }
}

