/*
 * Decompiled with CFR 0.152.
 */
package com.identive.libs;

import com.identive.libs.IFDLayer;
import com.identive.libs.IFDLayerInterface;
import java.nio.ByteBuffer;

class SmcLib {
    static final int MAX_ATR_CODES = 10;
    static final int MIN_ATR_LEN = 2;
    static final int MAX_ATR_LEN = 33;
    static final int TS_BYTE_INVERSE = 63;
    static final int TS_BYTE_DIRECT = 59;
    static final int LOWER_NIBBLE = 15;
    static final int UPPER_NIBBLE = 240;
    static final long TR = 1000000L;
    static long[][] sBitRateAdjustment = new long[][]{new long[2], {1L, 1L}, {2L, 1L}, {4L, 1L}, {8L, 1L}, {16L, 1L}, {32L, 1L}, {64L, 1L}, {12L, 1L}, {20L, 1L}, {20L, 1L}, {20L, 1L}, {20L, 1L}, {20L, 1L}, {20L, 1L}};
    static long[][] sClockRateConversion = new long[][]{{372L, 4000000L}, {372L, 5000000L}, {558L, 6000000L}, {744L, 8000000L}, {1116L, 12000000L}, {1488L, 16000000L}, {1860L, 20000000L}, {372L, 4000000L}, {372L, 4000000L}, {512L, 5000000L}, {768L, 7500000L}, {1024L, 10000000L}, {1536L, 15000000L}, {2048L, 20000000L}, {372L, 4000000L}, {372L, 4000000L}};
    static final int SCARD_T1_EPILOGUE_LENGTH = 2;
    static final int SCARD_T1_MAX_IFS = 254;
    static final int MIN_BUFFER_SIZE = 288;
    static final int MAXIMUM_ATR_CODES = 4;
    static final int MAXIMUM_ATR_LENGTH = 33;
    static final int T1_INIT = 0;
    static final int T1_START = 1;
    static final int T1_I_BLOCK = 2;
    static final int T1_R_BLOCK = 3;
    static final int T1_RESTART = 4;
    static final int T1_RESYNCH_REQUEST = 192;
    static final int T1_RESYNCH_RESPONSE = 224;
    static final int T1_IFS_REQUEST = 193;
    static final int T1_IFS_RESPONSE = 225;
    static final int T1_ABORT_REQUEST = 194;
    static final int T1_ABORT_RESPONSE = 226;
    static final int T1_WTX_REQUEST = 195;
    static final int T1_WTX_RESPONSE = 227;
    static final int T1_VPP_ERROR = 228;
    static final int T1_IFSD = 254;
    static final int T1_IFSD_DEFAULT = 32;
    static final int T1_MAX_RETRIES = 2;
    static final int T1_MORE_DATA = 32;
    static final int T1_ERROR_CHKSUM = 1;
    static final int T1_ERROR_OTHER = 2;
    static final int T1_CWI_DEFAULT = 13;
    static final int T1_BWI_DEFAULT = 4;
    static final int SCARD_T1_PROLOGUE_LENGTH = 3;
    static final int T1_CRC_CHECK = 1;

    SmcLib() {
    }

    static void SmartcardInvertData(ByteBuffer Buffer2, long Length, int tempI) {
        long i = tempI;
        while (i < Length) {
            int inv = 0;
            int j = 0;
            while (j < 8) {
                if ((Buffer2.get((int)i) & 1 << j) != 0) {
                    inv = (char)(inv | 1 << 7 - j);
                }
                j = (char)(j + 1);
            }
            Buffer2.put((int)i, (byte)(inv ^ 0xFF));
            ++i;
        }
    }

    static boolean SmartcardT1Chksum(ByteBuffer Block, char Edc, boolean Verify, int tempI) {
        boolean fRet = true;
        int crc = 0;
        Short offset = (short)((Block.get(2) & 0xFF) + 3);
        short[] sArray = new short[16];
        sArray[1] = -16191;
        sArray[2] = -15999;
        sArray[3] = 320;
        sArray[4] = -15615;
        sArray[5] = 960;
        sArray[6] = 640;
        sArray[7] = -15807;
        sArray[8] = -14847;
        sArray[9] = 1728;
        sArray[10] = 1920;
        sArray[11] = -14527;
        sArray[12] = 1280;
        sArray[13] = -14911;
        sArray[14] = -15231;
        sArray[15] = 1088;
        short[] crc16a = sArray;
        short[] sArray2 = new short[16];
        sArray2[1] = -13311;
        sArray2[2] = -10239;
        sArray2[3] = 5120;
        sArray2[4] = -4095;
        sArray2[5] = 15360;
        sArray2[6] = 10240;
        sArray2[7] = -7167;
        sArray2[8] = -24575;
        sArray2[9] = 27648;
        sArray2[10] = 30720;
        sArray2[11] = -19455;
        sArray2[12] = 20480;
        sArray2[13] = -25599;
        sArray2[14] = -30719;
        sArray2[15] = 17920;
        short[] crc16b = sArray2;
        if ((Edc & '\u0001') != 0) {
            short i = (short)tempI;
            while (i < offset) {
                char tmp = (char)(Block.get(i) ^ (char)crc);
                crc = (short)(crc >> 8 ^ crc16a[tmp & 0xF] ^ crc16b[tmp >> 4]);
                i = (short)(i + 1);
            }
            if (Verify) {
                return crc == (Block.get(offset + 1) | Block.get(offset.shortValue()) << 8);
            }
            Block.put((int)offset.shortValue(), (byte)(crc >> 8));
            Block.put(offset + 1, (byte)(crc & 0xFF));
        } else {
            short lrc = Block.get(0);
            short i = 1;
            while (i < offset) {
                lrc = (short)(lrc ^ Block.get(i));
                i = (short)(i + 1);
            }
            if (Verify) {
                return lrc == Block.get(offset.shortValue());
            }
            Block.put((int)offset.shortValue(), (byte)lrc);
        }
        return fRet;
    }

    long SmartcardInitialize(SMARTCARD_EXTENSION Smartcard) {
        long status = 0L;
        if (Smartcard == null) {
            return -995L;
        }
        if (Smartcard.SmartcardRequest.BufferSize < 288L) {
            Smartcard.SmartcardRequest.BufferSize = 288L;
        }
        if (Smartcard.SmartcardReply.BufferSize < 288L) {
            Smartcard.SmartcardReply.BufferSize = 288L;
        }
        Smartcard.SmartcardRequest.Buffer = ByteBuffer.allocate(288);
        Smartcard.SmartcardReply.Buffer = ByteBuffer.allocate(288);
        if (Smartcard.SmartcardRequest.Buffer == null || Smartcard.SmartcardReply.Buffer == null) {
            status = -997L;
        }
        if (status != 0L) {
            return status;
        }
        Smartcard.T1.IFSD = (char)Smartcard.ReaderCapabilities.MaxIFSD;
        return status;
    }

    void SmartcardExit(SMARTCARD_EXTENSION Smartcard) {
        if (Smartcard.SmartcardRequest.Buffer != null) {
            Smartcard.SmartcardRequest.Buffer = null;
        }
        if (Smartcard.SmartcardReply.Buffer != null) {
            Smartcard.SmartcardReply.Buffer = null;
        }
        if (Smartcard.T1.ReplyData != null) {
            Smartcard.T1.ReplyData = null;
        }
    }

    long SmartcardT1Request(SMARTCARD_EXTENSION Smartcard) {
        SMARTCARD_REQUEST smartcardRequest = Smartcard.SmartcardRequest;
        T1_BLOCK_FRAME t1SendFrame = new T1_BLOCK_FRAME();
        if (Smartcard.T1.WaitForReply) {
            Smartcard.T1.State = 0L;
        }
        Smartcard.T1.WaitForReply = true;
        switch ((int)Smartcard.T1.State) {
            case 0: {
                Smartcard.T1.State = 193L;
                Smartcard.AwaitingFirstResponse = true;
            }
            case 1: {
                Smartcard.T1.Resynch = '\u0000';
                Smartcard.CardStartedChaining = false;
                Smartcard.InvalidRetryCount = 0;
                Smartcard.ResynchRetryCount = 0;
                if (Smartcard.T1.ReplyData != null) {
                    Smartcard.T1.ReplyData = null;
                }
                if (Smartcard.iorequest.ReplyBufferLength < 2L) {
                    return -992L;
                }
                Smartcard.T1.ReplyData = ByteBuffer.allocate(131072);
                if (Smartcard.T1.ReplyData == null) {
                    return -997L;
                }
            }
            case 4: {
                Smartcard.T1.BytesToSend = Smartcard.iorequest.RequestBufferLength;
                Smartcard.T1.BytesSent = 0L;
                Smartcard.T1.BytesReceived = 0L;
                Smartcard.T1.IFSC = Smartcard.CardCapabilities.t1.IFSC;
                Smartcard.T1.Resend = '\u0000';
                Smartcard.T1.OriginalState = 0L;
                Smartcard.T1.MoreData = false;
            }
            case 193: {
                if (Smartcard.T1.State == 193L) {
                    Smartcard.T1.State = 193L;
                    t1SendFrame.Nad = (byte)Smartcard.T1.NAD;
                    t1SendFrame.Pcb = (byte)-63;
                    t1SendFrame.Len = 1;
                    t1SendFrame.Inf.put(0, (byte)Smartcard.T1.IFSD);
                    Smartcard.AwaitingFirstResponse = true;
                    break;
                }
                Smartcard.T1.State = 2L;
            }
            case 2: {
                Smartcard.T1.State = 2L;
                Smartcard.T1.InfBytesSent = Smartcard.T1.IFSC;
                if (Smartcard.T1.InfBytesSent > Smartcard.T1.IFSD) {
                    Smartcard.T1.InfBytesSent = Smartcard.T1.IFSD;
                }
                if (Smartcard.T1.BytesToSend > (long)Smartcard.T1.InfBytesSent) {
                    Smartcard.T1.MoreData = true;
                    t1SendFrame.Len = (byte)Smartcard.T1.InfBytesSent;
                } else {
                    Smartcard.T1.MoreData = false;
                    t1SendFrame.Len = (byte)Smartcard.T1.BytesToSend;
                }
                t1SendFrame.Nad = (byte)Smartcard.T1.NAD;
                t1SendFrame.Pcb = (byte)(Smartcard.T1.SSN << 6 | (Smartcard.T1.MoreData ? 32 : 0));
                System.arraycopy(Smartcard.iorequest.RequestBuffer.array(), (int)Smartcard.T1.BytesSent, t1SendFrame.Inf.array(), 0, t1SendFrame.Len & 0xFF);
                break;
            }
            case 3: {
                t1SendFrame.Nad = (byte)Smartcard.T1.NAD;
                t1SendFrame.Pcb = (byte)(0x80 | Smartcard.T1.RSN << 4 | Smartcard.T1.LastError);
                if (Smartcard.T1.LastError != '\u0000') {
                    Smartcard.T1.LastError = '\u0000';
                    if (Smartcard.T1.OriginalState == 0L) {
                        Smartcard.T1.State = 1L;
                        return -996L;
                    }
                    Smartcard.T1.State = Smartcard.T1.OriginalState;
                }
                t1SendFrame.Len = 0;
                t1SendFrame.Inf = null;
                break;
            }
            case 225: {
                if (Smartcard.T1.OriginalState == 0L) {
                    Smartcard.T1.State = Smartcard.T1.OriginalState;
                }
                t1SendFrame.Nad = (byte)Smartcard.T1.NAD;
                t1SendFrame.Pcb = (byte)-31;
                t1SendFrame.Len = 1;
                t1SendFrame.Inf.putInt(Smartcard.T1.IFSC);
                break;
            }
            case 192: {
                t1SendFrame.Nad = (byte)Smartcard.T1.NAD;
                t1SendFrame.Pcb = (byte)-64;
                t1SendFrame.Len = 0;
                t1SendFrame.Inf = null;
                Smartcard.T1.SSN = '\u0000';
                break;
            }
            case 194: {
                t1SendFrame.Nad = (byte)Smartcard.T1.NAD;
                t1SendFrame.Pcb = (byte)-62;
                t1SendFrame.Len = 0;
                t1SendFrame.Inf = null;
                break;
            }
            case 226: {
                Smartcard.T1.State = 1L;
                t1SendFrame.Nad = (byte)Smartcard.T1.NAD;
                t1SendFrame.Pcb = (byte)-30;
                t1SendFrame.Len = 0;
                t1SendFrame.Inf = null;
                break;
            }
            case 227: {
                Smartcard.T1.State = Smartcard.T1.OriginalState;
                t1SendFrame.Nad = (byte)Smartcard.T1.NAD;
                t1SendFrame.Pcb = (byte)-29;
                t1SendFrame.Len = 1;
                t1SendFrame.Inf.putInt(Smartcard.T1.Wtx);
            }
        }
        smartcardRequest.Buffer.put((int)smartcardRequest.BufferLength, t1SendFrame.Nad);
        smartcardRequest.Buffer.put((int)smartcardRequest.BufferLength + 1, t1SendFrame.Pcb);
        smartcardRequest.Buffer.put((int)smartcardRequest.BufferLength + 2, t1SendFrame.Len);
        if ((t1SendFrame.Len & 0xFF) > 0) {
            System.arraycopy(t1SendFrame.Inf.array(), 0, smartcardRequest.Buffer.array(), (int)(smartcardRequest.BufferLength + 3L), t1SendFrame.Len & 0xFF);
        }
        SmcLib.SmartcardT1Chksum(smartcardRequest.Buffer, Smartcard.CardCapabilities.t1.EDC, false, (int)smartcardRequest.BufferLength);
        if (Smartcard.CardCapabilities.InversConvention) {
            SmcLib.SmartcardInvertData(smartcardRequest.Buffer, ((Smartcard.CardCapabilities.t1.EDC & '\u0001') != 0 ? 5 : 4) + t1SendFrame.Len, (int)smartcardRequest.BufferLength);
        }
        smartcardRequest.BufferLength = smartcardRequest.BufferLength + (long)(((Smartcard.CardCapabilities.t1.EDC & '\u0001') != 0 ? 5 : 4) + (t1SendFrame.Len & 0xFF));
        return 0L;
    }

    /*
     * Unable to fully structure code
     */
    long SmartcardT1Reply(SMARTCARD_EXTENSION Smartcard, IFDLayer.READER_EXTENSION ReaderExtn) {
        block48: {
            block52: {
                block53: {
                    block51: {
                        block50: {
                            block49: {
                                block47: {
                                    t1RecFrame = new T1_BLOCK_FRAME();
                                    ntStatus = -994L;
                                    packetOk = true;
                                    chksumOk = true;
                                    ifdLayerInterface = new IFDLayerInterface();
                                    Smartcard.T1.WaitForReply = false;
                                    if (Smartcard.CardCapabilities.InversConvention) {
                                        SmcLib.SmartcardInvertData(Smartcard.SmartcardReply.Buffer, Smartcard.SmartcardReply.BufferLength, 0);
                                    }
                                    Smartcard.T1.Wtx = '\u0000';
                                    expectedLength = 3 + (Smartcard.SmartcardReply.Buffer.get(2) & 255) + ((Smartcard.CardCapabilities.t1.EDC & '\u0001') != 0 ? 2 : 1);
                                    if (Smartcard.SmartcardReply.BufferLength < 4L || Smartcard.SmartcardReply.BufferLength != expectedLength) {
                                        packetOk = false;
                                    } else {
                                        chksumOk = SmcLib.SmartcardT1Chksum(Smartcard.SmartcardReply.Buffer, Smartcard.CardCapabilities.t1.EDC, true, 0);
                                    }
                                    if (packetOk && chksumOk) break block47;
                                    Smartcard.T1.LastError = (char)(chksumOk != false ? 2 : 1);
                                    if (Smartcard.T1.OriginalState == 0L) {
                                        Smartcard.T1.OriginalState = Smartcard.T1.State;
                                    }
                                    v0 = Smartcard.InvalidRetryCount;
                                    Smartcard.InvalidRetryCount = (byte)(v0 + 1);
                                    if (v0 >= 2) {
                                        Smartcard.InvalidRetryCount = 0;
                                        if (Smartcard.AwaitingFirstResponse) {
                                            Smartcard.MinorIoControlCode = 0L;
                                            ntStatus = ifdLayerInterface.IFD_PowerControl(Smartcard, ReaderExtn) == 0L ? -998L : -997L;
                                        } else {
                                            Smartcard.T1.State = 192L;
                                        }
                                    } else if (192L != (192L & Smartcard.T1.State) || 0L != (32L & Smartcard.T1.State)) {
                                        Smartcard.T1.State = 3L;
                                    }
                                    break block48;
                                }
                                Smartcard.InvalidRetryCount = 0;
                                Smartcard.T1.LastError = '\u0000';
                                t1RecFrame.Nad = Smartcard.SmartcardReply.Buffer.get(0);
                                t1RecFrame.Pcb = Smartcard.SmartcardReply.Buffer.get(1);
                                t1RecFrame.Len = Smartcard.SmartcardReply.Buffer.get(2);
                                System.arraycopy(Smartcard.SmartcardReply.Buffer.array(), 3, t1RecFrame.Inf.array(), 0, t1RecFrame.Len & 255);
                                if (Smartcard.T1.State != 193L) break block49;
                                if ((t1RecFrame.Pcb & 255) == 225) {
                                    Smartcard.T1.IFSC = (char)t1RecFrame.Inf.get(0);
                                    Smartcard.T1.State = 2L;
                                } else if ((t1RecFrame.Pcb & 130) == 130) {
                                    Smartcard.T1.State = 2L;
                                } else {
                                    v1 = Smartcard.T1.Resend;
                                    Smartcard.T1.Resend = (char)(v1 + '\u0001');
                                    if (v1 == '\u0002') {
                                        Smartcard.T1.Resend = '\u0000';
                                        Smartcard.T1.State = 192L;
                                    } else {
                                        Smartcard.T1.State = 3L;
                                        ntStatus = -998L;
                                    }
                                }
                                break block48;
                            }
                            if (Smartcard.T1.State != 192L) break block50;
                            if (t1RecFrame.Pcb == 224) ** GOTO lbl-1000
                            v2 = Smartcard.ResynchRetryCount;
                            Smartcard.ResynchRetryCount = (byte)(v2 + 1);
                            if (v2 >= 2) {
                                Smartcard.ResynchRetryCount = 0;
                                Smartcard.MinorIoControlCode = 0L;
                                ntStatus = ifdLayerInterface.IFD_PowerControl(Smartcard, ReaderExtn) == 0L ? -998L : -997L;
                            } else if (t1RecFrame.Pcb != 224) {
                                Smartcard.T1.State = 192L;
                            } else {
                                Smartcard.T1.Resend = '\u0000';
                                Smartcard.T1.RSN = '\u0000';
                                Smartcard.T1.SSN = '\u0000';
                                Smartcard.AwaitingFirstResponse = false;
                                Smartcard.T1.State = 4L;
                                ntStatus = -998L;
                            }
                            break block48;
                        }
                        if ((t1RecFrame.Pcb & 128) != 0) break block51;
                        if ((t1RecFrame.Pcb & 64) >> 6 == Smartcard.T1.RSN) {
                            Smartcard.AwaitingFirstResponse = false;
                            Smartcard.T1.Resend = '\u0000';
                            Smartcard.T1.OriginalState = 0L;
                            Smartcard.T1.RSN = (char)(Smartcard.T1.RSN ^ '\u0001');
                            minBufferSize = Smartcard.T1.BytesReceived + (long)(t1RecFrame.Len & 255);
                            System.arraycopy(t1RecFrame.Inf.array(), 0, Smartcard.T1.ReplyData.array(), (int)Smartcard.T1.BytesReceived, t1RecFrame.Len & 255);
                            Smartcard.T1.BytesReceived += (long)(t1RecFrame.Len & 255);
                            if ((t1RecFrame.Pcb & 32) != 0) {
                                Smartcard.T1.State = 3L;
                                Smartcard.CardStartedChaining = true;
                            } else {
                                Smartcard.T1.SSN = (char)(Smartcard.T1.SSN ^ '\u0001');
                                Smartcard.CardStartedChaining = false;
                                if (Smartcard.iorequest.ReplyBufferLength < minBufferSize) {
                                    ntStatus = -992L;
                                } else {
                                    Smartcard.iorequest.Information = Smartcard.T1.BytesReceived;
                                    System.arraycopy(Smartcard.T1.ReplyData.array(), 0, Smartcard.iorequest.ReplyBuffer.array(), 0, (int)Smartcard.T1.BytesReceived);
                                    ntStatus = 0L;
                                }
                            }
                        } else {
                            Smartcard.T1.LastError = (char)2;
                            if (Smartcard.T1.OriginalState == 0L) {
                                Smartcard.T1.OriginalState = Smartcard.T1.State;
                            }
                            v3 = Smartcard.T1.Resend;
                            Smartcard.T1.Resend = (char)(v3 + '\u0001');
                            if (v3 == '\u0002') {
                                Smartcard.T1.Resend = '\u0000';
                                Smartcard.T1.State = 192L;
                            } else if (192L != (192L & Smartcard.T1.State) || 0L != (32L & Smartcard.T1.State)) {
                                Smartcard.T1.State = 3L;
                            }
                        }
                        break block48;
                    }
                    if ((t1RecFrame.Pcb & 192) != 128) break block52;
                    RSN = (char)((t1RecFrame.Pcb & 16) >> 4);
                    if (RSN == Smartcard.T1.SSN || !Smartcard.T1.MoreData) break block53;
                    Smartcard.T1.Resend = '\u0000';
                    Smartcard.AwaitingFirstResponse = false;
                    Smartcard.T1.BytesSent += (long)Smartcard.T1.InfBytesSent;
                    Smartcard.T1.BytesToSend -= (long)Smartcard.T1.InfBytesSent;
                    Smartcard.T1.SSN = (char)(Smartcard.T1.SSN ^ '\u0001');
                    Smartcard.T1.State = 2L;
                    break block48;
                }
                if (RSN != Smartcard.T1.SSN || 2L != Smartcard.T1.State) ** GOTO lbl-1000
                Smartcard.AwaitingFirstResponse = false;
                v4 = Smartcard.T1.Resend;
                Smartcard.T1.Resend = (char)(v4 + '\u0001');
                if (v4 < '\u0002') {
                    Smartcard.T1.State = 2L;
                } else lbl-1000:
                // 2 sources

                {
                    v5 = Smartcard.T1.Resend;
                    Smartcard.T1.Resend = (char)(v5 + '\u0001');
                    if (v5 >= '\u0002') {
                        Smartcard.T1.Resend = '\u0000';
                        if (Smartcard.T1.OriginalState == 0L) {
                            Smartcard.T1.OriginalState = Smartcard.T1.State;
                        }
                        if (Smartcard.AwaitingFirstResponse) {
                            Smartcard.MinorIoControlCode = 0L;
                            ntStatus = ifdLayerInterface.IFD_PowerControl(Smartcard, ReaderExtn) == 0L ? -998L : -997L;
                        } else {
                            Smartcard.T1.State = 192L;
                        }
                    } else if (192L != (192L & Smartcard.T1.State) || 0L != (32L & Smartcard.T1.State)) {
                        Smartcard.T1.State = 3L;
                    }
                }
                break block48;
            }
            Smartcard.AwaitingFirstResponse = false;
            switch (t1RecFrame.Pcb) {
                case -63: {
                    Smartcard.T1.IFSC = (char)Smartcard.SmartcardReply.Buffer.get(3);
                    Smartcard.T1.OriginalState = Smartcard.T1.State;
                    Smartcard.T1.State = 225L;
                    break;
                }
                case -62: {
                    Smartcard.T1.State = 226L;
                    break;
                }
                case -61: {
                    Smartcard.T1.Wtx = (char)Smartcard.SmartcardReply.Buffer.get(3);
                    Smartcard.T1.OriginalState = Smartcard.T1.State;
                    Smartcard.T1.State = 227L;
                    break;
                }
                case -28: {
                    ntStatus = -999L;
                    break;
                }
                default: {
                    ntStatus = -998L;
                }
            }
        }
        if (Smartcard.T1.State == 192L) {
            v6 = Smartcard.T1.Resynch;
            Smartcard.T1.Resynch = (char)(v6 + '\u0001');
            if (v6 == '\u0002') {
                ntStatus = -998L;
            }
        }
        if (ntStatus != -994L) {
            Smartcard.T1.State = Smartcard.T1.OriginalState == 193L ? 193L : 1L;
            if (Smartcard.T1.ReplyData != null) {
                Smartcard.T1.ReplyData = null;
            }
            Smartcard.T1.OriginalState = 0L;
            Smartcard.T1.NAD = '\u0000';
        }
        return ntStatus;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    long SmartcardT0Request(SMARTCARD_EXTENSION Smartcard) {
        SMARTCARD_REQUEST pSmartcardRequest = Smartcard.SmartcardRequest;
        long ulIoRequestDataLength = 0L;
        long ntStatus = 0L;
        if (pSmartcardRequest.BufferLength + Smartcard.iorequest.RequestBufferLength >= pSmartcardRequest.BufferSize) {
            return -1000L;
        }
        ulIoRequestDataLength = Smartcard.iorequest.RequestBufferLength;
        System.arraycopy(Smartcard.iorequest.RequestBuffer.array(), 0, pSmartcardRequest.Buffer.array(), (int)pSmartcardRequest.BufferLength, (int)ulIoRequestDataLength);
        pSmartcardRequest.BufferLength += ulIoRequestDataLength;
        if (ulIoRequestDataLength < 4L) {
            return -995L;
        }
        ByteBuffer pRequestBuffer = pSmartcardRequest.Buffer;
        if (ulIoRequestDataLength <= 5L) {
            Smartcard.T0.Lc = 0L;
            if (4L == ulIoRequestDataLength) {
                Smartcard.T0.Le = 0L;
                pSmartcardRequest.Buffer.put(4, (byte)0);
                ++pSmartcardRequest.BufferLength;
            } else {
                Smartcard.T0.Le = pRequestBuffer.get(4) != 0 ? (int)pRequestBuffer.get(4) : 256;
            }
        } else {
            Smartcard.T0.Lc = pRequestBuffer.get(4);
            Smartcard.T0.Le = 0L;
            if ((Smartcard.T0.Lc & 0xFFL) != ulIoRequestDataLength - 5L) {
                if (Smartcard.T0.Lc + 1L != ulIoRequestDataLength - 5L) return -995L;
                Smartcard.T0.Le = pRequestBuffer.get((int)(ulIoRequestDataLength - 1L));
            }
        }
        if (!Smartcard.CardCapabilities.InversConvention) return ntStatus;
        SmcLib.SmartcardInvertData(pSmartcardRequest.Buffer, pSmartcardRequest.BufferLength, 0);
        return ntStatus;
    }

    long SmartcardT0Reply(SMARTCARD_EXTENSION Smartcard) {
        SMARTCARD_REPLY pSmartcardReply = Smartcard.SmartcardReply;
        long ntStatus = 0L;
        if (Smartcard.iorequest.ReplyBufferLength < pSmartcardReply.BufferLength) {
            ntStatus = -992L;
        } else {
            if (Smartcard.CardCapabilities.InversConvention) {
                SmcLib.SmartcardInvertData(pSmartcardReply.Buffer, pSmartcardReply.BufferLength, 0);
            }
            System.arraycopy(pSmartcardReply.Buffer.array(), 0, Smartcard.iorequest.ReplyBuffer.array(), 0, (int)pSmartcardReply.BufferLength);
            Smartcard.iorequest.Information = pSmartcardReply.BufferLength;
        }
        return ntStatus;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    long SmartcardUpdateCardCapabilities(SMARTCARD_EXTENSION Smartcard) {
        long ntStatus = 0L;
        SCARD_CARD_CAPABILITIES CardCapabilities = null;
        SCARD_READER_CAPABILITIES ReaderCapabilities = null;
        int[] anATRString = null;
        int byATRLength = 0;
        int[] achTA = null;
        int[] achTB = null;
        int[] achTC = null;
        int[] achTD = null;
        int i = 0;
        int chTck = 0;
        int chTDi = 0;
        int byNumOfProtocols = 0;
        int byProtocolTypes = 0;
        long dwFs = 0L;
        boolean bTA2Present = false;
        ReaderCapabilities = Smartcard.ReaderCapabilities;
        CardCapabilities = Smartcard.CardCapabilities;
        anATRString = new int[CardCapabilities.atr.Length];
        byATRLength = CardCapabilities.atr.Length;
        if (byATRLength < 2) return -993L;
        if ((long)byATRLength > 33L) {
            return -993L;
        }
        i = 0;
        while (i < byATRLength) {
            anATRString[i] = CardCapabilities.atr.Buffer[i] & 0xFF;
            ++i;
        }
        i = 1;
        while (i < byATRLength) {
            chTck ^= anATRString[i];
            ++i;
        }
        if (63 != anATRString[0] && 59 != anATRString[0]) {
            return -993L;
        }
        CardCapabilities.protocol.Supported = 0L;
        achTA = new int[4];
        achTB = new int[4];
        achTC = new int[4];
        achTD = new int[4];
        achTA[0] = 17;
        achTB[0] = 37;
        achTC[1] = 10;
        chTDi = anATRString[1];
        CardCapabilities.chars.Length = chTDi & 0xF;
        int pointer = 1;
        int pn = 0;
        while (pointer < byATRLength) {
            if ((chTDi | 0xEF) == 255) {
                achTA[pn] = anATRString[++pointer];
                if (1 == pn) {
                    bTA2Present = true;
                }
            }
            if ((chTDi | 0xDF) == 255) {
                achTB[pn] = anATRString[++pointer];
            }
            if ((chTDi | 0xBF) == 255) {
                achTC[pn] = anATRString[++pointer];
            }
            if ((chTDi | 0x7F) != 255) break;
            chTDi = anATRString[++pointer];
            achTD[pn] = chTDi & 0xF;
            if ((1 << achTD[pn] & byProtocolTypes) == 0) {
                byNumOfProtocols = (byte)(byNumOfProtocols + 1);
            }
            byProtocolTypes = (byte)(byProtocolTypes | 1 << achTD[pn]);
            ++pn;
        }
        if ((byNumOfProtocols > 1 || ((long)byProtocolTypes & 0xFFFFFFFFFFFFFFFEL) != 0L) && chTck != 0) {
            return -993L;
        }
        CardCapabilities.Fl = (short)((achTA[0] & 0xF0) >> 4);
        CardCapabilities.Dl = (short)(achTA[0] & 0xF);
        CardCapabilities.II = (short)((achTB[1] & 0xC0) >> 6);
        CardCapabilities.P = (short)(achTB[2] != 0 ? achTB[2] : (achTB[0] & 0x1F) * 10);
        CardCapabilities.N = (short)achTC[0];
        if (0L == sBitRateAdjustment[CardCapabilities.Dl][0]) return -993L;
        if (0L == sClockRateConversion[CardCapabilities.Fl][0]) {
            return -993L;
        }
        if (CardCapabilities.PtsData.Type == '\u0000') {
            dwFs = ReaderCapabilities.frequency.Default * 1000L;
            if (0L == dwFs) {
                dwFs = 3571200L;
            }
            CardCapabilities.PtsData.Fl = 1;
            CardCapabilities.PtsData.Dl = 1;
            CardCapabilities.PtsData.DataRate = ReaderCapabilities.dataRate.Default;
            CardCapabilities.PtsData.CLKFrequency = ReaderCapabilities.frequency.Default;
            CardCapabilities.etu = 1L + 1000000L * sBitRateAdjustment[CardCapabilities.PtsData.Dl][1] * sClockRateConversion[CardCapabilities.PtsData.Fl][0] / (sBitRateAdjustment[CardCapabilities.PtsData.Dl][0] * dwFs);
        }
        if (CardCapabilities.PtsData.Type != '\u0000') {
            if ('\u0001' == CardCapabilities.PtsData.Type) {
                CardCapabilities.PtsData.Fl = CardCapabilities.Fl;
            }
            if (CardCapabilities.PtsData.Fl > 15) return -995L;
            if (0L == sClockRateConversion[CardCapabilities.PtsData.Fl][0]) {
                return -995L;
            }
            do {
                long ulCardFreq = 0L;
                if (ReaderCapabilities.frequenciesSupported.Entries == '\u0000' || ReaderCapabilities.frequenciesSupported.List == null) {
                    ReaderCapabilities.frequenciesSupported.List[0] = ReaderCapabilities.frequency.Default;
                    ReaderCapabilities.frequenciesSupported.List[1] = ReaderCapabilities.frequency.Max;
                    ReaderCapabilities.frequenciesSupported.Entries = (char)2;
                }
                ulCardFreq = sClockRateConversion[CardCapabilities.PtsData.Fl][1] / 1000L;
                CardCapabilities.PtsData.CLKFrequency = ReaderCapabilities.frequenciesSupported.List[0];
                i = 0;
                while (i < ReaderCapabilities.frequenciesSupported.Entries) {
                    if (ReaderCapabilities.frequenciesSupported.List[i] > CardCapabilities.PtsData.CLKFrequency && ReaderCapabilities.frequenciesSupported.List[i] <= ulCardFreq) {
                        CardCapabilities.PtsData.CLKFrequency = ReaderCapabilities.frequenciesSupported.List[i];
                    }
                    ++i;
                }
                dwFs = CardCapabilities.PtsData.CLKFrequency * 1000L;
                CardCapabilities.PtsData.DataRate = 0L;
                if (0L == dwFs) {
                    ntStatus = -995L;
                    break;
                }
                if ('\u0001' == CardCapabilities.PtsData.Type) {
                    CardCapabilities.PtsData.Dl = CardCapabilities.Dl;
                }
                if (CardCapabilities.PtsData.Dl > 15 || 0L == sBitRateAdjustment[CardCapabilities.PtsData.Dl][0]) {
                    ntStatus = -995L;
                    break;
                }
                if (ReaderCapabilities.dataRatesSupported.Entries == '\u0000' || ReaderCapabilities.dataRatesSupported.List == null) {
                    ReaderCapabilities.dataRatesSupported.List[0] = ReaderCapabilities.dataRate.Default;
                    ReaderCapabilities.dataRatesSupported.Entries = (char)2;
                }
                while (CardCapabilities.PtsData.Dl > 1) {
                    long ulDataRate = 0L;
                    ulDataRate = sBitRateAdjustment[CardCapabilities.PtsData.Dl][0] * dwFs / (sBitRateAdjustment[CardCapabilities.PtsData.Dl][1] * sClockRateConversion[CardCapabilities.PtsData.Fl][0]);
                    i = 0;
                    while (i < ReaderCapabilities.dataRatesSupported.Entries) {
                        if (ReaderCapabilities.dataRatesSupported.List[i] * 101L > ulDataRate * 100L && ReaderCapabilities.dataRatesSupported.List[i] * 99L < ulDataRate * 100L) {
                            CardCapabilities.PtsData.DataRate = ReaderCapabilities.dataRatesSupported.List[0];
                            break;
                        }
                        ++i;
                    }
                    if (CardCapabilities.PtsData.DataRate != 0L) break;
                    while (0L == sBitRateAdjustment[CardCapabilities.PtsData.Dl = (short)(CardCapabilities.PtsData.Dl - 1)][0]) {
                    }
                }
                if (1 == CardCapabilities.PtsData.Fl && 1 == CardCapabilities.PtsData.Dl) {
                    CardCapabilities.PtsData.DataRate = ReaderCapabilities.dataRate.Default;
                    CardCapabilities.PtsData.CLKFrequency = ReaderCapabilities.frequency.Default;
                    break;
                }
                if (CardCapabilities.PtsData.DataRate != 0L) break;
                while (CardCapabilities.PtsData.Fl > 0 && 0L == sClockRateConversion[CardCapabilities.PtsData.Fl = (short)(CardCapabilities.PtsData.Fl - 1)][0]) {
                }
            } while (0L == CardCapabilities.PtsData.DataRate);
        }
        CardCapabilities.etu = 1L + 1000000L * sBitRateAdjustment[CardCapabilities.PtsData.Dl][1] * sClockRateConversion[CardCapabilities.PtsData.Fl][0] / (sBitRateAdjustment[CardCapabilities.PtsData.Dl][0] * dwFs);
        CardCapabilities.GT = 0L;
        if (CardCapabilities.N == 0) {
            CardCapabilities.PtsData.StopBits = (char)2;
        } else if (255 == CardCapabilities.N) {
            CardCapabilities.PtsData.StopBits = '\u0001';
        } else {
            CardCapabilities.GT = (long)CardCapabilities.N * CardCapabilities.etu;
        }
        ReaderCapabilities.CurrentState = bTA2Present || byNumOfProtocols <= 1 && 1 == CardCapabilities.Fl && 1 == CardCapabilities.Dl ? 6L : 5L;
        if (achTD[0] == 0) {
            CardCapabilities.protocol.Supported |= 1L;
            CardCapabilities.t0.WI = (char)achTC[1];
            CardCapabilities.t0.WT = CardCapabilities.PtsData.Dl > 0 && CardCapabilities.PtsData.Dl < 6 ? 1L + (long)(CardCapabilities.t0.WI * 960) * CardCapabilities.etu * ((long)(CardCapabilities.PtsData.Dl - 1) << 2) : 1L + (long)(CardCapabilities.t0.WI * 960) * CardCapabilities.etu / (long)((char)(CardCapabilities.PtsData.Dl - 1) << 2);
        }
        if (((long)byProtocolTypes & 2L) != 0L) {
            i = 0;
            while (i < 4 && achTD[i] != 1) {
                ++i;
            }
            while (i < 4 && achTD[i] == 1) {
                ++i;
            }
            if (4 == achTD[i]) {
                return -993L;
            }
            CardCapabilities.protocol.Supported |= 2L;
            CardCapabilities.t1.IFSC = (char)(achTA[i] != 0 ? achTA[i] : 32);
            CardCapabilities.t1.CWI = (char)((achTB[i] & 0xF) != 0 ? achTB[i] & 0xF : 13);
            CardCapabilities.t1.BWI = (char)((achTB[i] & 0xF0) >> 4 != 0 ? (achTB[i] & 0xF0) >> 4 : 4);
            CardCapabilities.t1.EDC = (char)(achTC[i] & 1);
            CardCapabilities.t1.CWT = 1L + (long)((CardCapabilities.t1.CWI << 2) + 11) * CardCapabilities.etu;
            CardCapabilities.t1.BWT = 1L + (long)(CardCapabilities.t1.BWI << 2) * 1000000L / 10L + 11L * CardCapabilities.etu;
        }
        if (6L == ReaderCapabilities.CurrentState) {
            CardCapabilities.protocol.Selected = bTA2Present ? (long)(1 << achTA[1]) : CardCapabilities.protocol.Supported;
        }
        CardCapabilities.protocol.Supported |= 0x10000L;
        return ntStatus;
    }

    void SmartcardInitializeCardCapabilities(SMARTCARD_EXTENSION Smartcard) {
        CLOCK_RATE_CONVERSION HoldClockRateConversion = Smartcard.CardCapabilities.ClockRateConversion;
        BIT_RATE_ADJUSTMENT HoldBitRateAdjustment = Smartcard.CardCapabilities.BitRateAdjustment;
        Smartcard.CardCapabilities = new SCARD_CARD_CAPABILITIES();
        Smartcard.CardCapabilities.ClockRateConversion = HoldClockRateConversion;
        Smartcard.CardCapabilities.BitRateAdjustment = HoldBitRateAdjustment;
        Smartcard.CardCapabilities.protocol.Supported = 65536L;
        Smartcard.T1.State = 0L;
        Smartcard.T1.SSN = '\u0000';
        Smartcard.T1.RSN = '\u0000';
        Smartcard.T1.IFSD = Smartcard.ReaderCapabilities.MaxIFSD != 0L && Smartcard.ReaderCapabilities.MaxIFSD < 254L ? (char)Smartcard.ReaderCapabilities.MaxIFSD : (char)254;
    }

    long SmartcardAPDURequest(SMARTCARD_EXTENSION Smartcard, IFDLayer.IFD_PARAMS ifdParams) {
        SMARTCARD_REQUEST smartcardRequest = Smartcard.SmartcardRequest;
        if (!Smartcard.T1.MoreData && Smartcard.T1.BytesSent == 0L) {
            Smartcard.CardStartedChaining = false;
            if (Smartcard.T1.ReplyData != null) {
                Smartcard.T1.ReplyData = null;
            }
            if (Smartcard.iorequest.ReplyBufferLength < 2L) {
                return -992L;
            }
            Smartcard.T1.ReplyData = ByteBuffer.allocate(131072);
            if (Smartcard.T1.ReplyData == null) {
                return -997L;
            }
            Smartcard.T1.BytesToSend = Smartcard.iorequest.RequestBufferLength;
            Smartcard.T1.BytesSent = 0L;
            Smartcard.T1.BytesReceived = 0L;
            Smartcard.T1.InfBytesSent = (char)(IFDLayer.CCID_MAX_PKT_SIZE - 10);
        }
        if (Smartcard.T1.BytesToSend == 0L) {
            ifdParams.transmit.TransferLevel = (char)16;
            smartcardRequest.Buffer = null;
            smartcardRequest.BufferLength = 0L;
        } else {
            if (Smartcard.T1.BytesToSend > (long)Smartcard.T1.InfBytesSent) {
                Smartcard.T1.MoreData = true;
                Smartcard.T1.BytesToSend -= (long)(IFDLayer.CCID_MAX_PKT_SIZE - 10);
                smartcardRequest.BufferLength = Smartcard.T1.InfBytesSent;
            } else {
                Smartcard.T1.MoreData = false;
                smartcardRequest.BufferLength = Smartcard.T1.BytesToSend;
                Smartcard.T1.BytesToSend = 0L;
            }
            System.arraycopy(Smartcard.iorequest.RequestBuffer.array(), (int)Smartcard.T1.BytesSent, smartcardRequest.Buffer.array(), 0, (int)smartcardRequest.BufferLength);
            ifdParams.transmit.TransferLevel = Smartcard.T1.MoreData ? (Smartcard.T1.BytesToSend > (long)IFDLayer.CCID_MAX_PKT_SIZE ? (char)3 : (char)'\u0001') : (Smartcard.T1.BytesSent > 0L ? (char)2 : (char)'\u0000');
            Smartcard.T1.BytesSent += smartcardRequest.BufferLength;
        }
        return 0L;
    }

    long SmartcardAPDUReply(SMARTCARD_EXTENSION Smartcard, IFDLayer.READER_EXTENSION ReaderExtn) {
        long ntStatus = -994L;
        if (Smartcard.CardCapabilities.InversConvention) {
            SmcLib.SmartcardInvertData(Smartcard.SmartcardReply.Buffer, Smartcard.SmartcardReply.BufferLength, 0);
        }
        if (Smartcard.AwaitingFirstResponse) {
            Smartcard.AwaitingFirstResponse = false;
        } else {
            System.arraycopy(Smartcard.SmartcardReply.Buffer.array(), 0, Smartcard.T1.ReplyData.array(), (int)Smartcard.T1.BytesReceived, (int)Smartcard.SmartcardReply.BufferLength);
            Smartcard.T1.BytesReceived += Smartcard.SmartcardReply.BufferLength;
            if (!Smartcard.CardStartedChaining) {
                if (Smartcard.iorequest.ReplyBufferLength < Smartcard.T1.BytesReceived) {
                    ntStatus = -992L;
                    Smartcard.T1.BytesSent = 0L;
                } else {
                    System.arraycopy(Smartcard.T1.ReplyData.array(), 0, Smartcard.iorequest.ReplyBuffer.array(), 0, (int)Smartcard.T1.BytesReceived);
                    Smartcard.iorequest.Information = Smartcard.T1.BytesReceived;
                    Smartcard.T1.BytesSent = 0L;
                    ntStatus = 0L;
                }
            }
        }
        return ntStatus;
    }

    class BIT_RATE_ADJUSTMENT {
        final long DNumerator = 0L;
        final long DDivisor = 0L;

        BIT_RATE_ADJUSTMENT() {
        }
    }

    class CLOCK_RATE_CONVERSION {
        final long F = 0L;
        final long fs = 0L;

        CLOCK_RATE_CONVERSION() {
        }
    }

    class PTS_DATA {
        static final int PTS_TYPE_DEFAULT = 0;
        static final int PTS_TYPE_OPTIMAL = 1;
        static final int PTS_TYPE_USER = 2;
        char Type;
        short Fl;
        short Dl;
        long CLKFrequency;
        long DataRate;
        char StopBits;

        PTS_DATA() {
        }
    }

    class SCARD_CARD_CAPABILITIES {
        boolean InversConvention;
        long etu;
        ATR atr = new ATR();
        HistoricalChars chars = new HistoricalChars();
        CLOCK_RATE_CONVERSION ClockRateConversion;
        BIT_RATE_ADJUSTMENT BitRateAdjustment;
        short Fl;
        short Dl;
        short II;
        short P;
        short N;
        long GT;
        Protocol protocol;
        T0 t0;
        T1 t1;
        PTS_DATA PtsData;
        ByteBuffer Reserved;

        SCARD_CARD_CAPABILITIES() {
            this.ClockRateConversion = new CLOCK_RATE_CONVERSION();
            this.BitRateAdjustment = new BIT_RATE_ADJUSTMENT();
            this.protocol = new Protocol();
            this.t0 = new T0();
            this.t1 = new T1();
            this.PtsData = new PTS_DATA();
        }

        class ATR {
            byte[] Buffer;
            char Length;

            ATR() {
            }
        }

        class HistoricalChars {
            ByteBuffer Buffer;
            int Length;

            HistoricalChars() {
            }
        }

        class Protocol {
            long Supported;
            long Selected;

            Protocol() {
            }
        }

        class T0 {
            char WI;
            long WT;

            T0() {
            }
        }

        class T1 {
            char IFSC;
            char CWI;
            char BWI;
            char EDC;
            long CWT;
            long BWT;
            long BGT;

            T1() {
            }
        }
    }

    class SCARD_READER_CAPABILITIES {
        long SupportedProtocols;
        long Reserved;
        long ReaderMode;
        long ReaderType;
        long MechProperties;
        long CurrentState;
        long Channel;
        CLKFrequency frequency = new CLKFrequency();
        DataRate dataRate = new DataRate();
        long MaxIFSD;
        long PowerMgmtSupport;
        long CardConfiscated;
        DataRatesSupported dataRatesSupported = new DataRatesSupported();
        CLKFrequenciesSupported frequenciesSupported = new CLKFrequenciesSupported();
        ByteBuffer Reserved1;

        SCARD_READER_CAPABILITIES() {
        }

        class CLKFrequenciesSupported {
            long[] List;
            char Entries;

            CLKFrequenciesSupported() {
            }
        }

        class CLKFrequency {
            long Default;
            long Max;

            CLKFrequency() {
            }
        }

        class DataRate {
            long Default;
            long Max;

            DataRate() {
            }
        }

        class DataRatesSupported {
            long[] List;
            char Entries;

            DataRatesSupported() {
            }
        }
    }

    class SMARTCARD_EXTENSION {
        long Version;
        VENDOR_ATTR VendorAttr;
        SCARD_CARD_CAPABILITIES CardCapabilities;
        long LastError;
        IoRequest iorequest;
        long MajorIoControlCode;
        long MinorIoControlCode;
        SCARD_READER_CAPABILITIES ReaderCapabilities;
        SMARTCARD_REPLY SmartcardReply;
        SMARTCARD_REQUEST SmartcardRequest;
        T0_DATA T0;
        T1_DATA T1;
        boolean AwaitingFirstResponse;
        boolean CardStartedChaining;
        byte InvalidRetryCount;
        byte ResynchRetryCount;

        SMARTCARD_EXTENSION() {
            this.VendorAttr = new VENDOR_ATTR();
            this.CardCapabilities = new SCARD_CARD_CAPABILITIES();
            this.iorequest = new IoRequest();
            this.ReaderCapabilities = new SCARD_READER_CAPABILITIES();
            this.SmartcardReply = new SMARTCARD_REPLY();
            this.SmartcardRequest = new SMARTCARD_REQUEST();
            this.T0 = new T0_DATA();
            this.T1 = new T1_DATA();
        }

        class IoRequest {
            long Information;
            ByteBuffer RequestBuffer;
            long RequestBufferLength;
            ByteBuffer ReplyBuffer;
            long ReplyBufferLength;

            IoRequest() {
            }
        }
    }

    class SMARTCARD_REPLY {
        ByteBuffer Buffer;
        long BufferSize;
        long BufferLength;

        SMARTCARD_REPLY() {
        }
    }

    class SMARTCARD_REQUEST {
        ByteBuffer Buffer;
        long BufferSize;
        long BufferLength;

        SMARTCARD_REQUEST() {
        }
    }

    class T0_DATA {
        long Lc;
        long Le;

        T0_DATA() {
        }
    }

    class T1_BLOCK_FRAME {
        byte Nad;
        byte Pcb;
        byte Len;
        ByteBuffer Inf = ByteBuffer.allocate(255);

        T1_BLOCK_FRAME() {
        }
    }

    class T1_DATA {
        char IFSC;
        char IFSD;
        long BytesReceived;
        long BytesSent;
        long BytesToSend;
        char LastError;
        boolean MoreData;
        char NAD;
        long OriginalState;
        char Resend;
        char Resynch;
        char RSN;
        char SSN;
        long State;
        char Wtx;
        ByteBuffer ReplyData;
        boolean WaitForReply;
        char InfBytesSent;
        ByteBuffer Reserved;

        T1_DATA() {
        }
    }

    class VENDOR_ATTR {
        VendorName vendorName = new VendorName();
        IfdType ifdType = new IfdType();
        int UnitNo;
        IfdVersion ifdVersion = new IfdVersion();
        IfdSerialNo ifdSerialNo = new IfdSerialNo();
        int[] Reserved;

        VENDOR_ATTR() {
        }

        class IfdSerialNo {
            int Length;
            byte[] Buffer = new byte[32];

            IfdSerialNo() {
            }
        }

        class IfdType {
            int Length;
            byte[] Buffer = new byte[33];

            IfdType() {
            }
        }

        class IfdVersion {
            short BuildNumber;
            short VersionMinor;
            short VersionMajor;

            IfdVersion() {
            }
        }

        class VendorName {
            int Length;
            byte[] Buffer = new byte[33];

            VendorName() {
            }
        }
    }
}

