/*
 * Decompiled with CFR 0.152.
 */
package com.faraji.environment3;

import android.content.Context;
import com.faraji.environment3.Device;
import com.faraji.environment3.Environment3;
import com.faraji.environment3.Size;
import java.io.File;

class DeviceDiv
extends Device {
    private String mName;
    private boolean mAvailable;
    private boolean mWriteable;

    DeviceDiv(String path) {
        this.mMountPoint = path;
        this.updateState();
    }

    @Override
    public boolean isAvailable() {
        return this.mAvailable;
    }

    @Override
    public boolean isWriteable() {
        return this.mWriteable;
    }

    @Override
    protected void updateState() {
        File f = new File(this.mMountPoint);
        this.setName(f.getName());
        this.mAvailable = f.isDirectory() && f.canRead();
        if (this.mAvailable) {
            this.mSize = Size.getSpace(f);
            this.mWriteable = f.canWrite();
            if (this.mMountPoint.startsWith(Environment3.mPrimary.mMountPoint) && this.mSize.equals((Object)Environment3.mPrimary.mSize)) {
                this.mWriteable = false;
                this.mAvailable = false;
            }
        } else {
            this.mWriteable = false;
        }
    }

    @Override
    public String getName() {
        return this.mName;
    }

    protected final void setName(String name) {
        this.mName = name;
    }

    @Override
    public boolean isRemovable() {
        return true;
    }

    @Override
    public File getCacheDir(Context ctx) {
        return this.getFilesDirLow(ctx, "/cache");
    }

    @Override
    public File getFilesDir(Context ctx) {
        return this.getFilesDirLow(ctx, "/files");
    }

    @Override
    public File getDataDir(Context ctx) {
        return this.getFilesDirLow(ctx, "");
    }

    @Override
    public File getTempDir(Context ctx) {
        return this.getFilesDirLow(ctx, "/temp");
    }

    @Override
    public File getFilesDir(Context ctx, String s) {
        return this.getFilesDirLow(ctx, s);
    }

    @Override
    public File getPublicDirectory(String s) {
        if (s != null && !s.startsWith("/")) {
            s = "/" + s;
        }
        return new File(String.valueOf(this.getMountPoint()) + s);
    }

    @Override
    public String getState() {
        if (this.mAvailable) {
            return this.mWriteable ? "mounted" : "mounted_ro";
        }
        return "removed";
    }
}

