/*
 * Decompiled with CFR 0.152.
 */
package com.faraji.environment3;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.os.Build;
import android.os.Environment;
import com.faraji.environment3.Device;
import com.faraji.environment3.Size;
import java.io.File;

class DeviceExternal
extends Device {
    private boolean mRemovable;
    private String mState;

    @SuppressLint(value={"NewApi"})
    DeviceExternal() {
        File f = Environment.getExternalStorageDirectory();
        this.mMountPoint = f.getAbsolutePath();
        if (Build.VERSION.SDK_INT >= 9) {
            this.setRemovable(Environment.isExternalStorageRemovable());
        } else {
            this.setRemovable(true);
        }
        this.updateState();
    }

    @Override
    protected void updateState() {
        this.mState = Environment.getExternalStorageState();
        if (this.isAvailable()) {
            File f = new File(this.mMountPoint);
            this.mSize = Size.getSpace(f);
        }
    }

    @Override
    public String getName() {
        return this.mRemovable ? "External SD-Card" : "Internal SD-Card";
    }

    @Override
    public boolean isRemovable() {
        return this.mRemovable;
    }

    protected final void setRemovable(boolean remove) {
        this.mRemovable = remove;
    }

    @Override
    public boolean isAvailable() {
        return "mounted".equals(this.mState) || "mounted_ro".equals(this.mState);
    }

    @Override
    public boolean isWriteable() {
        return "mounted".equals(this.mState);
    }

    @Override
    public File getFilesDir(Context ctx) {
        return this.getFilesDir(ctx, null);
    }

    @Override
    public File getDataDir(Context ctx) {
        return this.getFilesDirLow(ctx, "");
    }

    @Override
    public File getTempDir(Context ctx) {
        return this.getFilesDirLow(ctx, "/temp");
    }

    @Override
    @TargetApi(value=8)
    public File getFilesDir(Context ctx, String s) {
        if (Build.VERSION.SDK_INT >= 8) {
            return ctx.getExternalFilesDir(s);
        }
        return this.getFilesDirLow(ctx, s);
    }

    @Override
    @TargetApi(value=8)
    public File getCacheDir(Context ctx) {
        if (Build.VERSION.SDK_INT >= 8) {
            return ctx.getExternalCacheDir();
        }
        return this.getFilesDirLow(ctx, "/cache");
    }

    @Override
    @TargetApi(value=8)
    public File getPublicDirectory(String s) {
        if (Build.VERSION.SDK_INT >= 8) {
            return Environment.getExternalStoragePublicDirectory((String)s);
        }
        if (s != null && !s.startsWith("/")) {
            s = "/" + s;
        }
        return new File(String.valueOf(this.getMountPoint()) + s);
    }

    @Override
    public String getState() {
        return this.mState;
    }
}

