/*
 * Decompiled with CFR 0.152.
 */
package com.faraji.environment3;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.res.TypedArray;
import android.os.Parcelable;
import android.preference.ListPreference;
import android.text.format.Formatter;
import android.util.AttributeSet;
import android.util.Log;
import com.faraji.environment3.Device;
import com.faraji.environment3.Environment3;

public class DevicesListPreference
extends ListPreference {
    private static final String TAG = "Device";
    private Context context;

    public DevicesListPreference(Context ctx, AttributeSet attrs) {
        super(ctx, attrs);
        this.context = ctx;
        String key = attrs.getAttributeValue(null, "devices_key");
        boolean available = attrs.getAttributeBooleanValue(null, "devices_available", true);
        boolean intern = attrs.getAttributeBooleanValue(null, "devices_intern", true);
        boolean data = attrs.getAttributeBooleanValue(null, "devices_data", false);
    }

    public void refreshEntries(String key, boolean available, boolean intern, boolean data) {
        Device[] devices = Environment3.getDevices(key, available, intern, data);
        CharSequence[] entries = new CharSequence[devices.length];
        CharSequence[] entryValues = new CharSequence[devices.length];
        int i = 0;
        while (i < devices.length) {
            entries[i] = this.createEntry(devices[i]);
            entryValues[i] = this.createEntryValue(devices[i]);
            ++i;
        }
        this.setEntries(entries);
        this.setEntryValues(entryValues);
    }

    public void refreshEntries() {
        this.refreshEntries(null, true, true, false);
    }

    protected void onDialogClosed(boolean positiveResult) {
        super.onDialogClosed(positiveResult);
        if (positiveResult) {
            this.setSummary(this.getSummary());
        }
    }

    public CharSequence getSummary() {
        int pos = this.findIndexOfValue(this.getValue());
        if (pos == -1) {
            return "Choose One";
        }
        return this.getEntries()[pos];
    }

    public static Device getDevice(Context ctx, SharedPreferences cfg, String key) {
        Device[] d;
        String n = cfg.getString(key, null);
        if (n == null) {
            if (Environment3.getPrimaryExternalStorage().isAvailable()) {
                return Environment3.getPrimaryExternalStorage();
            }
            return Environment3.getInternalStorage();
        }
        Device[] deviceArray = d = Environment3.getDevices(null, false, true, true);
        int n2 = d.length;
        int n3 = 0;
        while (n3 < n2) {
            Device i = deviceArray[n3];
            if (n.startsWith(i.getMountPoint())) {
                return i;
            }
            ++n3;
        }
        Log.i((String)TAG, (String)("didn't find mount point " + n));
        return null;
    }

    protected Object onGetDefaultValue(TypedArray a, int index) {
        String s = a.getString(index);
        if ("1".equals(s)) {
            return Environment3.getPrimaryExternalStorage().getMountPoint();
        }
        if ("2".equals(s)) {
            return Environment3.getCardDirectory().getAbsolutePath();
        }
        return Environment3.getInternalStorage().getMountPoint();
    }

    protected Parcelable onSaveInstanceState() {
        return super.onSaveInstanceState();
    }

    protected String f(long l) {
        return Formatter.formatShortFileSize((Context)this.getContext(), (long)l);
    }

    protected String createEntry(Device d) {
        return String.valueOf(d.getName()) + (d.isAvailable() ? "\n\t" + this.f(d.isRemovable() ? d.getSize().guessSize() : ((Long)d.getSize().second).longValue()) + " / " + this.f((Long)d.getSize().first) + " Free" : " (is not available)");
    }

    protected String createEntryValue(Device d) {
        return d.getMountPoint();
    }
}

