/*
 * Decompiled with CFR 0.152.
 */
package com.faraji.environment3;

import android.annotation.SuppressLint;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Build;
import android.os.Environment;
import android.text.TextUtils;
import android.util.Log;
import com.faraji.environment3.Device;
import com.faraji.environment3.DeviceDiv;
import com.faraji.environment3.DeviceExternal;
import com.faraji.environment3.DeviceIntern;
import com.faraji.environment3.NoSecondaryStorageException;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.regex.Pattern;

@SuppressLint(value={"DefaultLocale"})
public class Environment3 {
    private static final String TAG = "Environment3";
    private static final boolean DEBUG = true;
    private static final Pattern DIR_SEPORATOR = Pattern.compile("/");
    private static ArrayList<DeviceDiv> mDeviceList = null;
    private static boolean mExternalEmulated = false;
    private static Device mInternal = null;
    protected static DeviceExternal mPrimary = null;
    private static DeviceDiv mSecondary = null;
    public static final String PATH_PREFIX = "/Android/data/";

    static {
        Environment3.rescanDevices();
    }

    @SuppressLint(value={"NewApi"})
    public static void rescanDevices() {
        mDeviceList = new ArrayList(10);
        mPrimary = new DeviceExternal();
        Environment3.scan();
        mExternalEmulated = Build.VERSION.SDK_INT >= 11 ? Environment.isExternalStorageEmulated() : false;
        if (mDeviceList.size() == 0) {
            mSecondary = null;
        } else {
            mSecondary = mDeviceList.get(0);
            if (mSecondary.getName().contains("usb")) {
                mSecondary = null;
            } else {
                mSecondary.setName("External SD-Card");
                if (mPrimary.isRemovable()) {
                    Log.w((String)TAG, (String)"isExternStorageRemovable overwrite (secondary sd found) auf false");
                }
                mPrimary.setRemovable(false);
            }
        }
    }

    public static void scan() {
        String[] storage;
        HashSet<String> rv = new HashSet<String>();
        String rawExternalStorage = System.getenv("EXTERNAL_STORAGE");
        String rawSecondaryStoragesStr = System.getenv("SECONDARY_STORAGE");
        String rawExternalStorageUSBStr = System.getenv("EXTERNAL_STORAGE_USB");
        String rawEmulatedStorageTarget = System.getenv("EMULATED_STORAGE_TARGET");
        if (TextUtils.isEmpty((CharSequence)rawEmulatedStorageTarget)) {
            if (TextUtils.isEmpty((CharSequence)rawExternalStorage)) {
                rv.add("/storage/sdcard0");
            } else {
                rv.add(rawExternalStorage);
            }
        } else {
            String rawUserId;
            if (Build.VERSION.SDK_INT < 17) {
                rawUserId = "";
            } else {
                String path = Environment.getExternalStorageDirectory().getAbsolutePath();
                String[] folders = DIR_SEPORATOR.split(path);
                String lastFolder = folders[folders.length - 1];
                boolean isDigit = false;
                try {
                    Integer.valueOf(lastFolder);
                    isDigit = true;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                String string = rawUserId = isDigit ? lastFolder : "";
            }
            if (TextUtils.isEmpty((CharSequence)rawUserId)) {
                rv.add(rawEmulatedStorageTarget);
            } else {
                rv.add(String.valueOf(rawEmulatedStorageTarget) + File.separator + rawUserId);
            }
        }
        if (!TextUtils.isEmpty((CharSequence)rawSecondaryStoragesStr)) {
            String[] rawSecondaryStorages = rawSecondaryStoragesStr.split(File.pathSeparator);
            Collections.addAll(rv, rawSecondaryStorages);
        }
        if (!TextUtils.isEmpty((CharSequence)rawExternalStorageUSBStr)) {
            String[] rawExternalStorageUSBStrs = rawExternalStorageUSBStr.split(File.pathSeparator);
            Collections.addAll(rv, rawExternalStorageUSBStrs);
        }
        String[] stringArray = storage = rv.toArray(new String[rv.size()]);
        int n = storage.length;
        int n2 = 0;
        while (n2 < n) {
            String st = stringArray[n2];
            if (!mPrimary.equals(st)) {
                DeviceDiv deviceDiv = new DeviceDiv(st);
                mDeviceList.add(deviceDiv);
            }
            ++n2;
        }
    }

    public static boolean isSecondaryExternalStorageAvailable() {
        return mSecondary != null && mSecondary.isAvailable();
    }

    public static final boolean isSecondaryExternalStorageRemovable() throws NoSecondaryStorageException {
        if (mSecondary == null) {
            throw new NoSecondaryStorageException();
        }
        return true;
    }

    public static File getSecondaryExternalStorageDirectory() throws NoSecondaryStorageException {
        if (mSecondary == null) {
            throw new NoSecondaryStorageException();
        }
        return mSecondary.getFile();
    }

    public static String getSecondaryExternalStorageState() throws NoSecondaryStorageException {
        if (mSecondary == null) {
            throw new NoSecondaryStorageException();
        }
        return mSecondary.getState();
    }

    public static File getSecondaryExternalStoragePublicDirectory(String s) throws NoSecondaryStorageException {
        if (mSecondary == null) {
            throw new NoSecondaryStorageException();
        }
        if (s == null) {
            throw new IllegalArgumentException("s darf nicht null sein");
        }
        return mSecondary.getPublicDirectory(s);
    }

    public static File getSecondaryExternalFilesDir(Context context, String s) throws NoSecondaryStorageException {
        if (mSecondary == null) {
            throw new NoSecondaryStorageException();
        }
        if (context == null) {
            throw new IllegalArgumentException("context darf nicht null sein");
        }
        return mSecondary.getFilesDir(context, s);
    }

    public static File getSecondaryExternalCacheDir(Context context) throws NoSecondaryStorageException {
        if (mSecondary == null) {
            throw new NoSecondaryStorageException();
        }
        if (context == null) {
            throw new IllegalArgumentException("context darf nicht null sein");
        }
        return mSecondary.getCacheDir(context);
    }

    public static File getCardDirectory() {
        if (Environment3.isSecondaryExternalStorageAvailable()) {
            try {
                return Environment3.getSecondaryExternalStorageDirectory();
            }
            catch (NoSecondaryStorageException e) {
                throw new RuntimeException("NoSecondaryException trotz Available");
            }
        }
        return Environment.getExternalStorageDirectory();
    }

    public static File getCardPublicDirectory(String dir) {
        if (Environment3.isSecondaryExternalStorageAvailable()) {
            try {
                return Environment3.getSecondaryExternalStoragePublicDirectory(dir);
            }
            catch (NoSecondaryStorageException e) {
                throw new RuntimeException("NoSecondaryException trotz Available");
            }
        }
        return mPrimary.getPublicDirectory(dir);
    }

    public static String getCardState() {
        if (Environment3.isSecondaryExternalStorageAvailable()) {
            try {
                return Environment3.getSecondaryExternalStorageState();
            }
            catch (NoSecondaryStorageException e) {
                throw new RuntimeException("NoSecondaryException trotz Available");
            }
        }
        return Environment.getExternalStorageState();
    }

    public static File getCardCacheDir(Context ctx) {
        if (Environment3.isSecondaryExternalStorageAvailable()) {
            try {
                return Environment3.getSecondaryExternalCacheDir(ctx);
            }
            catch (NoSecondaryStorageException e) {
                throw new RuntimeException("NoSecondaryException trotz Available");
            }
        }
        return mPrimary.getCacheDir(ctx);
    }

    public static File getCardFilesDir(Context ctx, String dir) {
        if (Environment3.isSecondaryExternalStorageAvailable()) {
            try {
                return Environment3.getSecondaryExternalFilesDir(ctx, dir);
            }
            catch (NoSecondaryStorageException e) {
                throw new RuntimeException("NoSecondaryException trotz Available");
            }
        }
        return mPrimary.getFilesDir(ctx, dir);
    }

    public static boolean isExternalStorageEmulated() {
        return mExternalEmulated;
    }

    public static boolean isExternalStorageRemovable() {
        return mPrimary.isRemovable();
    }

    public static IntentFilter getRescanIntentFilter() {
        if (mDeviceList == null) {
            Environment3.rescanDevices();
        }
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.intent.action.MEDIA_BAD_REMOVAL");
        filter.addAction("android.intent.action.MEDIA_MOUNTED");
        filter.addAction("android.intent.action.MEDIA_REMOVED");
        filter.addAction("android.intent.action.MEDIA_SHARED");
        filter.addDataScheme("file");
        return filter;
    }

    public static BroadcastReceiver registerRescanBroadcastReceiver(Context context, final Runnable r) {
        if (mDeviceList == null) {
            Environment3.rescanDevices();
        }
        BroadcastReceiver br = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                Log.i((String)Environment3.TAG, (String)("Storage: " + intent.getAction() + "-" + intent.getData()));
                Environment3.updateDevices();
                if (r != null) {
                    r.run();
                }
            }
        };
        context.registerReceiver(br, Environment3.getRescanIntentFilter());
        return br;
    }

    public static BroadcastReceiver registerRescanBroadcastReceiver(Context context, final BroadcastReceiver r) {
        if (mDeviceList == null) {
            Environment3.rescanDevices();
        }
        BroadcastReceiver br = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                Log.i((String)Environment3.TAG, (String)("Storage: " + intent.getAction() + "-" + intent.getData()));
                Environment3.updateDevices();
                if (r != null) {
                    r.onReceive(context, intent);
                }
            }
        };
        context.registerReceiver(br, Environment3.getRescanIntentFilter());
        return br;
    }

    public static void updateDevices() {
        for (Device device : mDeviceList) {
            device.updateState();
        }
        mPrimary.updateState();
    }

    public static Device[] getDevices(String key, boolean available, boolean intern, boolean data) {
        if (key != null) {
            key = key.toLowerCase();
        }
        ArrayList<Device> temp = new ArrayList<Device>(mDeviceList.size() + 2);
        if (data) {
            temp.add(Environment3.getInternalStorage());
        }
        if (intern && (!available || mPrimary.isAvailable())) {
            temp.add(mPrimary);
        }
        for (Device device : mDeviceList) {
            if (key != null && !device.getName().toLowerCase().contains(key) || available && !device.isAvailable()) continue;
            temp.add(device);
        }
        return temp.toArray(new Device[temp.size()]);
    }

    public static Device getPrimaryExternalStorage() {
        return mPrimary;
    }

    public static Device getSecondaryExternalStorage() throws NoSecondaryStorageException {
        if (mSecondary == null) {
            throw new NoSecondaryStorageException();
        }
        return mSecondary;
    }

    public static Device getInternalStorage() {
        if (mInternal == null) {
            mInternal = new DeviceIntern();
        }
        return mInternal;
    }
}

