/*
 * Decompiled with CFR 0.152.
 */
package com.amarula.barcodescanner.sdk;

import android.content.ContentResolver;
import android.content.ContentValues;
import android.database.Cursor;
import android.net.Uri;
import android.provider.BaseColumns;
import android.util.Log;

public class BarcodeScannerSymbologyTable
implements BaseColumns {
    private static final String TAG = "BarcodeScannerSymbologyTable";
    public static final String AUTHORITY = "com.amarula.barcodescanner.db";
    public static final String SCHEMA = "content://";
    public static final String TABLE_NAME = "symbologies";
    public static final Uri CONTENT_URI = Uri.parse((String)"content://com.amarula.barcodescanner.db/symbologies");
    public static final String KEY_LABEL = "label";
    public static final String KEY_HW_LABEL = "hw_label";
    public static final String KEY_ENABLED = "enabled";
    public static final String KEY_CHANGED = "changed";
    public static final String KEY_MIN_LENGTH = "min_length";
    public static final String KEY_MAX_LENGTH = "max_length";
    public static final String KEY_FLAGS = "flags";
    private static String[] ALL_COLUMNS = new String[]{"_id", "label", "hw_label", "enabled", "changed", "min_length", "max_length", "flags"};
    private static final String DEFAULT_SORT_ORDER = "label ASC";

    public static Cursor getAllSymbols(ContentResolver cr) {
        Cursor currentData = cr.query(CONTENT_URI, ALL_COLUMNS, null, null, DEFAULT_SORT_ORDER);
        if (currentData == null) {
            Log.e((String)TAG, (String)"Query returned null cursor!");
        }
        return currentData;
    }

    public static void setSymbolEnabled(ContentResolver cr, String hwLabel, boolean en) {
        ContentValues val = new ContentValues();
        val.put(KEY_ENABLED, Integer.valueOf(en ? 1 : 0));
        val.put(KEY_CHANGED, Integer.valueOf(1));
        cr.update(CONTENT_URI, val, "hw_label = ?", new String[]{hwLabel});
        cr.notifyChange(CONTENT_URI, null);
    }

    public static void disableAllSymbols(ContentResolver cr) {
        ContentValues val = new ContentValues();
        val.put(KEY_ENABLED, Integer.valueOf(0));
        val.put(KEY_CHANGED, Integer.valueOf(1));
        cr.update(CONTENT_URI, val, null, null);
        cr.notifyChange(CONTENT_URI, null);
    }

    public static void setSymbolMinMaxLength(ContentResolver cr, String hwLabel, int min, int max) {
        ContentValues val = new ContentValues();
        val.put(KEY_MIN_LENGTH, Integer.valueOf(min));
        val.put(KEY_MAX_LENGTH, Integer.valueOf(max));
        val.put(KEY_CHANGED, Integer.valueOf(1));
        cr.update(CONTENT_URI, val, "hw_label = ?", new String[]{hwLabel});
        cr.notifyChange(CONTENT_URI, null);
    }

    public static void setSymbolFlags(ContentResolver cr, String hwLabel, int flags) {
        ContentValues val = new ContentValues();
        val.put(KEY_HW_LABEL, hwLabel);
        val.put(KEY_FLAGS, Integer.valueOf(flags));
        val.put(KEY_CHANGED, Integer.valueOf(1));
        cr.update(CONTENT_URI, val, "hw_label = ?", new String[]{hwLabel});
        cr.notifyChange(CONTENT_URI, null);
    }

    public final class FlagsSDL {
        public static final int SDL_FLAG_NONE = -1;
        public static final int SDL_CHK_DIG_TX_OFFSET = 16;
        public static final int SDL_CHK_DIG_TX_DIS = 0;
        public static final int SDL_CHK_DIG_TX_EN = 1;
        public static final int SDL_CHK_DIG_TX_INVALID = 15;
        public static final int SDL_SET_CHK_DIG_EN = 65536;
        public static final int SDL_SET_CHK_DIG_DIS = 0;
        public static final int SDL_SET_CHK_DIG_INVALID = 983040;
        public static final int SDL_CHK_DGT_OFFSET = 0;
        public static final int SDL_CODE39_CHK_DGT_VERI_DIS = 0;
        public static final int SDL_CODE39_CHK_DGT_VERI_EN = 1;
        public static final int SDL_CODE39_FULL_ASCII_OFFSET = 4;
        public static final int SDL_CODE39_FULL_ASCII_DIS = 0;
        public static final int SDL_CODE39_FULL_ASCII_EN = 1;
        public static final int SDL_CODE39_CONVERT_32_OFFSET = 8;
        public static final int SDL_CODE39_CONVERT_32_DIS = 0;
        public static final int SDL_CODE39_CONVERT_32_EN = 1;
        public static final int SDL_CODE39_DEFAULT_FLAG = 0;
        public static final int SDL_MSI_CHK_DGT_TYPE_ONE = 0;
        public static final int SDL_MSI_CHK_DGT_TYPE_TWO = 1;
        public static final int SDL_MSI_CHK_DGT_ALGO_OFFSET = 4;
        public static final int SDL_MSI_CHK_DGT_ALGO_MODE10_10 = 1;
        public static final int SDL_MSI_CHK_DGT_ALGO_MODE10_11 = 0;
        public static final int SDL_MSI_DEFAULT_FLAG = 16;
        public static final int SDL_CODE11_CHK_DGT_VERY_DIS = 0;
        public static final int SDL_CODE11_CHK_DGT_VERY_1CD = 1;
        public static final int SDL_CODE11_CHK_DGT_VERY_2CD = 2;
        public static final int SDL_CODE11_DEFAULT_FLAG = 0;
        public static final int SDL_I25_CHK_DIG_DISABLE = 0;
        public static final int SDL_I25_CHK_DIG_USS = 1;
        public static final int SDL_I25_CHK_DIG_OPCC = 2;
        public static final int SDL_I25_CONVERT_OFFSET = 4;
        public static final int SDL_I25_CONVERT_EAN13_EN = 1;
        public static final int SDL_I25_CONVERT_EAN13_DIS = 0;
        public static final int SDL_I25_SECURITY_OFFSET = 8;
        public static final int SDL_I25_SECURITY_LEVEL0 = 0;
        public static final int SDL_I25_SECURITY_LEVEL1 = 1;
        public static final int SDL_I25_SECURITY_LEVEL2 = 2;
        public static final int SDL_I25_SECURITY_LEVEL3 = 3;
        public static final int SDL_I25_DEFAULT_FLAG = 256;
        public static final int SDL_ISBT_CONCATE_OFFSET = 0;
        public static final int SDL_ISBT_CONCATE_DIS = 0;
        public static final int SDL_ISBT_CONCATE_EN = 1;
        public static final int SDL_ISBT_CONCATE_AUTODISC = 2;
        public static final int SDL_ISBT_TABLE_OFFSET = 4;
        public static final int SDL_ISBT_TABLE_DIS = 0;
        public static final int SDL_ISBT_TABLE_EN = 1;
        public static final int SDL_ISBT_DEFAULT_FLAG = 983056;
        public static final int SDL_MATRIX_25_CHK_DGT_DIS = 0;
        public static final int SDL_MATRIX_25_CHK_DGT_EN = 1;
        public static final int SDL_MATRIX_25_REDUNDANCY_OFFSET = 4;
        public static final int SDL_MATRIX_25_REDUNDANCY_DIS = 0;
        public static final int SDL_MATRIX_25_REDUNDANCY_EN = 1;
        public static final int SDL_MATRIX_25_DEFAULT_FLAG = 0;
        public static final int SDL_AUS_POST_FMT_OFFSET = 0;
        public static final int SDL_AUS_POST_FMT_AUTODISC = 0;
        public static final int SDL_AUS_POST_FMT_ROW = 1;
        public static final int SDL_AUS_POST_FMT_ALPHANUMERIC = 2;
        public static final int SDL_AUS_POST_FMT_NUMERIC = 3;
        public static final int SDL_AUS_POST_DEFAULT_FLAG = 983040;
        public static final int SDL_INVERSE_OFFSET = 0;
        public static final int SDL_INVERSE_REGULAR = 0;
        public static final int SDL_INVERSE_INVERSE = 1;
        public static final int SDL_INVERSE_AUTO = 2;
        public static final int SDL_DATA_MATRIX_MIRROR_OFFSET = 4;
        public static final int SDL_DATA_MATRIX_MIRROR_NEVER = 0;
        public static final int SDL_DATA_MATRIX_MIRROR_ALWAYS = 1;
        public static final int SDL_DATA_MATRIX_MIRROR_AUTO = 2;
        public static final int SDL_DATA_MATRIX_DEFAULT_FLAG = 983040;
        public static final int SDL_QR_DEFAULT_FLAG = 983040;
        public static final int SDL_AZTEC_DEFAULT_FLAG = 983040;
        public static final int SDL_HAN_XIN_DEFAULT_FLAG = 983040;
        public static final int SDL_BOOKLAND_ISBN_FORMAT_OFFSET = 0;
        public static final int SDL_BOOKLAND_ISBN_FORMAT_10 = 0;
        public static final int SDL_BOOKLAND_ISBN_FORMAT_13 = 1;
        public static final int SDL_BOOKLAND_ISBN_DEFAULT_FLAG = 983040;
        public static final int SDL_CODE32_PREFIX_OFFSET = 0;
        public static final int SDL_CODE32_PREFIX_DIS = 0;
        public static final int SDL_CODE32_PREFIX_EN = 1;
        public static final int SDL_CODE32_DEFAULT_FLAG = 983040;
    }

    public final class HwLabelSDL {
        public static final String SDL_CODE_39 = "0x01";
        public static final String SDL_CODABAR = "0x02";
        public static final String SDL_CODE_128 = "0x03";
        public static final String SDL_DISCRETE_2_OF_5 = "0x04";
        public static final String SDL_INTERLEAVED_2_OF_5 = "0x06";
        public static final String SDL_CODE_93 = "0x07";
        public static final String SDL_UPC_A = "0x08";
        public static final String SDL_UPC_E = "0x09";
        public static final String SDL_EAN_8 = "0x0A";
        public static final String SDL_EAN_13 = "0x0B";
        public static final String SDL_CODE_11 = "0x0C";
        public static final String SDL_MSI = "0x0E";
        public static final String SDL_EAN_128 = "0x0F";
        public static final String SDL_UPC_E1 = "0x10";
        public static final String SDL_PDF_417 = "0x11";
        public static final String SDL_CODE39_FULL_ASCII = "0x13";
        public static final String SDL_CODE39_TRIOPTIC = "0x15";
        public static final String SDL_BOOKLAND_EAN = "0x16";
        public static final String SDL_ISBT_128 = "0x19";
        public static final String SDL_MICRO_PDF = "0x1A";
        public static final String SDL_DATA_MATRIX = "0x1B";
        public static final String SDL_QR_CODE = "0x1C";
        public static final String SDL_US_POSTNET = "0x1E";
        public static final String SDL_US_PLANET = "0x1F";
        public static final String SDL_CODE_32 = "0x1F";
        public static final String SDL_JAPAN_POSTAL = "0x22";
        public static final String SDL_AUSTRALIA_POSTAL = "0x23";
        public static final String SDL_DUTCH_POSTAL = "0x24";
        public static final String SDL_MAXICODE = "0x25";
        public static final String SDL_UK_POSTAL = "0x27";
        public static final String SDL_MICRO_QR = "0x2C";
        public static final String SDL_AZTEC = "0x2D";
        public static final String SDL_GS1_DATABAR_14 = "0x30";
        public static final String SDL_GS1_DATABAR_LIMITED = "0x31";
        public static final String SDL_GS1_DATABAR_EXPANDED = "0x32";
        public static final String SDL_USPS_4CB = "0x34";
        public static final String SDL_UPU_4STATE = "0x35";
        public static final String SDL_ISSN_EAN = "0x36";
        public static final String SDL_MATRIX_2_OF_5 = "0x39";
        public static final String SDL_CHINESE_2_OF_5 = "0x72";
        public static final String SDL_KOREAN_3_OF_5 = "0x73";
        public static final String SDL_HAN_XIN = "0xB7";
    }

    public final class OffsetsSE965 {
        public static final int SE965_CHK_DIG = 0;
        public static final int SE965_CHK_DIG_TX = 2;
        public static final int SE965_MSI_CHK_ALGO = 3;
        public static final int SE965_ISBT128_CHK_TABLE = 4;
        public static final int SE965_CONCAT_SUPP = 5;
        public static final int SE965_CONCAT_SUPP_REDUNDANCY = 9;
        public static final int SE965_ISBN_FORMAT = 14;
    }

    public final class HwLabelSE965 {
        public static final String SE965_UPCA = "0x08";
        public static final String SE965_UPCA_2 = "0x48";
        public static final String SE965_UPCA_5 = "0x88";
        public static final String SE965_UPCE = "0x09";
        public static final String SE965_UPCE_2 = "0x49";
        public static final String SE965_UPCE_5 = "0x89";
        public static final String SE965_EAN8 = "0x0A";
        public static final String SE965_EAN8_2 = "0x4A";
        public static final String SE965_EAN8_5 = "0x8A";
        public static final String SE965_EAN13 = "0x0B";
        public static final String SE965_EAN13_2 = "0x4B";
        public static final String SE965_EAN13_5 = "0x8B";
        public static final String SE965_UPCE1 = "0x10";
        public static final String SE965_UPCE1_2 = "0x50";
        public static final String SE965_UPCE1_5 = "0x90";
        public static final String SE965_CCA = "0x2F";
        public static final String SE965_CCB = "0x37";
        public static final String SE965_BOOKLAND = "0x16";
        public static final String SE965_COUPON = "0x17";
        public static final String SE965_ISSN = "0x36";
        public static final String SE965_CODE128 = "0x03";
        public static final String SE965_EAN128 = "0x0F";
        public static final String SE965_CODE39 = "0x01";
        public static final String SE965_TRIOPTIC = "0x15";
        public static final String SE965_CODE39ASCII = "0x13";
        public static final String SE965_CODE32 = "0x20";
        public static final String SE965_CODE93 = "0x07";
        public static final String SE965_CODE11 = "0x0C";
        public static final String SE965_INT25 = "0x05";
        public static final String SE965_ITF = "0x06";
        public static final String SE965_D25 = "0x04";
        public static final String SE965_MATRIX25 = "0x39";
        public static final String SE965_KOREAN25 = "0x73";
        public static final String SE965_CODABAR = "0x02";
        public static final String SE965_MSI = "0x0E";
        public static final String SE965_GS1DATABAR = "0x32";
        public static final String SE965_ISBT128 = "0x19";
        public static final String SE965_ISBT128CON = "0x21";
        public static final String SE965_CHINESE25 = "0xFE";
        public static final String SE965_UPCEAN_SUPPL = "0xFF";
    }

    public final class FlagsN431x {
        public static final int N431X_CHECK_DISABLE = 0;
        public static final int N431X_CHECK_ENABLE = 1;
        public static final int N431X_CHECK_ENABLE_TX = 2;
        public static final int N431X_CODABAR_VALID_MOD16 = 1;
        public static final int N431X_CODABAR_VALID_MOD16_TX = 2;
        public static final int N431X_CODABAR_VALID_MOD7 = 3;
        public static final int N431X_CODABAR_VALID_MOD7_TX = 4;
        public static final int N431X_CODABAR_VALID_CLSI = 5;
        public static final int N431X_CODABAR_VALID_CLSI_TX = 6;
        public static final int N431X_MSI_VALID_TYPE10 = 1;
        public static final int N431X_MSI_VALID_TYPE10_TX = 2;
        public static final int N431X_MSI_VALID_2TYPE10 = 3;
        public static final int N431X_MSI_VALID_2TYPE10_TX = 4;
        public static final int N431X_CODE11_1CKDIGIT_REQ = 0;
        public static final int N431X_CODE11_2CKDIGIT_REQ = 1;
        public static final int N431X_CODE11_CKDIGIT_AUTO = 2;
    }

    public final class HwLabelN431x {
        public static final String N431X_CODABAR = "a";
        public static final String N431X_CODE11 = "h";
        public static final String N431X_CODE128 = "j";
        public static final String N431X_CODE32 = "<";
        public static final String N431X_CODE39 = "b";
        public static final String N431X_CODE93 = "i";
        public static final String N431X_EAN13 = "d";
        public static final String N431X_EAN8 = "D";
        public static final String N431X_GS1DATABAR = "y";
        public static final String N431X_GS1DATABAR_LIMITED = "{";
        public static final String N431X_GS1DATABAR_EXPANDED = "}";
        public static final String N431X_GS1128 = "I";
        public static final String N431X_CHINAPOST = "Q";
        public static final String N431X_INTERLEAVED2OF5 = "e";
        public static final String N431X_MATRIX1OF5 = "m";
        public static final String N431X_NEC2OF5 = "Y";
        public static final String N431X_STRAIGHT2OF5 = "f";
        public static final String N431X_MSI = "g";
        public static final String N431X_TELEPHEN = "t";
        public static final String N431X_UPCA = "c";
        public static final String N431X_UPCE = "E";
        public static final String N431X_AUSTRALIAN_POST = "A";
        public static final String N431X_BRITISH_POST = "B";
        public static final String N431X_CANADIAN_POST = "C";
        public static final String N431X_CHINA_POST = "Q";
        public static final String N431X_INFOMAIL = ",";
        public static final String N431X_INTELLIGENTMAIL = "M";
        public static final String N431X_JAPANESE_POST = "J";
        public static final String N431X_KIX = "K";
        public static final String N431X_KOREA_POST = "?";
        public static final String N431X_PLANET_CODE = "L";
        public static final String N431X_POSTAL4I = "N";
        public static final String N431X_POSTNET = "P";
    }

    public final class FlagsHsm {
        public static final int HSM_CHECK_ENABLE = 2;
        public static final int HSM_CHECK_TRANSMIT = 4;
        public static final int HSM_START_STOP_XMIT = 8;
        public static final int HSM_ENABLE_APPEND_MODE = 16;
        public static final int HSM_ENABLE_FULLASCII = 32;
        public static final int HSM_NUM_SYS_TRANSMIT = 64;
        public static final int HSM_2_DIGIT_ADDENDA = 128;
        public static final int HSM_5_DIGIT_ADDENDA = 256;
        public static final int HSM_ADDENDA_REQUIRED = 512;
        public static final int HSM_ADDENDA_SEPARATOR = 1024;
        public static final int HSM_EXPANDED_UPCE = 2048;
        public static final int HSM_UPCE1_ENABLE = 4096;
        public static final int HSM_COMPOSITE_UPC = 8192;
        public static final int HSM_AUSTRALIAN_BAR_WIDTH = 65536;
        public static final int HSM_128_APPEND = 524288;
        public static final int HSM_RSE_ENABLE = 0x800000;
        public static final int HSM_RSL_ENABLE = 0x1000000;
        public static final int HSM_RSS_ENABLE = 0x2000000;
        public static final int HSM_RSX_ENABLE_MASK = 0x3800000;
        public static final int HSM_TELEPEN_OLD_STYLE = 0x4000000;
        public static final int HSM_POSICODE_LIMITED_1 = 0x8000000;
        public static final int HSM_POSICODE_LIMITED_2 = 0x10000000;
        public static final int HSM_CODABAR_CONCATENATE = 0x20000000;
    }

    public final class HwLabelHsm {
        public static final String HSM_AZTEC = "z";
        public static final String HSM_CODABAR = "a";
        public static final String HSM_CODE11 = "h";
        public static final String HSM_CODE128 = "j";
        public static final String HSM_CODE39 = "b";
        public static final String HSM_CODE49 = "l";
        public static final String HSM_CODE93 = "i";
        public static final String HSM_DATAMATRIX = "w";
        public static final String HSM_EAN8 = "D";
        public static final String HSM_EAN13 = "d";
        public static final String HSM_EAN128 = "I";
        public static final String HSM_INTERLEAVED2OF5 = "e";
        public static final String HSM_MAXICODE = "x";
        public static final String HSM_MICROPDF = "R";
        public static final String HSM_PDF417 = "r";
        public static final String HSM_POSTNET = "P";
        public static final String HSM_OCR = "O";
        public static final String HSM_QR = "s";
        public static final String HSM_GS1DATABAR = "y";
        public static final String HSM_UPCA = "c";
        public static final String HSM_UPCE = "E";
        public static final String HSM_BRITISH_POST = "B";
        public static final String HSM_CANADIAN_POST = "C";
        public static final String HSM_AUSTRALIAN_POST = "A";
        public static final String HSM_IATA25 = "f";
        public static final String HSM_CODABLOCK = "q";
        public static final String HSM_JAPANESE_POST = "J";
        public static final String HSM_PLANET_CODE = "L";
        public static final String HSM_DUTCH_POST = "K";
        public static final String HSM_MSI = "g";
        public static final String HSM_TLC39 = "T";
        public static final String HSM_TRIOPTIC = "=";
        public static final String HSM_CODE32 = "<";
        public static final String HSM_STRAIGHT2OF5 = "f";
        public static final String HSM_MATRIX2OF5 = "m";
        public static final String HSM_PLESSEY = "n";
        public static final String HSM_CHINA_POST = "Q";
        public static final String HSM_KOREA_POST = "?";
        public static final String HSM_TELEPHEN = "t";
        public static final String HSM_CODE16K = "o";
        public static final String HSM_POSICODE = "W";
        public static final String HSM_COUPON = "c";
        public static final String HSM_USPS4CB = "M";
        public static final String HSM_IDTAG = "N";
        public static final String HSM_LABELIV = ">";
        public static final String HSM_LABELV = ",";
        public static final String HSM_GS1_128 = "I";
        public static final String HSM_HANXIN = "H";
        public static final String HSM_GRIDMATRIX = "x";
    }
}

