/*
 * Decompiled with CFR 0.152.
 */
package com.amarula.gen2wave.sdk.scanner1d;

import android.util.Log;
import com.amarula.gen2wave.sdk.util.SerialPort;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

public class ScannerPort
extends SerialPort {
    private static final String TAG = "ScannerPort";
    private static final String SCANNER_EN_PATH = "/sys/devices/platform/rp-pm/scan_en/value";
    private static final String SCANNER_TTY_PATH = "/dev/ttyS3";

    public ScannerPort() throws IOException {
        ScannerPort.setScannerEnabled(true);
        this.mFd = this.open(SCANNER_TTY_PATH, 9600, false);
        if (this.mFd < 0) {
            throw new IOException("Error " + this.mFd + " opening " + SCANNER_TTY_PATH);
        }
    }

    @Override
    public int close() {
        ScannerPort.setScannerEnabled(false);
        return super.close();
    }

    public static boolean setScannerEnabled(boolean enabled) {
        File f = new File(SCANNER_EN_PATH);
        if (!f.exists() || !f.canWrite()) {
            throw new SecurityException("This application cannot open :/sys/devices/platform/rp-pm/scan_en/value");
        }
        String s = enabled ? "1" : "0";
        s = s + "\n";
        try {
            FileWriter fw = new FileWriter(f);
            fw.write(s);
            fw.flush();
            fw.close();
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)"Cannot modify Scanner state");
            e.printStackTrace();
            return false;
        }
        return true;
    }
}

