/*
 * Decompiled with CFR 0.152.
 */
package com.hoho.android.usbserial.driver;

import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbEndpoint;
import android.hardware.usb.UsbInterface;
import android.util.Log;
import com.hoho.android.usbserial.driver.UsbSerialDriver;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public class CdcAcmSerialDriver
extends UsbSerialDriver {
    private final String TAG = CdcAcmSerialDriver.class.getSimpleName();
    private UsbInterface mControlInterface;
    private UsbInterface mDataInterface;
    private UsbEndpoint mControlEndpoint;
    private UsbEndpoint mReadEndpoint;
    private UsbEndpoint mWriteEndpoint;
    private static final int USB_RECIP_INTERFACE = 1;
    private static final int USB_RT_ACM = 33;
    private static final int SET_LINE_CODING = 32;

    public CdcAcmSerialDriver(UsbDevice device, UsbDeviceConnection connection) {
        super(device, connection);
    }

    @Override
    public void open() throws IOException {
        Log.d((String)this.TAG, (String)("claiming interfaces, count=" + this.mDevice.getInterfaceCount()));
        Log.d((String)this.TAG, (String)"Claiming control interface.");
        this.mControlInterface = this.mDevice.getInterface(0);
        Log.d((String)this.TAG, (String)("Control iface=" + this.mControlInterface));
        if (!this.mConnection.claimInterface(this.mControlInterface, true)) {
            throw new IOException("Could not claim control interface.");
        }
        this.mControlEndpoint = this.mControlInterface.getEndpoint(0);
        Log.d((String)this.TAG, (String)("Control endpoint direction: " + this.mControlEndpoint.getDirection()));
        Log.d((String)this.TAG, (String)"Claiming data interface.");
        this.mDataInterface = this.mDevice.getInterface(1);
        Log.d((String)this.TAG, (String)("data iface=" + this.mDataInterface));
        if (!this.mConnection.claimInterface(this.mDataInterface, true)) {
            throw new IOException("Could not claim data interface.");
        }
        this.mReadEndpoint = this.mDataInterface.getEndpoint(1);
        Log.d((String)this.TAG, (String)("Read endpoint direction: " + this.mReadEndpoint.getDirection()));
        this.mWriteEndpoint = this.mDataInterface.getEndpoint(0);
        Log.d((String)this.TAG, (String)("Write endpoint direction: " + this.mWriteEndpoint.getDirection()));
        Log.d((String)this.TAG, (String)"Setting line coding");
        this.setBaudRate(115200);
    }

    private int sendAcmControlMessage(int request, int value, byte[] buf) {
        return this.mConnection.controlTransfer(33, request, value, 0, buf, buf != null ? buf.length : 0, 5000);
    }

    private int setAcmLineCoding(int bitRate, int stopBits, int parity, int dataBits) {
        byte[] msg = new byte[]{(byte)(bitRate & 0xFF), (byte)(bitRate >> 8 & 0xFF), (byte)(bitRate >> 16 & 0xFF), (byte)(bitRate >> 24 & 0xFF), (byte)stopBits, (byte)parity, (byte)dataBits};
        return this.sendAcmControlMessage(32, 0, msg);
    }

    @Override
    public void close() throws IOException {
        this.mConnection.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(byte[] dest, int timeoutMillis) throws IOException {
        int numBytesRead;
        Object object = this.mReadBufferLock;
        synchronized (object) {
            block4: {
                int readAmt = Math.min(dest.length, this.mReadBuffer.length);
                numBytesRead = this.mConnection.bulkTransfer(this.mReadEndpoint, this.mReadBuffer, readAmt, timeoutMillis);
                if (numBytesRead >= 0) break block4;
                return 0;
            }
            System.arraycopy(this.mReadBuffer, 0, dest, 0, numBytesRead);
        }
        return numBytesRead;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int write(byte[] src, int timeoutMillis) throws IOException {
        int offset = 0;
        while (offset < src.length) {
            int amtWritten;
            int writeLength;
            Object object = this.mWriteBufferLock;
            synchronized (object) {
                byte[] writeBuffer;
                writeLength = Math.min(src.length - offset, this.mWriteBuffer.length);
                if (offset == 0) {
                    writeBuffer = src;
                } else {
                    System.arraycopy(src, offset, this.mWriteBuffer, 0, writeLength);
                    writeBuffer = this.mWriteBuffer;
                }
                amtWritten = this.mConnection.bulkTransfer(this.mWriteEndpoint, writeBuffer, writeLength, timeoutMillis);
            }
            if (amtWritten <= 0) {
                throw new IOException("Error writing " + writeLength + " bytes at offset " + offset + " length=" + src.length);
            }
            Log.d((String)this.TAG, (String)("Wrote amt=" + amtWritten + " attempted=" + writeLength));
            offset += amtWritten;
        }
        return offset;
    }

    @Override
    public int setBaudRate(int baudRate) throws IOException {
        this.setAcmLineCoding(baudRate, 0, 0, 8);
        return baudRate;
    }

    public static Map<Integer, int[]> getSupportedDevices() {
        LinkedHashMap<Integer, int[]> supportedDevices = new LinkedHashMap<Integer, int[]>();
        supportedDevices.put(9025, new int[]{1, 67, 16, 66, 59, 68, 63, 68, 32822});
        supportedDevices.put(5824, new int[]{1155});
        return supportedDevices;
    }
}

