/*
 * Decompiled with CFR 0.152.
 */
package com.hoho.android.usbserial.driver;

import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbEndpoint;
import android.util.Log;
import com.hoho.android.usbserial.driver.UsbSerialDriver;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public class FtdiSerialDriver
extends UsbSerialDriver {
    private static final int DEFAULT_BAUD_RATE = 115200;
    public static final int USB_TYPE_STANDARD = 0;
    public static final int USB_TYPE_CLASS = 0;
    public static final int USB_TYPE_VENDOR = 0;
    public static final int USB_TYPE_RESERVED = 0;
    public static final int USB_RECIP_DEVICE = 0;
    public static final int USB_RECIP_INTERFACE = 1;
    public static final int USB_RECIP_ENDPOINT = 2;
    public static final int USB_RECIP_OTHER = 3;
    public static final int USB_ENDPOINT_IN = 128;
    public static final int USB_ENDPOINT_OUT = 0;
    public static final int USB_WRITE_TIMEOUT_MILLIS = 5000;
    public static final int USB_READ_TIMEOUT_MILLIS = 5000;
    private static final int SIO_RESET_REQUEST = 0;
    private static final int SIO_MODEM_CTRL_REQUEST = 1;
    private static final int SIO_SET_FLOW_CTRL_REQUEST = 2;
    private static final int SIO_SET_BAUD_RATE_REQUEST = 3;
    private static final int SIO_SET_DATA_REQUEST = 4;
    private static final int SIO_RESET_SIO = 0;
    public static final int FTDI_DEVICE_OUT_REQTYPE = 64;
    public static final int FTDI_DEVICE_IN_REQTYPE = 192;
    private static final int MODEM_STATUS_HEADER_LENGTH = 2;
    private final String TAG = FtdiSerialDriver.class.getSimpleName();
    private DeviceType mType = null;
    private int mInterface = 0;
    private int mMaxPacketSize = 64;
    private static final boolean ENABLE_ASYNC_READS = false;

    public FtdiSerialDriver(UsbDevice usbDevice, UsbDeviceConnection usbConnection) {
        super(usbDevice, usbConnection);
    }

    public void reset() throws IOException {
        int result = this.mConnection.controlTransfer(64, 0, 0, 0, null, 0, 5000);
        if (result != 0) {
            throw new IOException("Reset failed: result=" + result);
        }
        this.mType = DeviceType.TYPE_R;
    }

    @Override
    public void open() throws IOException {
        boolean opened = false;
        try {
            int i = 0;
            while (i < this.mDevice.getInterfaceCount()) {
                if (this.mConnection.claimInterface(this.mDevice.getInterface(i), true)) {
                    Log.d((String)this.TAG, (String)("claimInterface " + i + " SUCCESS"));
                } else {
                    Log.d((String)this.TAG, (String)("claimInterface " + i + " FAIL"));
                }
                ++i;
            }
            this.reset();
            this.setBaudRate(115200);
            opened = true;
        }
        finally {
            if (!opened) {
                this.close();
            }
        }
    }

    @Override
    public void close() {
        this.mConnection.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(byte[] dest, int timeoutMillis) throws IOException {
        int totalBytesRead;
        UsbEndpoint endpoint = this.mDevice.getInterface(0).getEndpoint(0);
        Object object = this.mReadBufferLock;
        synchronized (object) {
            int readAmt = Math.min(dest.length, this.mReadBuffer.length);
            totalBytesRead = this.mConnection.bulkTransfer(endpoint, this.mReadBuffer, readAmt, timeoutMillis);
        }
        if (totalBytesRead < 2) {
            throw new IOException("Expected at least 2 bytes");
        }
        int payloadBytesRead = totalBytesRead - 2;
        if (payloadBytesRead > 0) {
            System.arraycopy(this.mReadBuffer, 2, dest, 0, payloadBytesRead);
        }
        return payloadBytesRead;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int write(byte[] src, int timeoutMillis) throws IOException {
        UsbEndpoint endpoint = this.mDevice.getInterface(0).getEndpoint(1);
        int offset = 0;
        while (offset < src.length) {
            int amtWritten;
            int writeLength;
            Object object = this.mWriteBufferLock;
            synchronized (object) {
                byte[] writeBuffer;
                writeLength = Math.min(src.length - offset, this.mWriteBuffer.length);
                if (offset == 0) {
                    writeBuffer = src;
                } else {
                    System.arraycopy(src, offset, this.mWriteBuffer, 0, writeLength);
                    writeBuffer = this.mWriteBuffer;
                }
                amtWritten = this.mConnection.bulkTransfer(endpoint, writeBuffer, writeLength, timeoutMillis);
            }
            if (amtWritten <= 0) {
                throw new IOException("Error writing " + writeLength + " bytes at offset " + offset + " length=" + src.length);
            }
            Log.d((String)this.TAG, (String)("Wrote amtWritten=" + amtWritten + " attempted=" + writeLength));
            offset += amtWritten;
        }
        return offset;
    }

    @Override
    public int setBaudRate(int baudRate) throws IOException {
        long[] vals = this.convertBaudrate(baudRate);
        long actualBaudrate = vals[0];
        long index = vals[1];
        long value = vals[2];
        Log.i((String)this.TAG, (String)("Requested baudrate=" + baudRate + ", actual=" + actualBaudrate));
        int result = this.mConnection.controlTransfer(64, 3, (int)value, (int)index, null, 0, 5000);
        if (result != 0) {
            throw new IOException("Setting baudrate failed: result=" + result);
        }
        return (int)actualBaudrate;
    }

    private long[] convertBaudrate(int baudrate) {
        long index;
        int divisor = 24000000 / baudrate;
        int bestDivisor = 0;
        int bestBaud = 0;
        int bestBaudDiff = 0;
        int[] nArray = new int[8];
        nArray[1] = 3;
        nArray[2] = 2;
        nArray[3] = 4;
        nArray[4] = 1;
        nArray[5] = 5;
        nArray[6] = 6;
        nArray[7] = 7;
        int[] fracCode = nArray;
        int i = 0;
        while (i < 2) {
            int tryDivisor = divisor + i;
            if (tryDivisor <= 8) {
                tryDivisor = 8;
            } else if (this.mType != DeviceType.TYPE_AM && tryDivisor < 12) {
                tryDivisor = 12;
            } else if (divisor < 16) {
                tryDivisor = 16;
            } else if (this.mType != DeviceType.TYPE_AM && tryDivisor > 131071) {
                tryDivisor = 131071;
            }
            int baudEstimate = (24000000 + tryDivisor / 2) / tryDivisor;
            int baudDiff = baudEstimate < baudrate ? baudrate - baudEstimate : baudEstimate - baudrate;
            if (i == 0 || baudDiff < bestBaudDiff) {
                bestDivisor = tryDivisor;
                bestBaud = baudEstimate;
                bestBaudDiff = baudDiff;
                if (baudDiff == 0) break;
            }
            ++i;
        }
        long encodedDivisor = bestDivisor >> 3 | fracCode[bestDivisor & 7] << 14;
        if (encodedDivisor == 1L) {
            encodedDivisor = 0L;
        } else if (encodedDivisor == 16385L) {
            encodedDivisor = 1L;
        }
        long value = encodedDivisor & 0xFFFFL;
        if (this.mType == DeviceType.TYPE_2232C || this.mType == DeviceType.TYPE_2232H || this.mType == DeviceType.TYPE_4232H) {
            index = encodedDivisor >> 8 & 0xFFFFL;
            index &= 0xFF00L;
            index |= 0L;
        } else {
            index = encodedDivisor >> 16 & 0xFFFFL;
        }
        return new long[]{bestBaud, index, value};
    }

    public static Map<Integer, int[]> getSupportedDevices() {
        LinkedHashMap<Integer, int[]> supportedDevices = new LinkedHashMap<Integer, int[]>();
        supportedDevices.put(1027, new int[]{24577});
        return supportedDevices;
    }

    private static enum DeviceType {
        TYPE_BM,
        TYPE_AM,
        TYPE_2232C,
        TYPE_R,
        TYPE_2232H,
        TYPE_4232H;

    }
}

