/*
 * Decompiled with CFR 0.152.
 */
package com.hoho.android.usbserial.driver;

import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import java.io.IOException;

public abstract class UsbSerialDriver {
    public static final int DEFAULT_READ_BUFFER_SIZE = 16384;
    public static final int DEFAULT_WRITE_BUFFER_SIZE = 16384;
    protected final UsbDevice mDevice;
    protected final UsbDeviceConnection mConnection;
    protected final Object mReadBufferLock = new Object();
    protected final Object mWriteBufferLock = new Object();
    protected byte[] mReadBuffer;
    protected byte[] mWriteBuffer;

    public UsbSerialDriver(UsbDevice device, UsbDeviceConnection connection) {
        this.mDevice = device;
        this.mConnection = connection;
        this.mReadBuffer = new byte[16384];
        this.mWriteBuffer = new byte[16384];
    }

    public abstract void open() throws IOException;

    public abstract void close() throws IOException;

    public abstract int read(byte[] var1, int var2) throws IOException;

    public abstract int write(byte[] var1, int var2) throws IOException;

    public abstract int setBaudRate(int var1) throws IOException;

    public final UsbDevice getDevice() {
        return this.mDevice;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setReadBufferSize(int bufferSize) {
        Object object = this.mReadBufferLock;
        synchronized (object) {
            if (bufferSize == this.mReadBuffer.length) {
                return;
            }
            this.mReadBuffer = new byte[bufferSize];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setWriteBufferSize(int bufferSize) {
        Object object = this.mWriteBufferLock;
        synchronized (object) {
            if (bufferSize == this.mWriteBuffer.length) {
                return;
            }
            this.mWriteBuffer = new byte[bufferSize];
        }
    }
}

