/*
 * Decompiled with CFR 0.152.
 */
package com.hoho.android.usbserial.driver;

import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbManager;
import com.hoho.android.usbserial.driver.CdcAcmSerialDriver;
import com.hoho.android.usbserial.driver.FtdiSerialDriver;
import com.hoho.android.usbserial.driver.UsbSerialDriver;
import java.util.Map;

public enum UsbSerialProber {
    FTDI_SERIAL{

        @Override
        public UsbSerialDriver getDevice(UsbManager manager, UsbDevice usbDevice) {
            if (!UsbSerialProber.testIfSupported(usbDevice, FtdiSerialDriver.getSupportedDevices())) {
                return null;
            }
            UsbDeviceConnection connection = manager.openDevice(usbDevice);
            if (connection == null) {
                return null;
            }
            return new FtdiSerialDriver(usbDevice, connection);
        }
    }
    ,
    CDC_ACM_SERIAL{

        @Override
        public UsbSerialDriver getDevice(UsbManager manager, UsbDevice usbDevice) {
            if (!UsbSerialProber.testIfSupported(usbDevice, CdcAcmSerialDriver.getSupportedDevices())) {
                return null;
            }
            UsbDeviceConnection connection = manager.openDevice(usbDevice);
            if (connection == null) {
                return null;
            }
            return new CdcAcmSerialDriver(usbDevice, connection);
        }
    };


    private UsbSerialProber() {
    }

    public abstract UsbSerialDriver getDevice(UsbManager var1, UsbDevice var2);

    public static UsbSerialDriver acquire(UsbManager usbManager) {
        for (UsbDevice usbDevice : usbManager.getDeviceList().values()) {
            UsbSerialDriver probedDevice = UsbSerialProber.acquire(usbManager, usbDevice);
            if (probedDevice == null) continue;
            return probedDevice;
        }
        return null;
    }

    public static UsbSerialDriver acquire(UsbManager usbManager, UsbDevice usbDevice) {
        UsbSerialProber[] usbSerialProberArray = UsbSerialProber.values();
        int n = usbSerialProberArray.length;
        int n2 = 0;
        while (n2 < n) {
            UsbSerialProber prober = usbSerialProberArray[n2];
            UsbSerialDriver probedDevice = prober.getDevice(usbManager, usbDevice);
            if (probedDevice != null) {
                return probedDevice;
            }
            ++n2;
        }
        return null;
    }

    private static boolean testIfSupported(UsbDevice usbDevice, Map<Integer, int[]> supportedDevices) {
        int[] supportedProducts = supportedDevices.get(usbDevice.getVendorId());
        if (supportedProducts == null) {
            return false;
        }
        int productId = usbDevice.getProductId();
        int[] nArray = supportedProducts;
        int n = supportedProducts.length;
        int n2 = 0;
        while (n2 < n) {
            int supportedProductId = nArray[n2];
            if (productId == supportedProductId) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    /* synthetic */ UsbSerialProber(String string, int n, UsbSerialProber usbSerialProber) {
        this();
    }
}

