/*
 * Decompiled with CFR 0.152.
 */
package com.hoho.android.usbserial.util;

public class HexDump {
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static String dumpHexString(byte[] array) {
        return HexDump.dumpHexString(array, 0, array.length);
    }

    public static String dumpHexString(byte[] array, int offset, int length) {
        StringBuilder result = new StringBuilder();
        byte[] line = new byte[16];
        int lineIndex = 0;
        result.append("\n0x");
        result.append(HexDump.toHexString(offset));
        int i = offset;
        while (i < offset + length) {
            if (lineIndex == 16) {
                result.append(" ");
                int j = 0;
                while (j < 16) {
                    if (line[j] > 32 && line[j] < 126) {
                        result.append(new String(line, j, 1));
                    } else {
                        result.append(".");
                    }
                    ++j;
                }
                result.append("\n0x");
                result.append(HexDump.toHexString(i));
                lineIndex = 0;
            }
            byte b = array[i];
            result.append(" ");
            result.append(HEX_DIGITS[b >>> 4 & 0xF]);
            result.append(HEX_DIGITS[b & 0xF]);
            line[lineIndex++] = b;
            ++i;
        }
        if (lineIndex != 16) {
            int count = (16 - lineIndex) * 3;
            ++count;
            int i2 = 0;
            while (i2 < count) {
                result.append(" ");
                ++i2;
            }
            i2 = 0;
            while (i2 < lineIndex) {
                if (line[i2] > 32 && line[i2] < 126) {
                    result.append(new String(line, i2, 1));
                } else {
                    result.append(".");
                }
                ++i2;
            }
        }
        return result.toString();
    }

    public static String toHexString(byte b) {
        return HexDump.toHexString(HexDump.toByteArray(b));
    }

    public static String toHexString(byte[] array) {
        return HexDump.toHexString(array, 0, array.length);
    }

    public static String toHexString(byte[] array, int offset, int length) {
        char[] buf = new char[length * 2];
        int bufIndex = 0;
        int i = offset;
        while (i < offset + length) {
            byte b = array[i];
            buf[bufIndex++] = HEX_DIGITS[b >>> 4 & 0xF];
            buf[bufIndex++] = HEX_DIGITS[b & 0xF];
            ++i;
        }
        return new String(buf);
    }

    public static String toHexString(int i) {
        return HexDump.toHexString(HexDump.toByteArray(i));
    }

    public static byte[] toByteArray(byte b) {
        byte[] array = new byte[]{b};
        return array;
    }

    public static byte[] toByteArray(int i) {
        byte[] array = new byte[4];
        array[3] = (byte)(i & 0xFF);
        array[2] = (byte)(i >> 8 & 0xFF);
        array[1] = (byte)(i >> 16 & 0xFF);
        array[0] = (byte)(i >> 24 & 0xFF);
        return array;
    }

    private static int toByte(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        throw new RuntimeException("Invalid hex char '" + c + "'");
    }

    public static byte[] hexStringToByteArray(String hexString) {
        int length = hexString.length();
        byte[] buffer = new byte[length / 2];
        int i = 0;
        while (i < length) {
            buffer[i / 2] = (byte)(HexDump.toByte(hexString.charAt(i)) << 4 | HexDump.toByte(hexString.charAt(i + 1)));
            i += 2;
        }
        return buffer;
    }
}

