package com.gen2wave.g2w_nfc_demo;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;



import android.app.Activity;
import android.app.AlertDialog;
import android.app.PendingIntent;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.nfc.NdefMessage;
import android.nfc.NdefRecord;
import android.nfc.NfcAdapter;
import android.nfc.Tag;
import android.nfc.tech.MifareClassic;
import android.nfc.tech.MifareUltralight;
import android.nfc.tech.Ndef;
import android.nfc.tech.NdefFormatable;
import android.nfc.tech.NfcA;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import android.util.Log;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;
import android.widget.Toast;


public class NfcActivity extends Activity {

	
	
	final String TAG = NfcActivity.class.getSimpleName();

	// ********************************************************************************
	// Layout Member
	// ********************************************************************************

	private TextView tv_nfc;

	private TextView tv_tag_type;
	private TextView tv_technologies;
	private TextView tv_serial;
	private TextView tv_atqa;
	private TextView tv_sak;
	private TextView tv_memory;
	
	private NfcAdapter mNfcAdapter;
	public static final String MIME_TEXT_PLAIN = "text/plain";
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_nfc);
        init();
    }
    
    private void init()
    {
    	mNfcAdapter = NfcAdapter.getDefaultAdapter(this);

		if (mNfcAdapter == null) {
			Toast.makeText(this, "This device doesn't support NFC.", Toast.LENGTH_LONG).show();
			finish();
		} else {
			
			if (!mNfcAdapter.isEnabled()) {
				// �떆�뒪�뀥 �뼱�뵆�씤 寃쎌슦 媛��뒫�븷 �닔�엳�떎.
				// changeNfcEnabled(this, true);
				
				// �뙘�뾽�쓣 蹂댁씤 �썑 �궘�젣
				AlertDialog.Builder alertDialog = new AlertDialog.Builder(this);
				alertDialog.setPositiveButton("Yes", new DialogInterface.OnClickListener() {
					@Override
					public void onClick(DialogInterface dialog, int which) {
						dialog.dismiss();

						if (android.os.Build.VERSION.SDK_INT >= Build.VERSION_CODES.JELLY_BEAN) {
							startActivity(new Intent("android.settings.NFC_SETTINGS"/*android.provider.Settings.ACTION_NFC_SETTINGS*/));
						} else {
							startActivity(new Intent(android.provider.Settings.ACTION_WIRELESS_SETTINGS));
						}
						finish();
						onBackPressed();
					}
				});
				alertDialog.setNegativeButton("No", new DialogInterface.OnClickListener() {
					@Override
					public void onClick(DialogInterface dialog, int which) {
						dialog.dismiss();
						finish();
					}
				});
				alertDialog.setMessage("NFC was disabled.\nPlease change nfc setting");
				alertDialog.show();
			} else {
				init_view();
			}
		}
    }
    private void init_view()
    {
    //	tv_nfc = (TextView)findViewById(R.id.tv_nfc);

		tv_tag_type = (TextView)findViewById(R.id.tv_tag_type);
		tv_technologies = (TextView)findViewById(R.id.tv_technologies);
		tv_serial = (TextView)findViewById(R.id.tv_serial);
		tv_atqa = (TextView)findViewById(R.id.tv_atqa);
		tv_sak = (TextView)findViewById(R.id.tv_sak);
		tv_memory = (TextView)findViewById(R.id.tv_memory);


		
    }
    @Override
    protected void onResume() {
    	
    	super.onResume();
    	NfcAdapter nfcAdapter = NfcAdapter.getDefaultAdapter(this);        

		if (!nfcAdapter.isEnabled())     {   
			Toast.makeText(this, "This device doesn't activate NFC.", Toast.LENGTH_LONG).show();
		} else {
			//		      setupForegroundDispatch(this, mNfcAdapter);
			PendingIntent pendingintent = PendingIntent.getActivity(this, 0, new Intent(this, getClass()).addFlags(Intent.FLAG_ACTIVITY_SINGLE_TOP),0);
			NfcAdapter.getDefaultAdapter(this).enableForegroundDispatch(this, pendingintent, null, null);
		}
    }

    @Override
    protected void onPause() {
    	
    	super.onPause();
    	if(NfcAdapter.getDefaultAdapter(this) != null) {
			NfcAdapter.getDefaultAdapter(this).disableForegroundDispatch(this);
		}
    }
    @Override
    protected void onNewIntent(Intent intent) {
    	// TODO Auto-generated method stub
    	super.onNewIntent(intent);
    	resolveIntent(intent);
    }
    
    void resolveIntent(Intent intent){

		String action = intent.getAction();

		Log.d(TAG, "resolveIntent action : " + action);

		if(action.equals(NfcAdapter.ACTION_NDEF_DISCOVERED) || 
				action.equals(NfcAdapter.ACTION_TAG_DISCOVERED) || 
				action.equals(NfcAdapter.ACTION_TECH_DISCOVERED)) {

			(findViewById(R.id.layout_additional)).setVisibility(View.GONE);

			Tag mytag = (Tag) intent.getParcelableExtra(NfcAdapter.EXTRA_TAG);

			Log.d(TAG, "TAG describeContents : " + mytag.describeContents());
			Log.d(TAG, "TAG id : " + byteArrayToIdString(mytag.getId()));

			tv_serial.setText( byteArrayToIdString(mytag.getId()));

			String techlist = "";

			if (mytag != null) {
				Log.d(TAG,"!=null");
				for (int i = 0; i < mytag.getTechList().length; i++) {
					String tech = mytag.getTechList()[i];

					tech = tech.substring(tech.lastIndexOf(".")+1, tech.length());
					techlist += tech;
					if (i+1 < mytag.getTechList().length) {
						techlist += ",";
					}
					Log.e(TAG, "resolveIntent tech : " + tech);

					if (tech.equals("MifareUltralight")) {
						MifareUltralight(mytag);
					} else if (tech.equals("MifareClassic")) {
						MifareClassic(mytag);
					} else if (tech.equals("NfcA")) {
						NfcA(mytag);
					} else if (tech.equals("NdefFormatable")) {
						NdefFormatable(mytag);
					} else if (tech.equals("Ndef")) {
						Ndef(mytag);
					}
				}
				tv_technologies.setText(techlist);

			}

			//			* NfcA (also known as ISO 14443-3A)
			//
			//			* NfcB (also known as ISO 14443-3B)
			//
			//			* NfcF (also known as JIS 6319-4)
			//
			//			* NfcV (also known as ISO 15693)
			//
			//			* IsoDep
			//
			//			* Ndef on NFC Forum Type 1, Type 2, Type 3 or Type 4 compliant tags
			//
			//			But also optionally: 
			//			* MifareClassic
			//
			//			* MifareUltralight

			//tv_nfc.setVisibility(View.GONE);
		}

		handleIntent(intent);

	}
    
    public static String byteArrayToIdString(byte[] array) {
		StringBuffer hexString = new StringBuffer();
		int count = 0;
		for (byte b : array) {
			int intVal = b & 0xff;
			if (intVal < 0x10)
				hexString.append("0");
			hexString.append(Integer.toHexString(intVal));
			count++;
			if (count != array.length) {
				hexString.append(":");
			}
		}
		return hexString.toString();    
	}

	public static String byteArrayToHexString(byte[] array) {
		StringBuffer hexString = new StringBuffer();
		hexString.append("0x");

		for (int i = array.length-1; i >= 0; i--) {
			byte b = array[i];
			int intVal = b & 0xff;
			if (intVal < 0x10)
				hexString.append("0");
			hexString.append(Integer.toHexString(intVal));

		}
		return hexString.toString();    
	}

	private void MifareUltralight(Tag mytag ) {
		MifareUltralight mi = MifareUltralight.get(mytag);
		Log.d(TAG, "MifareUltralight MifareUltralight : " + mi.toString());
		Log.d(TAG, "MifareUltralight MifareUltralight : " + mi.getType());
		String type = "";
		switch (mi.getType()) {
		case MifareUltralight.TYPE_ULTRALIGHT:		type = "MIFARE Ultralight";	break;
		case MifareUltralight.TYPE_ULTRALIGHT_C: 	type = "MIFARE Ultralight C";	break;
		case MifareUltralight.TYPE_UNKNOWN:			type = "MIFARE Ultralight compatible tag of unknown type";	break;
		default: break;
		}
		tv_tag_type.setText(type);

		Log.d(TAG, "MifareUltralight getMaxTransceiveLength : " + mi.getMaxTransceiveLength());
		Log.d(TAG, "MifareUltralight getTimeout : " + mi.getTimeout());
	}

	private void MifareClassic(Tag mytag) {
		MifareClassic mc = MifareClassic.get(mytag);
		Log.d(TAG, "MifareClassic toString : " + mc.toString());
		Log.d(TAG, "MifareClassic getBlockCount : " + mc.getBlockCount());
		Log.d(TAG, "MifareClassic getMaxTransceiveLength : " + mc.getMaxTransceiveLength());
		Log.d(TAG, "MifareClassic getSectorCount : " + mc.getSectorCount());

		Log.d(TAG, "MifareClassic getSize : " + mc.getSize()); 					//		One of SIZE_MINI, SIZE_1K, SIZE_2K, SIZE_4K.
		String memory = "";
		switch (mc.getSize()) {
		case MifareClassic.SIZE_1K:		memory = "1 kBytes : 16 sectors each of 4 blocks.";	break;
		case MifareClassic.SIZE_2K: 	memory = "2 kBytes : 32 sectors each of 4 blocks.";	break;
		case MifareClassic.SIZE_4K:		memory = "4 kBytes : The first 32 sectors contain 4 blocks and the last 8 sectors contain 16 blocks.";	break;
		case MifareClassic.SIZE_MINI:	memory = "1 kBytes : 5 sectors each of 4 blocks.";	break;
		default: break;
		}
		tv_memory.setText(memory);

		Log.d(TAG, "MifareClassic getTimeout : " + mc.getTimeout());
		Log.d(TAG, "MifareClassic getType : " + mc.getType());
		String type = "";
		switch (mc.getType()) {
		case MifareClassic.TYPE_CLASSIC:	type = "MIFARE Classic";	break;
		case MifareClassic.TYPE_PLUS: 		type = "MIFARE Plus";	break;
		case MifareClassic.TYPE_PRO:		type = "MIFARE Pro";	break;
		case MifareClassic.TYPE_UNKNOWN:	type = "MIFARE Classic compatible card of unknown type";	break;
		default: break;
		}
		tv_tag_type.setText(type);
	}

	private void NfcA(Tag mytag ) {
		NfcA na = NfcA.get(mytag);
		Log.d(TAG, "NfcA NfcA : " + na.toString());

		Log.d(TAG, "NfcA getAtqa : " + byteArrayToHexString(na.getAtqa()));
		tv_atqa.setText(byteArrayToHexString(na.getAtqa()));

		Log.d(TAG, "NfcA getMaxTransceiveLength : " + na.getMaxTransceiveLength());
		Log.d(TAG, "NfcA getSak : " + String.format("0x%2d", na.getSak()));
		tv_sak.setText(String.format("0x%02d", Integer.valueOf(Integer.toHexString(na.getSak()))));

		Log.d(TAG, "NfcA getTimeout : " + na.getTimeout());
		Tag natag = na.getTag();
	}

	private void Ndef (Tag mytag ) {
		
		(findViewById(R.id.layout_additional)).setVisibility(View.VISIBLE);

		Ndef ndef = Ndef.get(mytag);
		Log.d(TAG, "Ndef Ndef : " + ndef.toString());

		Log.d(TAG, "Ndef getCachedNdefMessage : " + ndef.getCachedNdefMessage());
		Log.d(TAG, "Ndef getMaxSize : " + ndef.getMaxSize());

		tv_memory.setText("168 bytes : 42 pages (4 bytes each)");
		
		// Data format
		Log.d(TAG, "Ndef getType : " + ndef.getType());
		if (ndef.getType().equals(Ndef.MIFARE_CLASSIC)) {
			((TextView)findViewById(R.id.tv_data_format)).setText("NDEF on MIFARE Classic");
		} else if (ndef.getType().equals(Ndef.NFC_FORUM_TYPE_1)) {
			((TextView)findViewById(R.id.tv_data_format)).setText("NFC Forum Tag Type 1");
		} else if (ndef.getType().equals(Ndef.NFC_FORUM_TYPE_2)) {
			((TextView)findViewById(R.id.tv_data_format)).setText("NFC Forum Tag Type 2");
		} else if (ndef.getType().equals(Ndef.NFC_FORUM_TYPE_3)) {
			((TextView)findViewById(R.id.tv_data_format)).setText("NFC Forum Tag Type 4");
		} else if (ndef.getType().equals(Ndef.NFC_FORUM_TYPE_4)) {
			((TextView)findViewById(R.id.tv_data_format)).setText("NFC Forum Tag Type 4");
		} 

		Log.e(TAG, "MaxSize: " + ndef.getMaxSize());
		((TextView)findViewById(R.id.tv_size)).setText("93" + " / " + ndef.getMaxSize() + " Bytes");
		Log.e(TAG, "Writable: " + ndef.isWritable());
		((TextView)findViewById(R.id.tv_writable)).setText(ndef.isWritable()? "YES":"NO");
		Log.e(TAG, "canMakeReadOnly: " + ndef.canMakeReadOnly());
		((TextView)findViewById(R.id.tv_make_readonly)).setText(ndef.canMakeReadOnly()? "YES":"NO");

		Log.d(TAG, "Ndef getTag : " + ndef.getTag());
		String record = "";
		// get NDEF message details
		NdefMessage ndefMesg = ndef.getCachedNdefMessage();
		NdefRecord[] ndefRecords = ndefMesg.getRecords();
		int len = ndefRecords.length;
		String[] recTypes = new String[len];     // will contain the NDEF record types
		String[] payLoads = new String[len];     // will contain the NDEF record types
		for (int j = 0; j < len; j++) {
			recTypes[j] = new String(ndefRecords[j].getType());
			payLoads[j] = new String(ndefRecords[j].getPayload());
			record += recTypes[j] + " : " + payLoads[j] + "\n";
			Log.e(TAG, "detail : " + recTypes[j]  + ", payload : " + payLoads[j]);
		}
		
		((TextView)findViewById(R.id.tv_record)).setText(record);
	}

	private void NdefFormatable (Tag mytag ) {
		String strDisplay = "";

		NdefFormatable ndef = NdefFormatable.get(mytag);
		Log.d(TAG, "Ndef Ndef : " + ndef.toString());
	}



	void testResolveIntent(Intent intent) {
		// 1) Parse the intent and get the action that triggered this intent
		String action = intent.getAction();
		// 2) Check if it was triggered by a tag discovered interruption.
		if (NfcAdapter.ACTION_TECH_DISCOVERED.equals(action)) {
			//  3) Get an instance of the TAG from the NfcAdapter
			Tag tagFromIntent = intent.getParcelableExtra(NfcAdapter.EXTRA_TAG);
			// 4) Get an instance of the Mifare classic card from this TAG intent
			MifareClassic mfc = MifareClassic.get(tagFromIntent);
			byte[] data;

			try {       //  5.1) Connect to card 
				mfc.connect();
				boolean auth = false;
				String cardData = null;
				// 5.2) and get the number of sectors this card has..and loop thru these sectors
				int secCount = mfc.getSectorCount();
				int bCount = 0;
				int bIndex = 0;
				for(int j = 0; j < secCount; j++){
					// 6.1) authenticate the sector
					auth = mfc.authenticateSectorWithKeyA(j, MifareClassic.KEY_DEFAULT);
					if(auth){
						// 6.2) In each sector - get the block count
						bCount = mfc.getBlockCountInSector(j);
						bIndex = 0;
						for(int i = 0; i < bCount; i++){
							bIndex = mfc.sectorToBlock(j);
							// 6.3) Read the block
							data = mfc.readBlock(bIndex);    
							// 7) Convert the data into a string from Hex format.                
							//							Log.i(TAG, getHexString(data, data.length));
							bIndex++;
						}
					}else{ // Authentication failed - Handle it

					}
				}    
			}catch (IOException e) { 
				Log.e(TAG, e.getLocalizedMessage());
				//				showAlert(3);
			}
		}// End of method
	}


	private void handleIntent(Intent intent) {
		String action = intent.getAction();
		if (NfcAdapter.ACTION_NDEF_DISCOVERED.equals(action)) {

			String type = intent.getType();
			if (MIME_TEXT_PLAIN.equals(type)) {

				Tag tag = intent.getParcelableExtra(NfcAdapter.EXTRA_TAG);
				new NdefReaderTask().execute(tag);

			} else {
				Log.d(TAG, "Wrong mime type: " + type);
			}
		} else if (NfcAdapter.ACTION_TECH_DISCOVERED.equals(action)) {

			// In case we would still use the Tech Discovered Intent
			Tag tag = intent.getParcelableExtra(NfcAdapter.EXTRA_TAG);
			String[] techList = tag.getTechList();
			String searchedTech = Ndef.class.getName();

			for (String tech : techList) {
				if (searchedTech.equals(tech)) {
					new NdefReaderTask().execute(tag);
					break;
				}
			}
		}
	}




	/**
	 * Background task for reading the data. Do not block the UI thread while reading. 
	 * 
	 * @author Ralf Wondratschek
	 *
	 */
	private class NdefReaderTask extends AsyncTask<Tag, Void, String> {

		@Override
		protected String doInBackground(Tag... params) {
			Tag tag = params[0];

			Ndef ndef = Ndef.get(tag);
			if (ndef == null) {
				// NDEF is not supported by this Tag. 
				return null;
			}

			NdefMessage ndefMessage = ndef.getCachedNdefMessage();

			NdefRecord[] records = ndefMessage.getRecords();
			for (NdefRecord ndefRecord : records) {
				if (ndefRecord.getTnf() == NdefRecord.TNF_WELL_KNOWN && Arrays.equals(ndefRecord.getType(), NdefRecord.RTD_TEXT)) {
					try {
						return readText(ndefRecord);
					} catch (UnsupportedEncodingException e) {
						Log.e(TAG, "Unsupported Encoding", e);
					}
				}
			}

			return null;
		}

		private String readText(NdefRecord record) throws UnsupportedEncodingException {
			/*
			 * See NFC forum specification for "Text Record Type Definition" at 3.2.1 
			 * 
			 * http://www.nfc-forum.org/specs/
			 * 
			 * bit_7 defines encoding
			 * bit_6 reserved for future use, must be 0
			 * bit_5..0 length of IANA language code
			 */

			byte[] payload = record.getPayload();

			// Get the Text Encoding
			String textEncoding = ((payload[0] & 128) == 0) ? "UTF-8" : "UTF-16";

			// Get the Language Code
			int languageCodeLength = payload[0] & 0063;

			// String languageCode = new String(payload, 1, languageCodeLength, "US-ASCII");
			// e.g. "en"

			// Get the Text
			return new String(payload, languageCodeLength + 1, payload.length - languageCodeLength - 1, textEncoding);
		}

		@Override
		protected void onPostExecute(String result) {
			if (result != null) {
				Log.e(TAG, "Read content: " + result);
				//                mTextView.setText("Read content: " + result);
			}
		}
	}

	
	public boolean changeNfcEnabled(Context context, boolean enabled) {
	    // Turn NFC on/off
	    final boolean desiredState = enabled;
	    mNfcAdapter = NfcAdapter.getDefaultAdapter(context);

	    if (mNfcAdapter == null) {
	        // NFC is not supported
	        return false;
	    }

	    new Thread("toggleNFC") {
	        public void run() {
	            Log.d(TAG, "Setting NFC enabled state to: " + desiredState);
	            boolean success = false;
	            Class<?> NfcManagerClass;
	            Method setNfcEnabled, setNfcDisabled;
	            boolean Nfc;
	            if (desiredState) {
	                try {
	                    NfcManagerClass = Class.forName(mNfcAdapter.getClass().getName());
	                    setNfcEnabled   = NfcManagerClass.getDeclaredMethod("enable");
	                    setNfcEnabled.setAccessible(true);
	                    Nfc             = (Boolean) setNfcEnabled.invoke(mNfcAdapter);
	                    success         = Nfc;
	                } catch (ClassNotFoundException e) {
	                } catch (NoSuchMethodException e) {
	                } catch (IllegalArgumentException e) {
	                } catch (IllegalAccessException e) {
	                } catch (InvocationTargetException e) {
	                }
	            } else {
	                try {
	                    NfcManagerClass = Class.forName(mNfcAdapter.getClass().getName());
	                    setNfcDisabled  = NfcManagerClass.getDeclaredMethod("disable");
	                    setNfcDisabled.setAccessible(true);
	                    Nfc             = (Boolean) setNfcDisabled.invoke(mNfcAdapter);
	                    success         = Nfc;
	                } catch (ClassNotFoundException e) {
	                } catch (NoSuchMethodException e) {
	                } catch (IllegalArgumentException e) {
	                } catch (IllegalAccessException e) {
	                } catch (InvocationTargetException e) {
	                }
	            }
	            if (success) {
	                Log.d(TAG, "Successfully changed NFC enabled state to "+ desiredState);
	            } else {
	                Log.w(TAG, "Error setting NFC enabled state to "+ desiredState);
	            }
	        }
	    }.start();
	    return false;
	}//end method

   
}
