package gen2wave.rp70biodemo;

import android.app.Service;
import android.content.Intent;
import android.os.Binder;
import android.os.IBinder;
import android.support.annotation.Nullable;
import android.util.Log;

public class RemoveTaskListenerService extends Service {

    private final String TAG = "RemoveTaskListenerService";

    @Nullable
    @Override
    public IBinder onBind(Intent intent) {
        return mBinder;
    }

    @Override
    public void onCreate() {
        super.onCreate();
        Log.d(TAG, "Service onCreate called");
    }

    @Override
    public void onTaskRemoved(Intent rootIntent) {
        super.onTaskRemoved(rootIntent);
        Log.d(TAG, "Service onTaskRemoved called");
        removeCallback.recvRemoveEvent();
        stopSelf();
    }

    @Override
    public boolean onUnbind(Intent intent) {
        Log.d(TAG, "Service onUnbind called");
        return super.onUnbind(intent);
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        Log.d(TAG, "Service onDestroy called");
    }

    public class RemoveBinder extends Binder {
        public RemoveTaskListenerService getService() { return RemoveTaskListenerService.this; }
    }

    public interface IRemoveCallback {
        void recvRemoveEvent();
    }

    private IRemoveCallback removeCallback;

    public void registerCallback(IRemoveCallback callback) {
        Log.d(TAG, "Service registerCallback");
        removeCallback = callback;
    }

    private final IBinder mBinder = new RemoveBinder();

    @Override
    public int onStartCommand(Intent intent, int flags, int startId) {
        return super.onStartCommand(intent, flags, startId);
    }
}