package gen2wave.rp70biodemo.fingersuprema;

import android.content.Context;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.support.annotation.Nullable;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.EditorInfo;
import android.widget.EditText;
import android.widget.Spinner;

import java.lang.ref.WeakReference;

import gen2wave.rp70biodemo.R;
import gen2wave.rp70biodemo.tools.SendCommToEnrollFragment;

/**
 * Created by mastyle on 17. 6. 7.
 */
public class SpEnrollFragment extends SpBaseFragment implements SendCommToEnrollFragment {


    final String TAG = "SpEnrollFragment";

    EditText userIdEt = null, firstNameEt = null, lastNameEt = null;
    Spinner exportImageAlgo = null;

    private final int REQUEST_EXTERNAL_STORAGE = 1;

    @Override
    public void onAttach(Context context) {
        super.onAttach(context);
        ((FingerSupremaMainActivity)context).sendCommToEnrollFragment = (SendCommToEnrollFragment) this;
        Log.d(TAG, "onAttach");
    }

    @Override
    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Log.d(TAG, "onCreate");
    }

    @Nullable
    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        super.onCreateView(inflater, container, savedInstanceState);
        Log.d(TAG, "onCreateView");

        ViewGroup rootView = (ViewGroup) inflater.inflate(R.layout.enroll_fragment_main, container, false);
        getActivity().setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_LANDSCAPE);
        userIdEt = (EditText) rootView.findViewById(R.id.user_id);
        firstNameEt = (EditText) rootView.findViewById(R.id.first_name);
        lastNameEt = (EditText) rootView.findViewById(R.id.last_name);
        userIdEt.setImeOptions(EditorInfo.IME_ACTION_NEXT);
        firstNameEt.setImeOptions(EditorInfo.IME_ACTION_NEXT);
        lastNameEt.setImeOptions(EditorInfo.IME_ACTION_DONE);


        return rootView;
    }

    @Override
    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        if (requestCode == REQUEST_EXTERNAL_STORAGE) {
            for (int i = 0; i < permissions.length; i++) {
                int grantResult = grantResults[i];
                if (grantResult == PackageManager.PERMISSION_DENIED) {
                    exportImageAlgo.setSelection(0);
                }
            }
        }
    }

    boolean onPause = false;

    @Override
    public void onResume() {
        super.onResume();
        onPause = false;
        Log.d(TAG, "onResume");
    }

    @Override
    public void onPause() {
        super.onPause();
        onPause = true;
        Log.d(TAG, "onPause");
    }

    @Override
    public void onDestroyView() {
        super.onDestroyView();
        Log.d(TAG, "onDestroyView");
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        Log.d(TAG, "onDestroy");
    }



    @Override
    public void refreshEditText() {
        Log.d(TAG, "refreshList in Enroll");
        if (!onPause) {
            handler.sendEmptyMessage(SET_TEXT_TO_NULL);
        }

    }

    private final int SET_TEXT_TO_NULL = 0;

    public void handleMessage(Message msg) {

        Log.d(TAG, "handleMessage");
        userIdEt.setText(null);
        firstNameEt.setText(null);
        lastNameEt.setText(null);
    }

    WeakHandler handler = new WeakHandler(this);

    public static class WeakHandler extends Handler {
        private final WeakReference<SpEnrollFragment> weakActivity;

        public WeakHandler(SpEnrollFragment activity) {
            this.weakActivity = new WeakReference<SpEnrollFragment>(activity);
        }

        @Override
        public void handleMessage(Message msg) {
            super.handleMessage(msg);

            SpEnrollFragment activity = weakActivity.get();
            if (activity != null) {
                activity.handleMessage(msg);
            }
        }
    }
}
