package gen2wave.rp70biodemo.fingersuprema;

import android.content.Context;
import android.content.pm.ActivityInfo;
import android.graphics.Bitmap;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.TextView;

import gen2wave.rp70biodemo.R;
import gen2wave.rp70biodemo.tools.SendDataToSearchFragment;

/**
 * Created by mastyle on 17. 6. 13.
 */
public class SpSearchFragment extends SpBaseFragment implements SendDataToSearchFragment {

    private final String TAG = "SpSearchFragment";

    TextView userIDtxt = null, firstNameTxt = null, lastNameTxt = null;
    TextView textViewMessageTxt = null;
    ProgressBar verticalProgressbar = null;
    ImageView imageView1 = null;

    @Override
    public void onAttach(Context context) {
        super.onAttach(context);
        Log.d(TAG, "onAttach");
        ((FingerSupremaMainActivity)context).dataPasserToSearch = (SendDataToSearchFragment) this;
    }

    @Override
    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Log.d(TAG, "onCreate");
    }

    @Nullable
    @Override
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        super.onCreateView(inflater, container, savedInstanceState);
        Log.d(TAG, "onCreateView");
        ViewGroup rootView = (ViewGroup) inflater.inflate(R.layout.search_fragment_main, container, false);
        getActivity().setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_LANDSCAPE);
        userIDtxt = (TextView) rootView.findViewById(R.id.user_id_search);
        firstNameTxt = (TextView) rootView.findViewById(R.id.first_name_search);
        lastNameTxt = (TextView) rootView.findViewById(R.id.last_name_search);
        textViewMessageTxt = (TextView) rootView.findViewById(R.id.textViewMessage);
        verticalProgressbar = (ProgressBar) rootView.findViewById(R.id.vertical_progressbar);
        imageView1 = (ImageView) rootView.findViewById(R.id.imageView1);

        return rootView;
    }

    @Override
    public void onResume() {
        super.onResume();

        Log.d(TAG, "onResume");
        userIDtxt.setText("User ID");
        firstNameTxt.setText("First Name");
        lastNameTxt.setText("Last Name");
        onPause = false;
    }

    boolean onPause = false;

    @Override
    public void onPause() {
        super.onPause();
        Log.d(TAG, "onPause");
        onPause = true;
    }



    @Override
    public void sendStringData(String data) {
        textViewMessageTxt.setText(data);
    }

    @Override
    public void sendStringData(String id, String first, String last) {
        if (!onPause) {
            userIDtxt.setText(id);
            firstNameTxt.setText(first);
            lastNameTxt.setText(last);
        }
    }

    @Override
    public void sendIntData(int data) {
        try {
            if (!onPause) {
                verticalProgressbar.setProgress(data);
            }
        } catch (Exception e) {
            e.getMessage();
        }
    }

    @Override
    public void sendBitmapData(Bitmap data) {
        if (!onPause) {
            imageView1.setImageBitmap(data);
        }
    }
}
