package gen2wave.rp70biodemo.info;

public class MSROCRMessageValues {
    /*
     * Command Types
     *
     * @msg.what GET_VERSION
     * @return String
     *
     * @msg.what RESET
     * @return boolean
     *
     * @msg.what GET_SYNC
     * @return boolean
     *
     * @msg.what LED_ON_OFF_COLOR
     * @msg.arg1 0:off, 1:on
     * @msg.arg2 1:red, 2:green, 3:both
     * @return boolean
     *
     * @msg.what LED_ON_SF
     * @msg.arg2 1:red, 2:green
     * @return boolean
     *
     * @msg.what GET_LED
     * @return int
     *
     * @msg.what SET_POWER
     * @msg.arg1 0:off, 1:on
     * @bundle boolean(finger), boolean(ocr), boolean(msr)
     * @return boolean
     *
     * @msg.what GET_POWER
     * @return int
     */
    public static final int GET_VERSION = 1;
    public static final int RESET = 2;
    public static final int GET_SYNC = 3;
    public static final int LED_ON_OFF_COLOR = 4;
    public static final int LED_ON_SF = 5;
    public static final int GET_LED = 6;
    public static final int SET_POWER = 7;
    public static final int GET_POWER = 8;
    public static final int BUZZER_SF = 9;
    public static final int BUZZER_POWER = 10;
    public static final int SET_DEBUG = 11;
    public static final int GET_DEBUG = 12;
    public static final int SET_CONFIGURE = 13;
    public static final int SET_CONFIGURE_DEFAULT = 14;
    public static final int GET_CONFIGURE = 15;
    public static final int SET_BIO_POWER = 17;

    /*
     * command response bundle keys
     */
    public static final String RESULT_STRING_KEY = "result_string";
    public static final String RESULT_INT_KEY = "result_int";
    public static final String RESULT_BOOLEAN_KEY = "result_boolean";

    /*
     * return back the values to client(application) with result
     */
    public static final String SET_POWER_FINGER_KEY = "power_finger";
    public static final String SET_POWER_OCR_KEY = "power_ocr";
    public static final String SET_POWER_MSR_KEY = "power_msr";
    public static final String SET_CONFIGURE_KEY = "set_configure";
}
