/**
 *-------------------------------------------------------
 * Copyright (c) 2014 GEMALTO. All Rights Reserved.
 *-------------------------------------------------------
 */
package com.gemalto.gempcsc;

import android.os.Parcel;
import android.os.Parcelable;

public class GemPCSC_StatusInfo implements Parcelable {

	/* See CCID specs ch. 4.2.1 */
	// protected final int CCID_ICC_PRESENT_ACTIVE = 0x00; /* 00 0000 00 */
	// protected final int CCID_ICC_PRESENT_INACTIVE = 0x01; /* 00 0000 01 */
	// protected final int CCID_ICC_ABSENT = 0x02; /* 00 0000 10 */

	private int slotStatus;
	private byte[] atr;

	public GemPCSC_StatusInfo(final int slotStatus, final byte[] atr) {
		this.slotStatus = slotStatus;
		this.atr = atr;
	}

	public static final Parcelable.Creator<GemPCSC_StatusInfo> CREATOR = new Parcelable.Creator<GemPCSC_StatusInfo>() {

		@Override
		public GemPCSC_StatusInfo createFromParcel(Parcel source) {
			final int slotStatus = source.readInt();
			final byte[] atr = new byte[source.readInt()];
			source.readByteArray(atr);
			return new GemPCSC_StatusInfo(slotStatus, atr);
		}

		@Override
		public GemPCSC_StatusInfo[] newArray(int size) {
			return new GemPCSC_StatusInfo[size];
		}
	};

	@Override
	public int describeContents() {
		return 0;
	}

	@Override
	public void writeToParcel(Parcel dest, int flags) {
		dest.writeInt(slotStatus);
		dest.writeInt(atr.length);
		dest.writeByteArray(atr);
	}

	/**
	 * @return the slotStatus
	 */
	public int getSlotStatus() {
		return slotStatus;
	}

	/**
	 * @return the atr
	 */
	public byte[] getAtr() {
		return atr;
	}
}
