package elytraveldocumentforandroid;

public class ScannerPacket {

	private byte mCode;
	private int mLength;
	
	private byte [] mData;
	private int mDataPos = 0;
	
	public ScannerPacket(byte code, int length) {
		mCode = code;
		mLength = length;
		
		mData = new byte[mLength];
		mDataPos = 0;
	}
	
	public ScannerPacket(byte code, byte [] data) {
		mCode = code;
		mLength = data.length;
		
		mData = data;
		mDataPos = mLength;
	}
	
	public int addData(byte [] data, int offset, int length) {
		int toCopy = Math.min(mLength-mDataPos, length);
		
		System.arraycopy(data, offset, mData, mDataPos, toCopy);
		mDataPos += toCopy;
		return toCopy;
	}
	
	public boolean isComplete() {
		return mDataPos == mLength;
	}
	
	public byte getCode() {
		return mCode;
	}

	public int getLength(){	return mLength;	}
	
	public byte[] getData() {
		return mData;
	}
}
