/**
*-------------------------------------------------------
* Copyright (c) 2014 GEMALTO. All Rights Reserved.
*-------------------------------------------------------
*/

package com.gemalto.gempcsc;

import com.gemalto.gempcsc.GemPCSC_Reader;
import com.gemalto.gempcsc.GemPCSC_StatusInfo;

interface IGemPCSC
{
	 // Service management
	int GemPCSC_Initialize(); 
	void GemPCSC_Finalize(int sessionId);

	// Error management
	int GemPCSC_GetLastError();

	// GemPCSC Transaction management
	boolean GemPCSC_BeginTransaction(int sessionId);
	boolean GemPCSC_EndTransaction(int sessionId);

    // GemPCSC service methods
	GemPCSC_Reader[] GemPCSC_ListReaders(int sessionId);
	boolean GemPCSC_IsCardPresent(int sessionId);
	byte[] GemPCSC_Connect(int sessionId, in GemPCSC_Reader reader);
	boolean GemPCSC_Disconnect(int sessionId);
	boolean GemPCSC_IsConnected(int sessionId);
	byte[] GemPCSC_Transmit(int sessionId, in byte[]apduCommand);
	//byte[] GemPCSC_Control(int sessionId, int controlCode, in byte[]escapeCommand);
	GemPCSC_StatusInfo GemPCSC_Status(int sessionId);
}