/**
 *-------------------------------------------------------
 * Copyright (c) 2014 GEMALTO. All Rights Reserved.
 *-------------------------------------------------------
 */
package com.gemalto.gempcsc;

import android.os.Parcel;
import android.os.Parcelable;

public class GemPCSC_Reader implements Parcelable {

	private int PID;
	private String productName;
	private String readerName;
	private int slot;
	private String vendorName;
	private int vendorID;
	private boolean isMultiSlot;

	public GemPCSC_Reader(final int pid, final String productName,
			final String readerName, final int slot, final String vendorName,
			final int vendorID, final boolean isMultiSlot) {
		this.PID = pid;
		this.productName = productName;
		this.readerName = readerName;
		this.slot = slot;
		this.vendorName = vendorName;
		this.vendorID = vendorID;
		this.isMultiSlot = isMultiSlot;
	}

	public static final Parcelable.Creator<GemPCSC_Reader> CREATOR = new Parcelable.Creator<GemPCSC_Reader>() {

		@Override
		public GemPCSC_Reader createFromParcel(Parcel source) {
			return new GemPCSC_Reader(source.readInt(), source.readString(),
					source.readString(), source.readInt(), source.readString(),
					source.readInt(), source.readByte() == (byte) 0x01);
		}

		@Override
		public GemPCSC_Reader[] newArray(int size) {
			return new GemPCSC_Reader[size];
		}
	};

	@Override
	public int describeContents() {
		return 0;
	}

	@Override
	public void writeToParcel(Parcel dest, int flags) {
		dest.writeInt(PID);
		dest.writeString(productName);
		dest.writeString(readerName);
		dest.writeInt(slot);
		dest.writeString(vendorName);
		dest.writeInt(vendorID);
		dest.writeByte(isMultiSlot == true ? (byte) 0x01 : (byte) 0x00);
	}

	/**
	 * @return the pID
	 */
	public final int getPID() {
		return PID;
	}

	/**
	 * @return the productName
	 */
	public final String getProductName() {
		return productName;
	}

	/**
	 * @return the readerName
	 */
	public final String getReaderName() {
		return readerName;
	}

	/**
	 * @return the slotCount
	 */
	public final int getSlot() {
		return slot;
	}

	/**
	 * @return the vendorName
	 */
	public final String getVendorName() {
		return vendorName;
	}

	/**
	 * @return the vendorID
	 */
	public final int getVendorID() {
		return vendorID;
	}

	/**
	 * @return the isMultiSlot
	 */
	public boolean isMultiSlot() {
		return isMultiSlot;
	}
}
