package com.gen2wave.device.util.barcode;

import java.io.IOException;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.res.AssetFileDescriptor;
import android.media.AudioManager;
import android.media.MediaPlayer;
import android.os.Vibrator;
import android.preference.PreferenceManager;
import android.util.Log;

import com.gen2wave.g2w_scan_demo.R;

/**
 * Manages beeps and vibrations.
 */
public final class BeepManager {

    private static final String TAG = "BeepManager";

    private static final float BEEP_VOLUME = 0.02f;
    private static final long VIBRATE_DURATION = 100;

    private final Context mContext;
    private static final int PLAYER_NUM = 4;
    private MediaPlayer mMediaPlayer[] = new MediaPlayer[PLAYER_NUM];
    private SharedPreferences mPref;
    private int mPlayIdx = 0;

    public BeepManager(Context ctx) {
        mContext = ctx;
        for (int i = 0; i < PLAYER_NUM; i++)
            mMediaPlayer[i] = buildMediaPlayer(ctx);
        mPref = PreferenceManager.getDefaultSharedPreferences(ctx);
    }

    public void playBeepSoundAndVibrate() {
        if (mPref.getBoolean(Settings.PREF_BEEP, Settings.PREF_BEEP_DEF)) {
            MediaPlayer mp = null;
            int i;
            mp = mMediaPlayer[mPlayIdx];
            if (mp != null) {
                Log.v(TAG, "Start Beep "+mPlayIdx);
                mp.start();
            } else {
                Log.e(TAG, "Need another player");
            }

            // Reset the other one
            mPlayIdx = (mPlayIdx + 1) % PLAYER_NUM;
            mp = mMediaPlayer[mPlayIdx];
            if (mp != null)
                mp.seekTo(0);
        }
        if (mPref.getBoolean(Settings.PREF_VIBRATE, Settings.PREF_VIBRATE_DEF)) {
            Vibrator vibrator = (Vibrator) mContext.getSystemService(Context.VIBRATOR_SERVICE);
            vibrator.vibrate(VIBRATE_DURATION);
        }
    }

    private MediaPlayer buildMediaPlayer(Context activity) {
        MediaPlayer mediaPlayer = new MediaPlayer();
        mediaPlayer.setAudioStreamType(AudioManager.STREAM_NOTIFICATION);

        mediaPlayer.setOnErrorListener(new MediaPlayer.OnErrorListener() {
            @Override
            public boolean onError(MediaPlayer player, int what, int extra) {
                // TODO Auto-generated method stub
                Log.e(TAG, "what = "+what+", extra = "+extra);
                return false;
            }
        });

        AssetFileDescriptor file = activity.getResources().openRawResourceFd(R.raw.beep);
        try {
            mediaPlayer.setDataSource(file.getFileDescriptor(), file.getStartOffset(), file.getLength());
            file.close();
            mediaPlayer.setVolume(BEEP_VOLUME, BEEP_VOLUME);
            mediaPlayer.prepare();
        } catch (IOException ioe) {
            Log.w(TAG, ioe);
            mediaPlayer = null;
        }
        return mediaPlayer;
    }

    @Override
    protected void finalize() throws Throwable {
        for (int i = 0 ; i < mMediaPlayer.length; i++)
            if (mMediaPlayer[i] != null)
                mMediaPlayer[i].release();
        super.finalize();
    }
}
