package com.gen2wave.device.util.barcode;

import android.content.SharedPreferences;
import android.content.SharedPreferences.OnSharedPreferenceChangeListener;
import android.os.Bundle;
import android.preference.PreferenceActivity;
import android.preference.PreferenceManager;

import com.amarula.barcodescanner.sdk.BarcodeScannerSymbologyTable;

import com.gen2wave.g2w_scan_demo.R;
public class Settings extends PreferenceActivity
			implements OnSharedPreferenceChangeListener {

	public static final String  PREF_APPLY_CODE128_MIN		= "code128_min";
	public static final boolean PREF_APPLY_CODE128_MIN_DEF	= false;
	public static final String  PREF_BEEP					= "scan_beep";
	public static final boolean PREF_BEEP_DEF				= true;
	public static final String  PREF_VIBRATE				= "scan_vibrate";
	public static final boolean PREF_VIBRATE_DEF			= false;

	private SharedPreferences mPref;

	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);

		mPref = PreferenceManager.getDefaultSharedPreferences(this);
		mPref.registerOnSharedPreferenceChangeListener(this);

		addPreferencesFromResource(R.xml.settings);
	}

	public void onSharedPreferenceChanged(SharedPreferences sharedPreferences,
			String key) {
		if (PREF_APPLY_CODE128_MIN.equals(key)) {
			BarcodeScannerSymbologyTable.setSymbolMinMaxLength(getContentResolver(),
					"j", mPref.getBoolean(PREF_APPLY_CODE128_MIN,
							PREF_APPLY_CODE128_MIN_DEF) ? 10 : 3, 80);
		}
	}
}
